/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.camera;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.mirasense.scanditsdk.ScanditSDKDiagnostics;
import com.scandit.camera.SbCameraPreviewListener;
import com.scandit.camera.SbDeviceProperties;
import com.scandit.camera.focus.SbFocusStrategy;
import com.scandit.camera.focus.SbLegacyFocusStrategy;
import java.io.IOException;
import java.util.ArrayList;

public class SbCameraPreview
extends RelativeLayout
implements SurfaceHolder.Callback,
Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private static final int SHOW = 1;
    private static final int HIDE = 2;
    private static final int FAILED = 3;
    private static final int ADJUST = 4;
    private static final int FAILED_PREVIEW = 5;
    public static final int BACK_CAMERA = 0;
    public static final int FRONT_CAMERA = 1;
    private ArrayList<SbCameraPreviewListener> mListeners;
    private CameraInitThread mCameraInitThread = null;
    private boolean mInitThreadFinished = true;
    private boolean mSurfaceCreated = false;
    private boolean mStartPreviewOnSurfaceCreated = false;
    private boolean mAdjustedSubviewDimensions = false;
    private Camera mCamera = null;
    private int mCameraFacingPreference;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private boolean mAutoFocusing = false;
    private int mPreviewWidth;
    private int mPreviewHeight;
    private byte[] mPreviewBuffer;
    private int mDisplayOrientation = 0;
    private boolean mTorchOn = false;
    private boolean mSetTorchActive = false;
    private boolean mEnableAutoFocus = true;
    private SbFocusStrategy mFocusStrategy;
    private float mRelativeZoom = 0.0f;
    private int mZoom = 0;
    private int mMaxZoom = 0;
    private long mFrame = 0L;
    private static ProgressDialog mProgressDialog = null;
    private static Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            SbCameraPreview cameraPreview = (SbCameraPreview)((Object)msg.obj);
            if (msg.what == 1) {
                if (mProgressDialog == null) {
                    mProgressDialog = ProgressDialog.show((Context)cameraPreview.getContext(), (CharSequence)"Waiting for Camera", (CharSequence)"Media server died, waiting for it to restart...", (boolean)true, (boolean)false);
                }
            } else if (msg.what == 2) {
                if (mProgressDialog != null) {
                    mProgressDialog.dismiss();
                    mProgressDialog = null;
                }
            } else if (msg.what == 3) {
                AlertDialog.Builder builder = new AlertDialog.Builder(cameraPreview.getContext());
                builder.setTitle((CharSequence)"Camera Error");
                builder.setMessage((CharSequence)"The device failed to give access to the camera.");
                builder.setNeutralButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.create().show();
            } else if (msg.what == 4) {
                cameraPreview.adjustSubviewDimensions();
            } else if (msg.what == 5) {
                AlertDialog.Builder builder = new AlertDialog.Builder(cameraPreview.getContext());
                builder.setTitle((CharSequence)"Camera Error");
                builder.setMessage((CharSequence)"The camera failed to start the preview.");
                builder.setNeutralButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.create().show();
            }
        }
    };

    public SbCameraPreview(Context context) {
        this(context, 0);
    }

    public SbCameraPreview(Context context, int cameraPosition) {
        super(context);
        this.mCameraFacingPreference = cameraPosition;
        this.mListeners = new ArrayList();
        this.mFocusStrategy = new SbLegacyFocusStrategy();
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.setType(3);
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mPreviewWidth = 0;
        this.mPreviewHeight = 0;
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    public void addListener(SbCameraPreviewListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(SbCameraPreviewListener listener) {
        this.mListeners.remove(listener);
    }

    @TargetApi(value=9)
    private boolean hasBackCamera() {
        if (Build.VERSION.SDK_INT < 9) {
            return true;
        }
        int cameraCount = Camera.getNumberOfCameras();
        for (int i = 0; i < cameraCount; ++i) {
            try {
                Camera.CameraInfo info = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != 0) continue;
                return true;
            }
            catch (RuntimeException e) {
                return true;
            }
        }
        return false;
    }

    private boolean hasFrontCamera() {
        return this.getFirstFrontCamera() >= 0;
    }

    @TargetApi(value=9)
    private int getFirstFrontCamera() {
        if (Build.VERSION.SDK_INT < 9) {
            return -1;
        }
        int cameraCount = Camera.getNumberOfCameras();
        for (int i = 0; i < cameraCount; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != 1) continue;
            return i;
        }
        return -1;
    }

    public boolean supportsCamera(int cameraPosition) {
        if (cameraPosition == 1) {
            return this.hasFrontCamera();
        }
        return this.hasBackCamera();
    }

    public boolean changeCamera(int cameraPosition) {
        if (this.mCameraFacingPreference != cameraPosition && this.supportsCamera(cameraPosition)) {
            this.stopPreview();
            this.mCameraFacingPreference = cameraPosition;
            this.startPreview();
            return true;
        }
        return false;
    }

    public boolean switchCamera() {
        if (this.mCameraFacingPreference == 1) {
            return this.changeCamera(0);
        }
        return this.changeCamera(1);
    }

    public int getCameraPosition() {
        return this.mCameraFacingPreference;
    }

    public boolean isManualAutoFocusEnabled() {
        return this.mEnableAutoFocus & this.mFocusStrategy.shouldManuallyFocus(this.mCamera);
    }

    public void setAutoFocusEnabled(boolean enabled) {
        this.mEnableAutoFocus = enabled;
    }

    public int getPreviewWidth() {
        return this.mPreviewWidth;
    }

    public int getPreviewHeight() {
        return this.mPreviewHeight;
    }

    public int getDisplayOrientation() {
        return this.mDisplayOrientation;
    }

    public void dontAdjustSubviewDimensions() {
        this.mAdjustedSubviewDimensions = true;
    }

    private void adjustSubviewDimensions() {
        RelativeLayout.LayoutParams rParams;
        int width;
        int height;
        if (this.mAdjustedSubviewDimensions) {
            return;
        }
        int screenWidth = this.getWidth();
        int screenHeight = this.getHeight();
        if ((Build.MODEL.equals("LT22") || Build.MODEL.equals("LT22i") || Build.MODEL.equals("ST25") || Build.MODEL.equals("ST25i")) && screenHeight > screenWidth) {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            RelativeLayout.LayoutParams rParams2 = new RelativeLayout.LayoutParams(display.getWidth() * 20 / 20, display.getHeight() * 18 / 20);
            this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)rParams2);
            this.mAdjustedSubviewDimensions = true;
            return;
        }
        if (screenHeight > screenWidth) {
            float widthScale = (float)screenWidth / (float)this.mPreviewHeight;
            height = this.mPreviewWidth;
            width = this.mPreviewHeight;
            width = screenWidth;
            height = (int)((float)height * widthScale);
            height = Math.max(16, height - height % 8);
            rParams = new RelativeLayout.LayoutParams(width, height);
        } else {
            float heightScale = (float)screenHeight / (float)this.mPreviewHeight;
            height = this.mPreviewHeight;
            width = this.mPreviewWidth;
            height = screenHeight;
            width = (int)((float)width * heightScale);
            width = Math.max(16, width - width % 8);
            rParams = new RelativeLayout.LayoutParams(width, height);
        }
        rParams.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)rParams);
        for (SbCameraPreviewListener listener : this.mListeners) {
            listener.didResizePreview(rParams);
        }
        this.mAdjustedSubviewDimensions = true;
    }

    public boolean hasTorch() {
        return SbDeviceProperties.hasTorch(this.mCamera);
    }

    public void setFocusStrategy(SbFocusStrategy strategy) {
        if (strategy != null) {
            this.mFocusStrategy = strategy;
        }
    }

    public SbFocusStrategy getFocusStrategy() {
        return this.mFocusStrategy;
    }

    public String getFocusMode() {
        return this.mFocusStrategy.getFocusMode(this.mCamera);
    }

    private void autoFocusIfNeeded(boolean needsFocus) {
        if (this.isManualAutoFocusEnabled() && !this.isAutoFocusing() && this.mFocusStrategy.shouldAutoFocus(this.mFrame, needsFocus)) {
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
            this.mAutoFocusing = true;
        }
    }

    public boolean isAutoFocusing() {
        return this.mAutoFocusing;
    }

    public void setZoom(float zoomPercentage) {
        this.mRelativeZoom = zoomPercentage;
        this.mZoom = 0;
        if (this.mCamera != null) {
            this.changeToZoom((int)(zoomPercentage * (float)this.mMaxZoom));
        }
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
        this.mRelativeZoom = 0.0f;
        if (this.mCamera != null) {
            this.changeToZoom(zoom);
        }
    }

    private void changeToZoom(int zoom) {
        if (this.mCamera != null) {
            int actualZoom = Math.max(0, Math.min(zoom, this.mMaxZoom));
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (parameters.isZoomSupported()) {
                parameters.setZoom(actualZoom);
                try {
                    this.mCamera.setParameters(parameters);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isTorchBeingSet() {
        return this.mSetTorchActive;
    }

    @TargetApi(value=8)
    public void setTorchEnabled(boolean enabled) {
        this.mTorchOn = enabled;
        if (this.mCamera == null || this.mSetTorchActive) {
            return;
        }
        this.mSetTorchActive = true;
        if (SbDeviceProperties.shouldRestartCameraOnTorchSwitch()) {
            if (Build.VERSION.SDK_INT < 8) {
                this.mCamera.setPreviewCallback(null);
            } else {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mStartPreviewOnSurfaceCreated = true;
            this.surfaceCreated(this.mSurfaceHolder);
            this.surfaceChanged(this.mSurfaceHolder, 0, 0, 0);
        } else {
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (SbDeviceProperties.hasTorch(this.mCamera)) {
                if (this.mTorchOn) {
                    parameters.setFlashMode(SbDeviceProperties.getFlashModeForTorch(this.mCamera));
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
            }
            this.mSetTorchActive = false;
        }
    }

    @TargetApi(value=8)
    public void onPreviewFrame(byte[] data, Camera camera) {
        ++this.mFrame;
        if (this.mFrame < 0L) {
            this.mFrame = 0L;
        }
        for (SbCameraPreviewListener listener : this.mListeners) {
            boolean needsFocus = listener.onPreviewFrame(data, camera);
            this.autoFocusIfNeeded(needsFocus);
        }
        if (Build.VERSION.SDK_INT >= 8 && this.mCamera != null) {
            this.mCamera.addCallbackBuffer(this.mPreviewBuffer);
        }
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.mAutoFocusing = false;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceCreated = true;
        if (this.mStartPreviewOnSurfaceCreated) {
            this.startPreview();
        }
    }

    public void startPreview() {
        if (this.mSurfaceCreated) {
            if (this.mCameraInitThread == null && this.mCamera == null) {
                this.mCameraInitThread = new CameraInitThread();
                this.mInitThreadFinished = false;
                this.mCameraInitThread.start();
            }
        } else {
            this.mStartPreviewOnSurfaceCreated = true;
        }
    }

    public void stopPreview() {
        while (!this.mInitThreadFinished) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mCamera != null) {
            if (Build.VERSION.SDK_INT < 8) {
                this.mCamera.setPreviewCallback(null);
            } else {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
        this.mPreviewBuffer = null;
    }

    public boolean isCameraBeingStarted() {
        return !this.mInitThreadFinished;
    }

    @TargetApi(value=8)
    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mSurfaceCreated = false;
        if (this.mCamera != null) {
            if (Build.VERSION.SDK_INT < 8) {
                this.mCamera.setPreviewCallback(null);
            } else {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
        for (SbCameraPreviewListener listener : this.mListeners) {
            listener.didDestroyPreview();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    static /* synthetic */ byte[] access$1902(SbCameraPreview x0, byte[] x1) {
        x0.mPreviewBuffer = x1;
        return x1;
    }

    @TargetApi(value=14)
    private class CameraInitThread
    extends Thread {
        private CameraInitThread() {
        }

        public void run() {
            if (SbCameraPreview.this.mCamera == null) {
                this.startCamera();
                this.initCamera();
            }
            SbCameraPreview.this.mCameraInitThread = null;
            SbCameraPreview.this.mInitThreadFinished = true;
        }

        private void startCamera() {
            try {
                this.openCamera();
            }
            catch (Exception e) {
                ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
                diagnostics.addException("failed to open camera", e);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    this.openCamera();
                }
                catch (Exception e2) {
                    diagnostics.addException("failed to open camera again.", e2);
                    mHandler.sendMessage(Message.obtain((Handler)mHandler, (int)3, (Object)((Object)SbCameraPreview.this)));
                    SbCameraPreview.this.mCamera = null;
                    return;
                }
            }
            int count = 0;
            while (SbCameraPreview.this.mCamera == null && count < 100) {
                mHandler.sendMessage(Message.obtain((Handler)mHandler, (int)1, (Object)((Object)SbCameraPreview.this)));
                ++count;
                this.openCamera();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
            mHandler.sendMessage(Message.obtain((Handler)mHandler, (int)2, (Object)((Object)SbCameraPreview.this)));
            if (SbCameraPreview.this.mCamera == null) {
                return;
            }
            try {
                if (!SbDeviceProperties.canDisplayProperPortraitCameraPreview()) {
                    SbCameraPreview.this.mDisplayOrientation = 0;
                } else {
                    Display display = ((WindowManager)SbCameraPreview.this.getContext().getSystemService("window")).getDefaultDisplay();
                    float scale = (float)display.getHeight() / (float)display.getWidth();
                    if (display.getRotation() == 0) {
                        if (scale <= 1.0f) {
                            SbCameraPreview.this.mDisplayOrientation = 0;
                        } else {
                            SbCameraPreview.this.mDisplayOrientation = 90;
                        }
                    } else if (display.getRotation() == 1) {
                        if (scale >= 1.0f) {
                            SbCameraPreview.this.mDisplayOrientation = 270;
                        } else if (Build.MODEL.equals("Micromax P650")) {
                            SbCameraPreview.this.mDisplayOrientation = 180;
                        } else {
                            SbCameraPreview.this.mDisplayOrientation = 0;
                        }
                    } else if (display.getRotation() == 2) {
                        if (scale <= 1.0f) {
                            SbCameraPreview.this.mDisplayOrientation = 180;
                        } else {
                            SbCameraPreview.this.mDisplayOrientation = 270;
                        }
                    } else if (display.getRotation() == 3) {
                        if (scale >= 1.0f) {
                            SbCameraPreview.this.mDisplayOrientation = 90;
                        } else if (Build.MODEL.equals("Micromax P650")) {
                            SbCameraPreview.this.mDisplayOrientation = 0;
                        } else {
                            SbCameraPreview.this.mDisplayOrientation = 180;
                        }
                    }
                }
                SbCameraPreview.this.mCamera.setDisplayOrientation(SbCameraPreview.this.mDisplayOrientation);
                SbCameraPreview.this.mCamera.setPreviewDisplay(SbCameraPreview.this.mSurfaceHolder);
            }
            catch (IOException e) {
                ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
                diagnostics.addException("failed to set camera parameters", e);
                SbCameraPreview.this.mCamera.release();
                SbCameraPreview.this.mCamera = null;
            }
            for (SbCameraPreviewListener listener : SbCameraPreview.this.mListeners) {
                listener.didOpenCamera();
            }
            SbCameraPreview.this.mFocusStrategy.reset();
        }

        private void openCamera() {
            if (SbCameraPreview.this.mCameraFacingPreference == 1 && SbCameraPreview.this.hasFrontCamera()) {
                SbCameraPreview.this.mCamera = Camera.open((int)SbCameraPreview.this.getFirstFrontCamera());
            } else if (SbCameraPreview.this.hasBackCamera()) {
                SbCameraPreview.this.mCamera = Camera.open();
                SbCameraPreview.this.mCameraFacingPreference = 0;
            } else if (SbCameraPreview.this.hasFrontCamera()) {
                SbCameraPreview.this.mCamera = Camera.open((int)SbCameraPreview.this.getFirstFrontCamera());
                SbCameraPreview.this.mCameraFacingPreference = 1;
            } else {
                SbCameraPreview.this.mCamera = Camera.open();
                SbCameraPreview.this.mCameraFacingPreference = 0;
            }
        }

        private void initCamera() {
            if (SbCameraPreview.this.mCamera == null) {
                SbCameraPreview.this.mSetTorchActive = false;
                return;
            }
            WindowManager wm = (WindowManager)SbCameraPreview.this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            int[] preview_size = SbDeviceProperties.determinePreviewResolutionToUse(SbCameraPreview.this.mCamera, display.getWidth(), display.getHeight());
            if (preview_size[0] == 0) {
                String m = "No images can be recognized, since your device supports no camera preview images.";
                Log.e((String)"ScanditSDK", (String)m);
            }
            Camera.Parameters parameters = SbCameraPreview.this.mCamera.getParameters();
            int frame_rate = SbDeviceProperties.determinePreviewFrameRate(SbCameraPreview.this.mCamera);
            if (Build.MODEL.equals("VM670")) {
                preview_size[0] = 640;
                preview_size[1] = 480;
                frame_rate = 5;
            } else if (Build.MODEL.equals("SAMSUNG-SGH-I717")) {
                preview_size[0] = 640;
                preview_size[1] = 480;
            }
            if (Build.MODEL.startsWith("Glass")) {
                parameters.setPreviewFpsRange(30000, 30000);
            } else if (frame_rate > 0) {
                // empty if block
            }
            parameters.setPreviewSize(preview_size[0], preview_size[1]);
            SbCameraPreview.this.mPreviewWidth = preview_size[0];
            SbCameraPreview.this.mPreviewHeight = preview_size[1];
            mHandler.sendMessage(Message.obtain((Handler)mHandler, (int)4, (Object)((Object)SbCameraPreview.this)));
            if (SbCameraPreview.this.hasTorch()) {
                if (SbCameraPreview.this.mTorchOn) {
                    parameters.setFlashMode(SbDeviceProperties.getFlashModeForTorch(SbCameraPreview.this.mCamera));
                } else {
                    parameters.setFlashMode("off");
                }
            }
            ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
            diagnostics.addValue("resolution", new int[]{SbCameraPreview.this.mPreviewWidth, SbCameraPreview.this.mPreviewHeight});
            diagnostics.addValue("frame rate", frame_rate);
            diagnostics.addValue("torch", SbDeviceProperties.hasTorch(SbCameraPreview.this.mCamera));
            try {
                SbCameraPreview.this.mCamera.setParameters(parameters);
            }
            catch (Exception e) {
                diagnostics.addException("failed to set camera parameters", e);
                e.printStackTrace();
            }
            if (Build.VERSION.SDK_INT >= 8) {
                int bytesPerPixel = (int)Math.ceil((float)ImageFormat.getBitsPerPixel((int)17) / 8.0f);
                SbCameraPreview.access$1902(SbCameraPreview.this, new byte[SbCameraPreview.this.mPreviewWidth * SbCameraPreview.this.mPreviewHeight * bytesPerPixel]);
                SbCameraPreview.this.mCamera.addCallbackBuffer(SbCameraPreview.this.mPreviewBuffer);
            }
            if (SbCameraPreview.this.mEnableAutoFocus) {
                try {
                    String focusMode = SbCameraPreview.this.mFocusStrategy.getFocusMode(SbCameraPreview.this.mCamera);
                    if (focusMode != null) {
                        parameters.setFocusMode(focusMode);
                        SbCameraPreview.this.mCamera.setParameters(parameters);
                    }
                    diagnostics.addValue("focus mode", "strategy");
                }
                catch (Exception e) {
                    diagnostics.addValue("focus mode", "failed");
                    e.printStackTrace();
                }
            }
            if (parameters.isZoomSupported()) {
                SbCameraPreview.this.mMaxZoom = parameters.getMaxZoom();
                int targetZoom = SbCameraPreview.this.mZoom;
                if (SbCameraPreview.this.mRelativeZoom > 0.0f) {
                    targetZoom = (int)(SbCameraPreview.this.mRelativeZoom * (float)SbCameraPreview.this.mMaxZoom);
                }
                if (targetZoom > 0) {
                    parameters.setZoom(targetZoom);
                    try {
                        SbCameraPreview.this.mCamera.setParameters(parameters);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (Build.VERSION.SDK_INT >= 14 && Build.MODEL.equals("Nexus 4")) {
                try {
                    parameters.setRecordingHint(true);
                    SbCameraPreview.this.mCamera.setParameters(parameters);
                    diagnostics.addValue("recording hint", true);
                }
                catch (Exception e) {
                    diagnostics.addValue("recording hint", false);
                    e.printStackTrace();
                }
            }
            if (Build.VERSION.SDK_INT < 8) {
                SbCameraPreview.this.mCamera.setPreviewCallback((Camera.PreviewCallback)SbCameraPreview.this);
            } else {
                SbCameraPreview.this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)SbCameraPreview.this);
            }
            SbCameraPreview.this.mAutoFocusing = false;
            try {
                SbCameraPreview.this.mCamera.startPreview();
            }
            catch (Exception e) {
                diagnostics.addException("failed to start camera preview", e);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    SbCameraPreview.this.mCamera.startPreview();
                }
                catch (Exception e2) {
                    diagnostics.addException("failed to start camera preview again", e2);
                    mHandler.sendMessage(Message.obtain((Handler)mHandler, (int)5, (Object)((Object)SbCameraPreview.this)));
                    if (SbCameraPreview.this.mCamera != null) {
                        if (Build.VERSION.SDK_INT < 8) {
                            SbCameraPreview.this.mCamera.setPreviewCallback(null);
                        } else {
                            SbCameraPreview.this.mCamera.setPreviewCallbackWithBuffer(null);
                        }
                        SbCameraPreview.this.mCamera.release();
                        SbCameraPreview.this.mCamera = null;
                    }
                    return;
                }
            }
            SbCameraPreview.this.mSetTorchActive = false;
        }
    }
}

