/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.DisplayMetrics;
import com.mirasense.scanditsdk.ScanditSDKDiagnostics;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbDeviceProperties {
    public static int getOSVersion(int defaultOs) {
        return Build.VERSION.SDK_INT;
    }

    @TargetApi(value=9)
    public static boolean isTabletDevice(Context activityContext) {
        boolean xlarge = false;
        if (Build.VERSION.SDK_INT >= 9) {
            boolean bl = xlarge = (activityContext.getResources().getConfiguration().screenLayout & 0xF) == 4;
        }
        if (xlarge) {
            DisplayMetrics metrics = new DisplayMetrics();
            Activity activity = (Activity)activityContext;
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            if (metrics.densityDpi == 160 || metrics.densityDpi == 240 || metrics.densityDpi == 160 || metrics.densityDpi == 213 || metrics.densityDpi == 320) {
                return true;
            }
        }
        return false;
    }

    protected static int determinePreviewFrameRate(Camera camera) {
        int i;
        List supported_frame_rates = null;
        try {
            Camera.Parameters p = camera.getParameters();
            supported_frame_rates = p.getSupportedPreviewFrameRates();
        }
        catch (Exception e) {
            return -1;
        }
        if (supported_frame_rates == null) {
            return -1;
        }
        ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
        int[] frameRates = new int[supported_frame_rates.size()];
        for (i = 0; i < frameRates.length; ++i) {
            frameRates[i] = (Integer)supported_frame_rates.get(i);
        }
        diagnostics.addValue("supported frame rates", frameRates);
        if (supported_frame_rates == null || supported_frame_rates.size() == 0) {
            return -1;
        }
        i = SbDeviceProperties.getIndexOfHighestImageFrameRate(supported_frame_rates, 15);
        if (i >= 0) {
            return (Integer)supported_frame_rates.get(i);
        }
        i = SbDeviceProperties.getIndexOfHighestImageFrameRate(supported_frame_rates, 1000);
        if (i >= 0) {
            return (Integer)supported_frame_rates.get(i);
        }
        return 15;
    }

    protected static int[] determinePreviewResolutionToUse(Camera camera, int screenWidth, int screenHeight) {
        ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
        diagnostics.addValue("screen resolution", new int[]{screenWidth, screenHeight});
        List l = null;
        Camera.Size[] supportedSizes = null;
        try {
            Camera.Parameters p = camera.getParameters();
            Method get_preview_sizes = p.getClass().getMethod("getSupportedPreviewSizes", null);
            l = (List)get_preview_sizes.invoke((Object)p, (Object[])null);
            supportedSizes = new Camera.Size[l.size()];
            l.toArray(supportedSizes);
            int[][] resolutions = new int[supportedSizes.length][2];
            for (int i = 0; i < supportedSizes.length; ++i) {
                resolutions[i][0] = supportedSizes[i].width;
                resolutions[i][1] = supportedSizes[i].height;
            }
            diagnostics.addValue("supported resolutions", resolutions);
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] result = new int[]{320, 240};
            diagnostics.addValue("selected resolution", new int[]{result[0], result[1]});
            return result;
        }
        int[] result = new int[]{0, 0};
        if (l == null || supportedSizes == null || l.size() == 0) {
            diagnostics.addValue("selected resolution", new int[]{result[0], result[1]});
            return result;
        }
        int i = SbDeviceProperties.getIndexOfBestFittingImageHeightResolution(supportedSizes, screenWidth, screenHeight);
        if (i >= 0) {
            result[0] = supportedSizes[i].width;
            result[1] = supportedSizes[i].height;
            diagnostics.addValue("selected resolution", result);
            return result;
        }
        diagnostics.addValue("selected resolution", result);
        return result;
    }

    private static int getIndexOfHighestImageFrameRate(List<Integer> supported_frame_rates, int max_frame_rate) {
        int index = -1;
        int frame_rate = 0;
        for (int i = 0; i < supported_frame_rates.size(); ++i) {
            if (supported_frame_rates.get(i) <= frame_rate || supported_frame_rates.get(i) > max_frame_rate) continue;
            frame_rate = supported_frame_rates.get(i);
            index = i;
        }
        return index;
    }

    private static int getIndexOfBestFittingImageHeightResolution(Camera.Size[] supported_sizes, int screenWidth, int screenHeight) {
        float screenRatio = screenWidth > screenHeight ? (float)screenWidth / (float)screenHeight : (float)screenHeight / (float)screenWidth;
        int index = -1;
        float bestRatioDiff = 1.0f;
        int largestArea = 0;
        for (int i = 0; i < supported_sizes.length; ++i) {
            float ratio = supported_sizes[i].width > supported_sizes[i].height ? (float)supported_sizes[i].width / (float)supported_sizes[i].height : (float)supported_sizes[i].height / (float)supported_sizes[i].width;
            int longSide = Math.max(supported_sizes[i].width, supported_sizes[i].height);
            int shortSide = Math.min(supported_sizes[i].width, supported_sizes[i].height);
            float ratioDiff = Math.abs(screenRatio - ratio);
            int area = supported_sizes[i].width * supported_sizes[i].height;
            if (Build.MODEL.startsWith("Glass") && area > largestArea) {
                index = i;
                bestRatioDiff = ratioDiff;
                largestArea = area;
                continue;
            }
            if (!((double)ratioDiff + 0.3 < (double)bestRatioDiff) && (!((double)ratioDiff < (double)bestRatioDiff + 0.1) || area <= largestArea) || longSide > 1280 || shortSide > 720 || Build.MODEL.equals("XT890") && longSide == 1024 || Build.MODEL.equals("HTC Desire") && longSide == 1280) continue;
            index = i;
            bestRatioDiff = ratioDiff;
            largestArea = area;
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public static boolean hasTorch(Camera camera) {
        if (camera == null) {
            return false;
        }
        return !SbDeviceProperties.getFlashModeForTorch(camera).equals("off");
    }

    public static String getFlashModeForTorch(Camera camera) {
        List modes = camera.getParameters().getSupportedFlashModes();
        if (modes != null && !Build.MODEL.equals("GT-P1000") && !Build.MODEL.equals("HTC One X") && (modes.contains("torch") || modes.contains("on"))) {
            if (modes.contains("torch")) {
                return "torch";
            }
            return "on";
        }
        return "off";
    }

    public static boolean canDisplayProperPortraitCameraPreview() {
        return Build.VERSION.SDK_INT >= 8 && !Build.MODEL.equals("GT-P1000") && !Build.MODEL.equals("GT-P1010") && !Build.MODEL.equals("GT-S5360") && !Build.MODEL.equals("GT-S5830") && !Build.MODEL.equals("GT-S5830i") && !Build.MODEL.startsWith("GT-S6102") && !Build.MODEL.equals("YP-G70") && !Build.MODEL.equals("MT27i");
    }

    public static boolean shouldRestartCameraOnTorchSwitch() {
        return true;
    }
}

