/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.camera;

import android.content.Context;
import android.os.StatFs;
import java.io.File;

public class SbSystemUtils {
    public static int pxFromDp(Context context, int dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dp * scale + 0.5f);
    }

    public static long getAvailableSpaceInBytes(File directory) {
        long availableSpace = -1L;
        StatFs stat = new StatFs(directory.getPath());
        availableSpace = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        return availableSpace;
    }

    public static long getAvailableSpaceInKB(File directory) {
        long SIZE_KB = 1024L;
        long availableSpace = -1L;
        StatFs stat = new StatFs(directory.getPath());
        availableSpace = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        return availableSpace / 1024L;
    }

    public static long getAvailableSpaceInMB(File directory) {
        long SIZE_KB = 1024L;
        long SIZE_MB = 0x100000L;
        long availableSpace = -1L;
        StatFs stat = new StatFs(directory.getPath());
        availableSpace = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        return availableSpace / 0x100000L;
    }

    public static long getAvailableSpaceInGB(File directory) {
        long SIZE_KB = 1024L;
        long SIZE_GB = 0x40000000L;
        long availableSpace = -1L;
        StatFs stat = new StatFs(directory.getPath());
        availableSpace = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        return availableSpace / 0x40000000L;
    }
}

