/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.camera.focus;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import com.scandit.camera.focus.SbFocusStrategy;
import java.util.List;

public class SbLegacyFocusStrategy
implements SbFocusStrategy {
    private static final int AUTOFOCUS_FRAME_TRIGGER_THRESHOLD = 12;
    private long mLastAutoFocusFrame = 0L;
    private boolean mDidFocusSinceCameraStart = false;

    public void reset() {
        this.mLastAutoFocusFrame = 0L;
        this.mDidFocusSinceCameraStart = false;
    }

    @TargetApi(value=14)
    public String getFocusMode(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List focusModes = parameters.getSupportedFocusModes();
        if (Build.VERSION.SDK_INT >= 14 && this.shouldUseAlternateFocusMode() && focusModes.contains("continuous-picture")) {
            return "continuous-picture";
        }
        if (Build.VERSION.SDK_INT >= 9 && this.shouldUseAlternateFocusMode() && focusModes.contains("continuous-video")) {
            return "continuous-video";
        }
        if (focusModes.contains("macro")) {
            return "macro";
        }
        if (focusModes.contains("auto")) {
            return "auto";
        }
        return null;
    }

    public boolean shouldAutoFocus(long frame, boolean needsFocus) {
        if (!this.mDidFocusSinceCameraStart) {
            this.mDidFocusSinceCameraStart = true;
            return true;
        }
        long framesSinceLastFocus = frame - this.mLastAutoFocusFrame;
        if (!this.mDidFocusSinceCameraStart || needsFocus && framesSinceLastFocus > 12L) {
            this.mLastAutoFocusFrame = frame;
            return true;
        }
        return false;
    }

    public boolean shouldManuallyFocus(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List focusModes = parameters.getSupportedFocusModes();
        if (Build.VERSION.SDK_INT >= 14 && this.shouldUseAlternateFocusMode() && focusModes.contains("continuous-picture")) {
            return false;
        }
        return Build.VERSION.SDK_INT < 9 || !this.shouldUseAlternateFocusMode() || !focusModes.contains("continuous-video");
    }

    private boolean shouldUseAlternateFocusMode() {
        return Build.MODEL.contains("HTC One") || Build.MODEL.startsWith("HTC_PN071") || Build.MODEL.equals("SAMSUNG-SGH-I547");
    }
}

