/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.service.impl;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.service.impl.AbstractService;
import com.alibaba.dubbo.governance.sync.util.Pair;
import com.alibaba.dubbo.governance.sync.util.SyncUtils;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.route.ParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderServiceImpl
extends AbstractService
implements ProviderService {
    @Autowired
    OverrideService overrideService;

    public void create(Provider provider) {
        URL url = provider.toUrl();
        this.registryService.register(url);
    }

    public void enableProvider(Long id) {
        if (id == null) {
            throw new IllegalStateException("no provider id");
        }
        Provider oldProvider = this.findProvider(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        if (oldProvider.isDynamic()) {
            if (!oldProvider.isEnabled()) {
                Override override = new Override();
                override.setAddress(oldProvider.getAddress());
                override.setService(oldProvider.getService());
                override.setEnabled(true);
                override.setParams("disabled=false");
                this.overrideService.saveOverride(override);
                return;
            }
            List oList = this.overrideService.findByServiceAndAddress(oldProvider.getService(), oldProvider.getAddress());
            for (Override o : oList) {
                Map params = StringUtils.parseQueryString((String)o.getParams());
                if (!params.containsKey("disabled") || !((String)params.get("disabled")).equals("true")) continue;
                this.overrideService.deleteOverride(o.getId());
            }
        } else {
            oldProvider.setEnabled(true);
            this.updateProvider(oldProvider);
        }
    }

    public void disableProvider(Long id) {
        if (id == null) {
            throw new IllegalStateException("no provider id");
        }
        Provider oldProvider = this.findProvider(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        if (oldProvider.isDynamic()) {
            if (oldProvider.isEnabled()) {
                Override override = new Override();
                override.setAddress(oldProvider.getAddress());
                override.setService(oldProvider.getService());
                override.setEnabled(true);
                override.setParams("disabled=true");
                this.overrideService.saveOverride(override);
                return;
            }
            List oList = this.overrideService.findByServiceAndAddress(oldProvider.getService(), oldProvider.getAddress());
            for (Override o : oList) {
                Map params = StringUtils.parseQueryString((String)o.getParams());
                if (!params.containsKey("disabled") || !((String)params.get("disabled")).equals("false")) continue;
                this.overrideService.deleteOverride(o.getId());
            }
        } else {
            oldProvider.setEnabled(false);
            this.updateProvider(oldProvider);
        }
    }

    public void doublingProvider(Long id) {
        this.setWeight(id, 2.0f);
    }

    public void halvingProvider(Long id) {
        this.setWeight(id, 0.5f);
    }

    public void setWeight(Long id, float factor) {
        if (id == null) {
            throw new IllegalStateException("no provider id");
        }
        Provider oldProvider = this.findProvider(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        Map map = StringUtils.parseQueryString((String)oldProvider.getParameters());
        String weight = (String)map.get("weight");
        if (oldProvider.isDynamic()) {
            List overrides = this.overrideService.findByServiceAndAddress(oldProvider.getService(), oldProvider.getAddress());
            if (overrides == null || overrides.size() == 0) {
                int value = this.getWeight(weight, factor);
                if (value != 100) {
                    Override override = new Override();
                    override.setAddress(oldProvider.getAddress());
                    override.setService(oldProvider.getService());
                    override.setEnabled(true);
                    override.setParams("weight=" + String.valueOf(value));
                    this.overrideService.saveOverride(override);
                }
            } else {
                for (Override override : overrides) {
                    int value;
                    Map params = StringUtils.parseQueryString((String)override.getParams());
                    String overrideWeight = (String)params.get("weight");
                    if (overrideWeight == null || overrideWeight.length() == 0) {
                        overrideWeight = weight;
                    }
                    if ((value = this.getWeight(overrideWeight, factor)) == this.getWeight(weight, 1.0f)) {
                        params.remove("weight");
                    } else {
                        params.put("weight", String.valueOf(value));
                    }
                    if (params.size() > 0) {
                        override.setParams(StringUtils.toQueryString((Map)params));
                        this.overrideService.updateOverride(override);
                        continue;
                    }
                    this.overrideService.deleteOverride(override.getId());
                }
            }
        } else {
            int value = this.getWeight(weight, factor);
            if (value == 100) {
                map.remove("weight");
            } else {
                map.put("weight", String.valueOf(value));
            }
            oldProvider.setParameters(StringUtils.toQueryString((Map)map));
            this.updateProvider(oldProvider);
        }
    }

    private int getWeight(String value, float factor) {
        int weight = 100;
        if (value != null && value.length() > 0) {
            weight = Integer.parseInt(value);
        }
        if ((weight = (int)((float)weight * factor)) < 1) {
            weight = 1;
        }
        if (weight == 2) {
            weight = 3;
        }
        if (weight == 24) {
            weight = 25;
        }
        return weight;
    }

    public void deleteStaticProvider(Long id) {
        URL oldProvider = this.findProviderUrl(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        this.registryService.unregister(oldProvider);
    }

    public void updateProvider(Provider provider) {
        Long id = provider.getId();
        if (id == null) {
            throw new IllegalStateException("no provider id");
        }
        URL oldProvider = this.findProviderUrl(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        URL newProvider = provider.toUrl();
        this.registryService.unregister(oldProvider);
        this.registryService.register(newProvider);
    }

    public Provider findProvider(Long id) {
        return SyncUtils.url2Provider((Pair)this.findProviderUrlPair(id));
    }

    public Pair<Long, URL> findProviderUrlPair(Long id) {
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), (String)"providers", (Long)id);
    }

    public List<String> findServices() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls != null) {
            ret.addAll(providerUrls.keySet());
        }
        return ret;
    }

    public List<String> findAddresses() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getAddress();
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<String> findAddressesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                String addr;
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application")) || (addr = u.getAddress()) == null) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    public List<String> findAddressesByService(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        for (Map.Entry e2 : ((Map)providerUrls.get(service)).entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getAddress();
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<String> findApplicationsByServiceName(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        Map value = (Map)providerUrls.get(service);
        if (value == null) {
            return ret;
        }
        for (Map.Entry e2 : value.entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getParameter("application");
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<Provider> findByService(String serviceName) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByService(serviceName));
    }

    private Map<Long, URL> findProviderUrlByService(String service) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".service", service);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Provider> findAll() {
        return SyncUtils.url2ProviderList((Map)this.findAllProviderUrl());
    }

    private Map<Long, URL> findAllProviderUrl() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Provider> findByAddress(String providerAddress) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByAddress(providerAddress));
    }

    public Map<Long, URL> findProviderUrlByAddress(String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".address", address);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findServicesByAddress(String address) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || address == null || address.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!address.equals(u.getAddress())) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    public List<String> findApplications() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null) {
            return ret;
        }
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getParameter("application");
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<Provider> findByApplication(String application) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByApplication(application));
    }

    private Map<Long, URL> findProviderUrlByApplication(String application) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put("application", application);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findServicesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || application == null || application.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application"))) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    public List<String> findMethodsByService(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || service == null || service.length() == 0) {
            return ret;
        }
        Map providers = (Map)providerUrls.get(service);
        if (null == providers || providers.isEmpty()) {
            return ret;
        }
        Map.Entry p = providers.entrySet().iterator().next();
        String value = ((URL)p.getValue()).getParameter("methods");
        if (value == null || value.length() == 0) {
            return ret;
        }
        String[] methods = value.split(ParseUtils.METHOD_SPLIT);
        if (methods == null || methods.length == 0) {
            return ret;
        }
        for (String m : methods) {
            ret.add(m);
        }
        return ret;
    }

    private URL findProviderUrl(Long id) {
        return this.findProvider(id).toUrl();
    }

    public Provider findByServiceAndAddress(String service, String address) {
        return SyncUtils.url2Provider((Pair)this.findProviderUrl(service, address));
    }

    private Pair<Long, URL> findProviderUrl(String service, String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".address", address);
        Map ret = SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
        if (ret.isEmpty()) {
            return null;
        }
        Long key = (Long)ret.entrySet().iterator().next().getKey();
        return new Pair((Object)key, ret.get(key));
    }
}

