/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.status;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabaseStatusChecker
implements StatusChecker {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseStatusChecker.class);
    private int version;
    private String message;
    @Autowired
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status check() {
        boolean ok;
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = metaData.getTypeInfo();
                try {
                    ok = resultSet.next();
                }
                finally {
                    resultSet.close();
                }
                if (this.message == null) {
                    this.message = metaData.getURL() + " (" + metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion() + ", " + this.getIsolation(metaData.getDefaultTransactionIsolation()) + ")";
                }
                if (this.version == 0) {
                    this.version = metaData.getDatabaseMajorVersion();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            ok = false;
        }
        return new Status(!ok ? Status.Level.ERROR : (this.version < 5 ? Status.Level.WARN : Status.Level.OK), this.message);
    }

    private String getIsolation(int i) {
        if (i == 2) {
            return "READ_COMMITTED";
        }
        if (i == 1) {
            return "READ_UNCOMMITTED";
        }
        if (i == 4) {
            return "REPEATABLE_READ";
        }
        if (i == 8) {
            return "SERIALIZABLE)";
        }
        return "NONE";
    }
}

