/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.status;

import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class LoadStatusChecker
implements StatusChecker {
    public Status check() {
        double load;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method method = OperatingSystemMXBean.class.getMethod("getSystemLoadAverage", new Class[0]);
            load = (Double)method.invoke((Object)operatingSystemMXBean, new Object[0]);
        }
        catch (Throwable e) {
            load = -1.0;
        }
        int cpu = operatingSystemMXBean.getAvailableProcessors();
        return new Status(load < 0.0 ? Status.Level.UNKNOWN : (load < (double)cpu ? Status.Level.OK : Status.Level.WARN), "Load: " + load + " / CPU: " + cpu);
    }
}

