/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.interceptor;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.dubbo.governance.web.common.i18n.LocaleUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class LocaleValve
extends AbstractValve {
    @Autowired
    private HttpServletRequest request;
    private static final Set<String> TARGET_WITHOUT_CHECK = new HashSet();

    private boolean ignoreTarget(String target) {
        return TARGET_WITHOUT_CHECK.contains(target);
    }

    protected void init() throws Exception {
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData((HttpServletRequest)this.request);
        if (this.ignoreTarget(rundata.getTarget())) {
            pipelineContext.invokeNext();
            return;
        }
        String[] temp = rundata.getCookies().getStrings("locale");
        String locale = null;
        if (temp != null) {
            if (temp.length > 1) {
                locale = temp[temp.length - 1];
            } else if (temp.length == 1) {
                locale = temp[0];
            }
        }
        if (locale == null || "".equals(locale)) {
            locale = "zh";
        }
        Locale newLocale = Locale.SIMPLIFIED_CHINESE;
        if ("en".equals(locale)) {
            newLocale = Locale.ENGLISH;
        } else if ("zh".equals(locale)) {
            newLocale = Locale.SIMPLIFIED_CHINESE;
        } else if ("zh_TW".equals(locale)) {
            newLocale = Locale.TRADITIONAL_CHINESE;
        }
        LocaleUtil.setLocale((Locale)newLocale);
        pipelineContext.invokeNext();
    }

    static {
        TARGET_WITHOUT_CHECK.add("/ok");
        TARGET_WITHOUT_CHECK.add("/error");
        TARGET_WITHOUT_CHECK.add("/login");
        TARGET_WITHOUT_CHECK.add("/logout");
    }
}

