/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.route.OverrideUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Providers
extends Restful {
    @Autowired
    private ProviderService providerService;
    @Autowired
    private OverrideService overrideService;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private HttpServletRequest request;

    public void index(Provider provider, Map<String, Object> context) {
        String service = (String)context.get("service");
        String application = (String)context.get("application");
        String address = (String)context.get("address");
        String value = "";
        String separators = "....";
        List providers = null;
        if (service != null && service.length() > 0) {
            providers = this.providerService.findByService(service);
            value = service + separators + this.request.getRequestURI();
        } else if (address != null && address.length() > 0) {
            providers = this.providerService.findByAddress(address);
            value = address + separators + this.request.getRequestURI();
        } else if (application != null && application.length() > 0) {
            providers = this.providerService.findByApplication(application);
            value = application + separators + this.request.getRequestURI();
        } else {
            providers = this.providerService.findAll();
        }
        context.put("providers", providers);
        this.setSearchHistroy(context, value);
    }

    private void setSearchHistroy(Map<String, Object> context, String value) {
        Cookie[] cookies;
        String separatorsB = "\\.\\.\\.\\.\\.\\.";
        String newCookiev = value;
        for (Cookie c : cookies = this.request.getCookies()) {
            if (!c.getName().equals("HISTORY")) continue;
            String cookiev = c.getValue();
            String[] values = cookiev.split(separatorsB);
            int count = 1;
            for (String v : values) {
                if (count <= 10 && !value.equals(v)) {
                    newCookiev = newCookiev + separatorsB + v;
                }
                ++count;
            }
            break;
        }
        Cookie _cookie = new Cookie("HISTORY", newCookiev);
        _cookie.setMaxAge(604800);
        _cookie.setPath("/");
        this.response.addCookie(_cookie);
    }

    public void show(Long id, Map<String, Object> context) {
        Provider provider = this.providerService.findProvider(id);
        if (provider != null && provider.isDynamic()) {
            List overrides = this.overrideService.findByServiceAndAddress(provider.getService(), provider.getAddress());
            OverrideUtils.setProviderOverrides((Provider)provider, (List)overrides);
        }
        context.put("provider", provider);
    }

    public void add(Long id, Map<String, Object> context) {
        Provider p;
        if (context.get("service") == null) {
            List serviceList = Tool.sortSimpleName(new ArrayList(this.providerService.findServices()));
            context.put("serviceList", serviceList);
        }
        if (id != null && (p = this.providerService.findProvider(id)) != null) {
            context.put("provider", p);
            String parameters = p.getParameters();
            if (parameters != null && parameters.length() > 0) {
                Map map = StringUtils.parseQueryString((String)parameters);
                map.put("timestamp", String.valueOf(System.currentTimeMillis()));
                map.remove("pid");
                p.setParameters(StringUtils.toQueryString((Map)map));
            }
        }
    }

    public void edit(Long id, Map<String, Object> context) {
        this.show(id, context);
    }

    public boolean create(Provider provider, Map<String, Object> context) {
        int i;
        String url;
        String service = provider.getService();
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        if (provider.getParameters() == null && (url = provider.getUrl()) != null && (i = url.indexOf(63)) > 0) {
            provider.setUrl(url.substring(0, i));
            provider.setParameters(url.substring(i + 1));
        }
        provider.setDynamic(false);
        this.providerService.create(provider);
        return true;
    }

    public boolean update(Provider newProvider, Map<String, Object> context) {
        Long id = newProvider.getId();
        String parameters = newProvider.getParameters();
        Provider provider = this.providerService.findProvider(id);
        if (provider == null) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
            return false;
        }
        String service = provider.getService();
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        Map oldMap = StringUtils.parseQueryString((String)provider.getParameters());
        Map newMap = StringUtils.parseQueryString((String)parameters);
        for (Map.Entry entry : oldMap.entrySet()) {
            if (!((String)entry.getValue()).equals(newMap.get(entry.getKey()))) continue;
            newMap.remove(entry.getKey());
        }
        if (provider.isDynamic()) {
            String address = provider.getAddress();
            List overrides = this.overrideService.findByServiceAndAddress(provider.getService(), provider.getAddress());
            OverrideUtils.setProviderOverrides((Provider)provider, (List)overrides);
            Override override = provider.getOverride();
            if (override != null) {
                if (newMap.size() > 0) {
                    override.setParams(StringUtils.toQueryString((Map)newMap));
                    override.setEnabled(true);
                    override.setOperator(this.operator);
                    override.setOperatorAddress(this.operatorAddress);
                    this.overrideService.updateOverride(override);
                } else {
                    this.overrideService.deleteOverride(override.getId());
                }
            } else {
                override = new Override();
                override.setService(service);
                override.setAddress(address);
                override.setParams(StringUtils.toQueryString((Map)newMap));
                override.setEnabled(true);
                override.setOperator(this.operator);
                override.setOperatorAddress(this.operatorAddress);
                this.overrideService.saveOverride(override);
            }
        } else {
            provider.setParameters(parameters);
            this.providerService.updateProvider(provider);
        }
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Provider provider = this.providerService.findProvider(id);
            if (provider == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (provider.isDynamic()) {
                context.put("message", this.getMessage("CanNotDeleteDynamicData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(provider.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{provider.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.providerService.deleteStaticProvider(id);
        }
        return true;
    }

    public boolean enable(Long[] ids, Map<String, Object> context) {
        HashMap<Long, Provider> id2Provider = new HashMap<Long, Provider>();
        for (Long id : ids) {
            Provider provider = this.providerService.findProvider(id);
            if (provider == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (!this.currentUser.hasServicePrivilege(provider.getService())) {
                context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{provider.getService()}));
                return false;
            }
            id2Provider.put(id, provider);
        }
        for (Long id : ids) {
            this.providerService.enableProvider(id);
        }
        return true;
    }

    public boolean disable(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Provider provider = this.providerService.findProvider(id);
            if (provider == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(provider.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{provider.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.providerService.disableProvider(id);
        }
        return true;
    }

    public boolean doubling(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Provider provider = this.providerService.findProvider(id);
            if (provider == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(provider.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{provider.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.providerService.doublingProvider(id);
        }
        return true;
    }

    public boolean halving(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Provider provider = this.providerService.findProvider(id);
            if (provider == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(provider.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{provider.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.providerService.halvingProvider(id);
        }
        return true;
    }
}

