/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.home.module.screen;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.governance.web.home.module.screen.Result;
import com.alibaba.dubbo.registry.common.domain.User;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Restful {
    @Autowired
    private HttpServletResponse response;
    @Autowired
    HttpServletRequest request;
    protected String role = null;
    protected String operator = null;
    protected User currentUser = null;
    protected String operatorAddress = null;
    protected URL url = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> context) throws Exception {
        Result result = new Result();
        if (this.request.getParameter("url") != null) {
            this.url = URL.valueOf((String)URL.decode((String)this.request.getParameter("url")));
        }
        if (context.get("currentUser") != null) {
            User user;
            this.currentUser = user = (User)context.get("currentUser");
            this.operator = user.getUsername();
            this.role = user.getRole();
            context.put("currentUser", user);
        }
        this.operatorAddress = (String)context.get("clientid");
        if (this.operatorAddress == null || this.operatorAddress.isEmpty()) {
            this.operatorAddress = (String)context.get("request.remoteHost");
        }
        context.put("operator", this.operator);
        context.put("operatorAddress", this.operatorAddress);
        String jsonResult = null;
        try {
            result = this.doExecute(context);
            result.setStatus("OK");
        }
        catch (IllegalArgumentException t) {
            result.setStatus("ERROR");
            result.setCode(3);
            result.setMessage((Object)t.getMessage());
        }
        catch (Throwable t) {
            result.setStatus("ERROR");
            result.setCode(1);
            result.setMessage((Object)t.getMessage());
        }
        this.response.setContentType("application/javascript");
        ServletOutputStream os = this.response.getOutputStream();
        try {
            jsonResult = JSON.toJSONString((Object)result);
            os.print(jsonResult);
        }
        catch (Exception e) {
            this.response.setStatus(500);
            os.print(e.getMessage());
        }
        finally {
            os.flush();
        }
    }

    protected abstract Result doExecute(Map<String, Object> var1) throws Exception;
}

