/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.home.module.screen;

import com.alibaba.dubbo.registry.common.domain.User;
import java.io.PrintWriter;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class Shell {
    @Autowired
    private HttpServletResponse response;
    protected String role = null;
    protected String operator = null;
    protected User currentUser = null;
    protected String operatorAddress = null;
    private static final Pattern OK_PATTERN = Pattern.compile("ok", 2);
    private static final Pattern ERROR_PATTERN = Pattern.compile("error", 2);

    public void execute(Map<String, Object> context) throws Exception {
        if (context.get("currentUser") != null) {
            User user;
            this.currentUser = user = (User)context.get("currentUser");
            this.operator = user.getUsername();
            this.role = user.getRole();
            context.put("currentUser", user);
        }
        this.operatorAddress = (String)context.get("request.remoteHost");
        context.put("operator", this.operator);
        context.put("operatorAddress", this.operatorAddress);
        try {
            String message = this.doExecute(context);
            context.put("message", "OK: " + Shell.filterERROR((String)message));
        }
        catch (Throwable t) {
            context.put("message", "ERROR: " + Shell.filterOK((String)t.getMessage()));
        }
        PrintWriter writer = this.response.getWriter();
        writer.print(context.get("message"));
        writer.flush();
    }

    protected abstract String doExecute(Map<String, Object> var1) throws Exception;

    private static String filterOK(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return OK_PATTERN.matcher(value).replaceAll("0k");
    }

    private static String filterERROR(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return ERROR_PATTERN.matcher(value).replaceAll("err0r");
    }
}

