/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.domain;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.registry.common.domain.Entity;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.registry.ConvertUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Provider
extends Entity {
    private static final long serialVersionUID = 5981342400350878171L;
    private String service;
    private String url;
    private String parameters;
    private String address;
    private String registry;
    private boolean dynamic;
    private boolean enabled;
    private int weight;
    private String application;
    private String username;
    private Date expired;
    private long alived;
    private Override override;
    private List<Override> overrides;

    public Provider() {
    }

    public Provider(Long id) {
        super(id);
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getExpired() {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public long getAlived() {
        return this.alived;
    }

    public void setAlived(long aliveSeconds) {
        this.alived = aliveSeconds;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Override getOverride() {
        return this.override;
    }

    public void setOverride(Override override) {
        this.override = override;
    }

    public List<Override> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(List<Override> overrides) {
        this.overrides = overrides;
    }

    public URL toUrl() {
        boolean enabled;
        Map serviceName2Map = ConvertUtil.serviceName2Map((String)this.getService());
        String u = this.getUrl();
        URL url = URL.valueOf((String)(u + "?" + this.getParameters()));
        url = url.addParameters(serviceName2Map);
        boolean dynamic = this.isDynamic();
        if (!dynamic) {
            url = url.addParameter("dynamic", false);
        }
        if ((enabled = this.isEnabled()) != url.getParameter("enabled", true)) {
            url = enabled ? url.removeParameter("enabled") : url.addParameter("enabled", false);
        }
        return url;
    }
}

