/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.route;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.common.domain.Route;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RouteRule {
    final Map<String, MatchPair> whenCondition;
    final Map<String, MatchPair> thenCondition;
    private static Pattern ROUTE_PATTERN = Pattern.compile("([&!=,]*)\\s*([^&!=,\\s]+)");
    private static Pattern CONDITION_SEPERATOR = Pattern.compile("(.*)=>(.*)");
    static RouteRule EMPTY = new RouteRule(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    private static Pattern VALUE_LIST_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private volatile String tostring = null;

    public static Map<String, MatchPair> parseRule(String rule) throws ParseException {
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        if (StringUtils.isBlank((String)rule)) {
            return condition;
        }
        MatchPair pair = null;
        Set values = null;
        Matcher matcher = ROUTE_PATTERN.matcher(rule);
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (separator == null || separator.length() == 0) {
                pair = new MatchPair();
                condition.put(content, pair);
                continue;
            }
            if ("&".equals(separator)) {
                if (condition.get(content) == null) {
                    pair = new MatchPair();
                    condition.put(content, pair);
                    continue;
                }
                condition.put(content, pair);
                continue;
            }
            if ("=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.matches;
                values.add(content);
                continue;
            }
            if ("!=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.unmatches;
                values.add(content);
                continue;
            }
            if (",".equals(separator)) {
                if (values == null || values.size() == 0) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values.add(content);
                continue;
            }
            throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
        }
        return condition;
    }

    private RouteRule(Map<String, MatchPair> when, Map<String, MatchPair> then) {
        for (Map.Entry<String, MatchPair> entry : when.entrySet()) {
            entry.getValue().freeze();
        }
        for (Map.Entry<String, MatchPair> entry : then.entrySet()) {
            entry.getValue().freeze();
        }
        this.whenCondition = when;
        this.thenCondition = then;
    }

    public static RouteRule parse(Route route) throws ParseException {
        if (route == null) {
            throw new ParseException("null route!", 0);
        }
        if (route.getMatchRule() == null && route.getFilterRule() == null) {
            return RouteRule.parse((String)route.getRule());
        }
        return RouteRule.parse((String)(route == null ? null : route.getMatchRule()), (String)(route == null ? null : route.getFilterRule()));
    }

    public static RouteRule parse(String whenRule, String thenRule) throws ParseException {
        if (thenRule == null || thenRule.trim().length() == 0) {
            throw new ParseException("Illegal route rule without then express", 0);
        }
        Map when = RouteRule.parseRule((String)whenRule.trim());
        Map then = RouteRule.parseRule((String)thenRule.trim());
        return new RouteRule(when, then);
    }

    public static RouteRule parse(String rule) throws ParseException {
        if (StringUtils.isBlank((String)rule)) {
            throw new ParseException("Illegal blank route rule", 0);
        }
        Matcher matcher = CONDITION_SEPERATOR.matcher(rule);
        if (!matcher.matches()) {
            throw new ParseException("condition seperator => not found!", 0);
        }
        return RouteRule.parse((String)matcher.group(1), (String)matcher.group(2));
    }

    public static RouteRule parseQuitely(Route route) {
        try {
            return RouteRule.parse((Route)route);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, MatchPair> parseNameAndValueListString2Condition(Map<String, String> params, Map<String, String> notParams) {
        HashSet<String> set;
        String[] list;
        String valueListString;
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            valueListString = entry.getValue();
            if (StringUtils.isBlank((String)valueListString)) continue;
            list = VALUE_LIST_SEPARATOR.split(valueListString);
            set = new HashSet<String>();
            String[] stringArray = list;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item = stringArray[i];
                if (StringUtils.isBlank((String)item)) continue;
                set.add(item.trim());
            }
            if (set.isEmpty()) continue;
            String string = entry.getKey();
            MatchPair matchPair = (MatchPair)condition.get(string);
            if (null == matchPair) {
                matchPair = new MatchPair();
                condition.put(string, matchPair);
            }
            matchPair.matches = set;
        }
        for (Map.Entry<String, String> entry : notParams.entrySet()) {
            valueListString = entry.getValue();
            if (StringUtils.isBlank((String)valueListString)) continue;
            list = VALUE_LIST_SEPARATOR.split(valueListString);
            set = new HashSet();
            for (String item : list) {
                if (StringUtils.isBlank((String)item)) continue;
                set.add(item.trim());
            }
            if (set.isEmpty()) continue;
            String string = entry.getKey();
            MatchPair matchPair = (MatchPair)condition.get(string);
            if (null == matchPair) {
                matchPair = new MatchPair();
                condition.put(string, matchPair);
            }
            matchPair.unmatches = set;
        }
        return condition;
    }

    public static RouteRule createFromNameAndValueListString(Map<String, String> whenParams, Map<String, String> notWhenParams, Map<String, String> thenParams, Map<String, String> notThenParams) {
        Map when = RouteRule.parseNameAndValueListString2Condition(whenParams, notWhenParams);
        Map then = RouteRule.parseNameAndValueListString2Condition(thenParams, notThenParams);
        return new RouteRule(when, then);
    }

    public static RouteRule createFromCondition(Map<String, MatchPair> whenCondition, Map<String, MatchPair> thenCondition) {
        return new RouteRule(whenCondition, thenCondition);
    }

    public static RouteRule copyWithRemove(RouteRule copy, Set<String> whenParams, Set<String> thenParams) {
        HashMap when = new HashMap();
        for (Map.Entry entry : copy.getWhenCondition().entrySet()) {
            if (whenParams != null && whenParams.contains(entry.getKey())) continue;
            when.put(entry.getKey(), entry.getValue());
        }
        HashMap then = new HashMap();
        for (Map.Entry entry : copy.getThenCondition().entrySet()) {
            if (thenParams != null && thenParams.contains(entry.getKey())) continue;
            then.put(entry.getKey(), entry.getValue());
        }
        return new RouteRule(when, then);
    }

    public static RouteRule copyWithReplace(RouteRule copy, Map<String, MatchPair> whenCondition, Map<String, MatchPair> thenCondition) {
        if (null == copy) {
            throw new NullPointerException("Argument copy is null!");
        }
        HashMap<String, MatchPair> when = new HashMap<String, MatchPair>();
        when.putAll(copy.getWhenCondition());
        if (whenCondition != null) {
            when.putAll(whenCondition);
        }
        HashMap<String, MatchPair> then = new HashMap<String, MatchPair>();
        then.putAll(copy.getThenCondition());
        if (thenCondition != null) {
            then.putAll(thenCondition);
        }
        return new RouteRule(when, then);
    }

    static void join(StringBuilder sb, Set<String> valueSet) {
        boolean isFirst = true;
        for (String s : valueSet) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
    }

    public static boolean matchCondition(Map<String, String> sample, Map<String, MatchPair> condition) {
        for (Map.Entry<String, String> entry : sample.entrySet()) {
            String key = entry.getKey();
            MatchPair pair = condition.get(key);
            if (pair == null || pair.pass(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static String join(Set<String> valueSet) {
        StringBuilder sb = new StringBuilder(128);
        RouteRule.join((StringBuilder)sb, valueSet);
        return sb.toString();
    }

    public static void contidionToString(StringBuilder sb, Map<String, MatchPair> condition) {
        boolean isFirst = true;
        for (Map.Entry<String, MatchPair> entry : condition.entrySet()) {
            String keyName = entry.getKey();
            MatchPair p = entry.getValue();
            Set[] setArray = new Set[]{p.matches, p.unmatches};
            String[] opArray = new String[]{" = ", " != "};
            for (int i = 0; i < setArray.length; ++i) {
                if (setArray[i].isEmpty()) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" & ");
                }
                sb.append(keyName);
                sb.append(opArray[i]);
                RouteRule.join((StringBuilder)sb, (Set)setArray[i]);
            }
        }
    }

    public boolean isWhenContainValue(String key, String value) {
        MatchPair matchPair = (MatchPair)this.whenCondition.get(key);
        if (null == matchPair) {
            return false;
        }
        return matchPair.containeValue(value);
    }

    public boolean isThenContainValue(String key, String value) {
        MatchPair matchPair = (MatchPair)this.thenCondition.get(key);
        if (null == matchPair) {
            return false;
        }
        return matchPair.containeValue(value);
    }

    public boolean isContainValue(String key, String value) {
        return this.isWhenContainValue(key, value) || this.isThenContainValue(key, value);
    }

    public Map<String, MatchPair> getWhenCondition() {
        return this.whenCondition;
    }

    public Map<String, MatchPair> getThenCondition() {
        return this.thenCondition;
    }

    public String getWhenConditionString() {
        StringBuilder sb = new StringBuilder(512);
        RouteRule.contidionToString((StringBuilder)sb, (Map)this.whenCondition);
        return sb.toString();
    }

    public String getThenConditionString() {
        StringBuilder sb = new StringBuilder(512);
        RouteRule.contidionToString((StringBuilder)sb, (Map)this.thenCondition);
        return sb.toString();
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        StringBuilder sb = new StringBuilder(512);
        RouteRule.contidionToString((StringBuilder)sb, (Map)this.whenCondition);
        sb.append(" => ");
        RouteRule.contidionToString((StringBuilder)sb, (Map)this.thenCondition);
        this.tostring = sb.toString();
        return this.tostring;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.thenCondition == null ? 0 : this.thenCondition.hashCode());
        result = 31 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteRule other = (RouteRule)obj;
        if (this.thenCondition == null ? other.thenCondition != null : !this.thenCondition.equals(other.thenCondition)) {
            return false;
        }
        return !(this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition));
    }
}

