/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.route;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.web.common.pulltool.Tool;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.domain.Route;
import com.alibaba.dubbo.registry.common.route.ParseUtils;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import com.alibaba.dubbo.registry.common.route.RouteRuleUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RouteUtils {
    public static boolean matchRoute(String consumerAddress, String consumerQueryUrl, Route route, Map<String, List<String>> clusters) {
        RouteRule rule = RouteRule.parseQuitely((Route)route);
        Map when = RouteRuleUtils.expandCondition((Map)rule.getWhenCondition(), (String)"consumer.cluster", (String)"consumer.host", clusters);
        Map consumerSample = ParseUtils.parseQuery((String)"consumer.", (String)consumerQueryUrl);
        int index = consumerAddress.lastIndexOf(":");
        String consumerHost = null;
        consumerHost = index != -1 ? consumerAddress.substring(0, index) : consumerAddress;
        consumerSample.put("consumer.host", consumerHost);
        return RouteRuleUtils.isMatchCondition((Map)when, (Map)consumerSample, (Map)consumerSample);
    }

    public static Map<String, String> previewRoute(String serviceName, String consumerAddress, String queryUrl, Map<String, String> serviceUrls, Route route, Map<String, List<String>> clusters, List<Route> routed) {
        if (null == route) {
            throw new IllegalArgumentException("Route is null.");
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        routes.add(route);
        return RouteUtils.route((String)serviceName, (String)consumerAddress, (String)queryUrl, serviceUrls, routes, clusters, routed);
    }

    public static List<Route> findUsedRoute(String serviceName, String consumerAddress, String consumerQueryUrl, List<Route> routes, Map<String, List<String>> clusters) {
        ArrayList<Route> routed = new ArrayList<Route>();
        HashMap<String, String> urls = new HashMap<String, String>();
        urls.put("dubbo://" + consumerAddress + "/" + serviceName, consumerQueryUrl);
        RouteUtils.route((String)serviceName, (String)consumerAddress, (String)consumerQueryUrl, urls, routes, clusters, routed);
        return routed;
    }

    public static List<Provider> route(String serviceName, String consumerAddress, String consumerQueryUrl, List<Provider> providers, List<Override> overrides, List<Route> routes, Map<String, List<String>> clusters, List<Route> routed) {
        if (providers == null) {
            return null;
        }
        Map urls = new HashMap<String, String>();
        urls.put("consumer://" + consumerAddress + "/" + serviceName, consumerQueryUrl);
        for (Provider provider : providers) {
            if (!Tool.isProviderEnabled((Provider)provider, overrides)) continue;
            urls.put(provider.getUrl(), provider.getParameters());
        }
        urls = RouteUtils.route((String)serviceName, (String)consumerAddress, (String)consumerQueryUrl, urls, routes, clusters, routed);
        ArrayList<Provider> result = new ArrayList<Provider>();
        for (Provider provider : providers) {
            if (!urls.containsKey(provider.getUrl())) continue;
            result.add(provider);
        }
        return result;
    }

    public static Map<String, String> route(String serviceName, String consumerAddress, String consumerQueryUrl, Map<String, String> serviceUrls, List<Route> routes, Map<String, List<String>> clusters, List<Route> routed) {
        String[] methods;
        String[] stringArray;
        if (serviceUrls == null || serviceUrls.size() == 0) {
            return serviceUrls;
        }
        if (routes == null || routes.isEmpty()) {
            return serviceUrls;
        }
        Map rules = RouteUtils.route2RouteRule(routes, clusters);
        Map consumerSample = ParseUtils.parseQuery((String)"consumer.", (String)consumerQueryUrl);
        int index = consumerAddress.lastIndexOf(":");
        String consumerHost = consumerAddress != null && index != -1 ? consumerAddress.substring(0, index) : consumerAddress;
        consumerSample.put("consumer.host", consumerHost);
        Map url2ProviderSample = new HashMap();
        for (Map.Entry<String, String> entry : serviceUrls.entrySet()) {
            URI uri;
            try {
                uri = new URI(entry.getKey());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("fail to parse url(" + entry.getKey() + "):" + e.getMessage(), e);
            }
            HashMap<String, String> sample = new HashMap<String, String>();
            sample.putAll(ParseUtils.parseQuery((String)"provider.", (String)entry.getValue()));
            sample.put("provider.protocol", uri.getScheme());
            sample.put("provider.host", uri.getHost());
            sample.put("provider.port", String.valueOf(uri.getPort()));
            url2ProviderSample.put(entry.getKey(), sample);
        }
        HashMap<String, HashSet<String>> url2Methods = new HashMap<String, HashSet<String>>();
        String methodsString = (String)consumerSample.get("consumer.methods");
        if (methodsString == null || methodsString.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = methodsString.split(ParseUtils.METHOD_SPLIT);
        }
        for (String method : methods = stringArray) {
            consumerSample.put("method", method);
            if (routes != null && routes.size() > 0) {
                for (Route route : routes) {
                    Map then;
                    RouteRule rule;
                    if (!RouteUtils.isSerivceNameMatched((String)route.getService(), (String)serviceName) || (rule = (RouteRule)rules.get(route.getId())) == null || !RouteRuleUtils.isMatchCondition((Map)rule.getWhenCondition(), (Map)consumerSample, (Map)consumerSample)) continue;
                    if (routed != null && !routed.contains(route)) {
                        routed.add(route);
                    }
                    if ((then = rule.getThenCondition()) == null) continue;
                    Map tmp = RouteUtils.getUrlsMatchedCondition((Map)then, (Map)consumerSample, url2ProviderSample);
                    if (!route.isForce() && tmp.isEmpty()) continue;
                    url2ProviderSample = tmp;
                }
            }
            for (String url : url2ProviderSample.keySet()) {
                HashSet<String> mts = (HashSet<String>)url2Methods.get(url);
                if (mts == null) {
                    mts = new HashSet<String>();
                    url2Methods.put(url, mts);
                }
                mts.add(method);
            }
        }
        return RouteUtils.appendMethodsToUrls(serviceUrls, url2Methods);
    }

    static Map<Long, RouteRule> route2RouteRule(List<Route> routes, Map<String, List<String>> clusters) {
        HashMap<Long, RouteRule> rules = new HashMap<Long, RouteRule>();
        if (routes != null && routes.size() > 0) {
            for (Route route : routes) {
                rules.put(route.getId(), RouteRule.parseQuitely((Route)route));
            }
        }
        if (clusters != null && clusters.size() > 0) {
            HashMap rrs = new HashMap();
            for (Map.Entry entry : rules.entrySet()) {
                RouteRule rr = (RouteRule)entry.getValue();
                Map when = RouteRuleUtils.expandCondition((Map)rr.getWhenCondition(), (String)"consumer.cluster", (String)"consumer.host", clusters);
                Map then = RouteRuleUtils.expandCondition((Map)rr.getThenCondition(), (String)"provider.cluster", (String)"provider.host", clusters);
                rrs.put(entry.getKey(), RouteRule.createFromCondition((Map)when, (Map)then));
            }
            rules = rrs;
        }
        return rules;
    }

    static Map<String, String> appendMethodsToUrls(Map<String, String> serviceUrls, Map<String, Set<String>> url2Methods) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : url2Methods.entrySet()) {
            String url = entry.getKey();
            String query = serviceUrls.get(url);
            Set<String> methodNames = entry.getValue();
            if (methodNames != null && methodNames.size() > 0) {
                String ms = StringUtils.join((String[])methodNames.toArray(new String[0]), (String)ParseUtils.METHOD_SPLIT);
                query = ParseUtils.replaceParameter((String)query, (String)"methods", (String)ms);
            }
            results.put(url, query);
        }
        return results;
    }

    static Route getFirstRouteMatchedWhenConditionOfRule(String serviceName, Map<String, String> consumerSample, List<Route> routes, Map<Long, RouteRule> routeRuleMap) {
        if (serviceName == null || serviceName.length() == 0) {
            return null;
        }
        if (routes != null && routes.size() > 0) {
            for (Route route : routes) {
                RouteRule rule;
                if (!RouteUtils.isSerivceNameMatched((String)route.getService(), (String)serviceName) || (rule = routeRuleMap.get(route.getId())) == null || !RouteRuleUtils.isMatchCondition((Map)rule.getWhenCondition(), consumerSample, consumerSample)) continue;
                return route;
            }
        }
        return null;
    }

    static boolean isSerivceNameMatched(String servicePattern, String serviceName) {
        int pip = servicePattern.indexOf(47);
        int pi = serviceName.indexOf(47);
        if (pip != -1) {
            if (pi == -1) {
                return false;
            }
            String gp = servicePattern.substring(0, pip);
            servicePattern = servicePattern.substring(pip + 1);
            String g = serviceName.substring(0, pi);
            if (!gp.equals(g)) {
                return false;
            }
        }
        if (pi != -1) {
            serviceName = serviceName.substring(pi + 1);
        }
        int vip = servicePattern.lastIndexOf(58);
        int vi = serviceName.lastIndexOf(58);
        if (vip != -1) {
            if (vi == -1) {
                return false;
            }
            String vp = servicePattern.substring(vip + 1);
            servicePattern = servicePattern.substring(0, vip);
            String v = serviceName.substring(vi + 1);
            if (!vp.equals(v)) {
                return false;
            }
        }
        if (vi != -1) {
            serviceName = serviceName.substring(0, vi);
        }
        return ParseUtils.isMatchGlobPattern((String)servicePattern, (String)serviceName);
    }

    static Map<String, Map<String, String>> getUrlsMatchedCondition(Map<String, RouteRule.MatchPair> condition, Map<String, String> parameters, Map<String, Map<String, String>> url2Sample) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : url2Sample.entrySet()) {
            Map<String, String> sample = entry.getValue();
            HashMap<String, String> params = new HashMap<String, String>();
            params.putAll(sample);
            params.putAll(parameters);
            if (!RouteRuleUtils.isMatchCondition(condition, params, sample)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

