/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EInteger;
import java.lang.reflect.Type;
import java.util.Date;

class CBORDateConverter
implements ICBORToFromConverter<Date> {
    CBORDateConverter() {
    }

    private static String DateTimeToString(Date bi) {
        int[] lesserFields = new int[7];
        EInteger[] year = new EInteger[1];
        PropertyMap.BreakDownDateTime(bi, year, lesserFields);
        return CBORUtilities.ToAtomDateTimeString(year[0], lesserFields);
    }

    @Override
    public Date FromCBORObject(CBORObject obj) {
        if (obj.HasMostOuterTag(0)) {
            try {
                return CBORDateConverter.StringToDateTime(obj.AsString());
            }
            catch (ArithmeticException ex) {
                throw new CBORException(ex.getMessage(), ex);
            }
            catch (IllegalArgumentException ex) {
                throw new CBORException(ex.getMessage(), ex);
            }
        }
        if (obj.HasMostOuterTag(1)) {
            if (!obj.isNumber() || !obj.AsNumber().IsFinite()) {
                throw new CBORException("Not a finite number");
            }
            EDecimal dec = (EDecimal)obj.ToObject((Type)((Object)EDecimal.class));
            int[] lesserFields = new int[7];
            EInteger[] year = new EInteger[1];
            CBORUtilities.BreakDownSecondsSinceEpoch(dec, year, lesserFields);
            return PropertyMap.BuildUpDateTime(year[0], lesserFields);
        }
        throw new CBORException("Not tag 0 or 1");
    }

    public static Date StringToDateTime(String str) {
        int[] lesserFields = new int[7];
        EInteger[] year = new EInteger[1];
        CBORUtilities.ParseAtomDateTimeString(str, year, lesserFields);
        return PropertyMap.BuildUpDateTime(year[0], lesserFields);
    }

    @Override
    public CBORObject ToCBORObject(Date obj) {
        return CBORObject.FromObjectAndTag((Object)CBORDateConverter.DateTimeToString(obj), 0);
    }
}

