/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORExtendedDecimal
implements ICBORNumber {
    CBORExtendedDecimal() {
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.IsPositiveInfinity();
    }

    @Override
    public boolean IsInfinity(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.IsInfinity();
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.IsNegativeInfinity();
    }

    @Override
    public boolean IsNaN(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.IsNaN();
    }

    @Override
    public double AsDouble(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.ToDouble();
    }

    @Override
    public EDecimal AsEDecimal(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed;
    }

    @Override
    public EFloat AsEFloat(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.ToEFloat();
    }

    @Override
    public float AsSingle(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.ToSingle();
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.ToEInteger();
    }

    @Override
    public long AsInt64(Object obj) {
        EDecimal ef = (EDecimal)obj;
        if (this.CanTruncatedIntFitInInt64(obj)) {
            EInteger bi = ef.ToEInteger();
            return bi.ToInt64Checked();
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        EDecimal ef = (EDecimal)obj;
        return !ef.isFinite() || ef.compareTo(EDecimal.FromSingle((float)ef.ToSingle())) == 0;
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        EDecimal ef = (EDecimal)obj;
        return !ef.isFinite() || ef.compareTo(EDecimal.FromDouble((double)ef.ToDouble())) == 0;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        EDecimal ef = (EDecimal)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.isZero()) {
            return true;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64((long)21L)) >= 0) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.CanFitInInt64();
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        EDecimal ef = (EDecimal)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.isZero()) {
            return true;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64((long)11L)) >= 0) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.CanFitInInt32();
    }

    @Override
    public boolean IsNumberZero(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.isZero();
    }

    @Override
    public int Sign(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.IsNaN() ? 2 : ed.signum();
    }

    @Override
    public boolean IsIntegral(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.isFinite() && (ed.getExponent().signum() >= 0 || ed.compareTo(EDecimal.FromEInteger((EInteger)ed.ToEInteger())) == 0);
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        EInteger bi;
        int ret;
        EDecimal ef = (EDecimal)obj;
        if (this.CanTruncatedIntFitInInt32(obj) && (ret = (bi = ef.ToEInteger()).ToInt32Checked()) >= minValue && ret <= maxValue) {
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public Object Negate(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.Negate();
    }

    @Override
    public Object Abs(Object obj) {
        EDecimal ed = (EDecimal)obj;
        return ed.Abs();
    }

    @Override
    public ERational AsERational(Object obj) {
        return ERational.FromEDecimal((EDecimal)((EDecimal)obj));
    }

    @Override
    public boolean IsNegative(Object obj) {
        return ((EDecimal)obj).isNegative();
    }
}

