/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.Base64;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORNumber;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.cbor.StringOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CBORJsonWriter {
    private static final String Hex16 = "0123456789ABCDEF";

    private CBORJsonWriter() {
    }

    static void WriteJSONStringUnquoted(String str, StringOutput sb, JSONOptions options) throws IOException {
        boolean first = true;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c == 92 || c == 34) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                sb.WriteCodePoint(92);
                sb.WriteCodePoint(c);
                continue;
            }
            if (c < 32 || c >= 127 && (c == 8232 || c == 8233 || c >= 127 && c <= 160 || c == 65279 || c == 65534 || c == 65535)) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                if (c == 13) {
                    sb.WriteString("\\r");
                    continue;
                }
                if (c == 10) {
                    sb.WriteString("\\n");
                    continue;
                }
                if (c == 8) {
                    sb.WriteString("\\b");
                    continue;
                }
                if (c == 12) {
                    sb.WriteString("\\f");
                    continue;
                }
                if (c == 9) {
                    sb.WriteString("\\t");
                    continue;
                }
                if (c == 133) {
                    sb.WriteString("\\u0085");
                    continue;
                }
                if (c >= 256) {
                    sb.WriteString("\\u");
                    sb.WriteCodePoint(Hex16.charAt(c >> 12 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 8 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 4 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                    continue;
                }
                sb.WriteString("\\u00");
                sb.WriteCodePoint(Hex16.charAt(c >> 4));
                sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                continue;
            }
            if ((c & 0xFC00) == 55296 && (i >= str.length() - 1 || (str.charAt(i + 1) & 0xFC00) != 56320)) {
                if (options.getReplaceSurrogates()) {
                    if (first) {
                        first = false;
                        sb.WriteString(str, 0, i);
                    }
                    c = 65533;
                } else {
                    throw new CBORException("Unpaired surrogate in String");
                }
            }
            if (first) continue;
            if ((c & 0xFC00) == 55296) {
                sb.WriteString(str, i, 2);
                ++i;
                continue;
            }
            sb.WriteCodePoint(c);
        }
        if (first) {
            sb.WriteString(str);
        }
    }

    static void WriteJSONToInternal(CBORObject obj, StringOutput writer, JSONOptions options) throws IOException {
        if (obj.getType() == CBORType.Array || obj.getType() == CBORType.Map) {
            ArrayList<CBORObject> stack = new ArrayList<CBORObject>();
            CBORJsonWriter.WriteJSONToInternal(obj, writer, options, stack);
        } else {
            CBORJsonWriter.WriteJSONToInternal(obj, writer, options, null);
        }
    }

    private static void PopRefIfNeeded(List<CBORObject> stack, boolean pop) {
        if (pop && stack != null) {
            stack.remove(stack.size() - 1);
        }
    }

    private static boolean CheckCircularRef(List<CBORObject> stack, CBORObject parent, CBORObject child) {
        if (child.getType() != CBORType.Array && child.getType() != CBORType.Map) {
            return false;
        }
        CBORObject childUntag = child.Untag();
        if (parent.Untag() == childUntag) {
            throw new CBORException("Circular reference in CBOR Object");
        }
        if (stack != null) {
            for (CBORObject o : stack) {
                if (o.Untag() != childUntag) continue;
                throw new CBORException("Circular reference in CBOR Object");
            }
        }
        stack.add(child);
        return true;
    }

    static void WriteJSONToInternal(CBORObject obj, StringOutput writer, JSONOptions options, List<CBORObject> stack) throws IOException {
        if (obj.isNumber()) {
            writer.WriteString(CBORNumber.FromCBORObject(obj).ToJSONString());
            return;
        }
        switch (obj.getType()) {
            case Integer: 
            case FloatingPoint: {
                CBORObject untaggedObj = obj.Untag();
                writer.WriteString(CBORNumber.FromCBORObject(untaggedObj).ToJSONString());
                break;
            }
            case Boolean: {
                if (obj.isTrue()) {
                    writer.WriteString("true");
                    return;
                }
                if (obj.isFalse()) {
                    writer.WriteString("false");
                    return;
                }
                return;
            }
            case SimpleValue: {
                writer.WriteString("null");
                return;
            }
            case ByteString: {
                byte[] byteArray = obj.GetByteString();
                if (byteArray.length == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                if (obj.HasTag(22)) {
                    Base64.WriteBase64(writer, byteArray, 0, byteArray.length, true);
                } else if (obj.HasTag(23)) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] >> 4 & 0xF));
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] & 0xF));
                    }
                } else {
                    Base64.WriteBase64URL(writer, byteArray, 0, byteArray.length, false);
                }
                writer.WriteCodePoint(34);
                break;
            }
            case TextString: {
                String thisString = obj.AsString();
                if (thisString.length() == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                CBORJsonWriter.WriteJSONStringUnquoted(thisString, writer, options);
                writer.WriteCodePoint(34);
                break;
            }
            case Array: {
                writer.WriteCodePoint(91);
                for (int i = 0; i < obj.size(); ++i) {
                    if (i > 0) {
                        writer.WriteCodePoint(44);
                    }
                    boolean pop = CBORJsonWriter.CheckCircularRef(stack, obj, obj.get(i));
                    CBORJsonWriter.WriteJSONToInternal(obj.get(i), writer, options, stack);
                    CBORJsonWriter.PopRefIfNeeded(stack, pop);
                }
                writer.WriteCodePoint(93);
                break;
            }
            case Map: {
                CBORObject value;
                Object key;
                boolean first = true;
                boolean hasNonStringKeys = false;
                Collection<Map.Entry<CBORObject, CBORObject>> entries = obj.getEntries();
                for (Map.Entry<CBORObject, CBORObject> entry : entries) {
                    CBORObject cBORObject = entry.getKey();
                    if (cBORObject.getType() == CBORType.TextString && !cBORObject.isTagged()) continue;
                    hasNonStringKeys = true;
                    break;
                }
                if (!hasNonStringKeys) {
                    writer.WriteCodePoint(123);
                    for (Map.Entry<CBORObject, CBORObject> entry : entries) {
                        CBORObject cBORObject = entry.getKey();
                        CBORObject value2 = entry.getValue();
                        if (!first) {
                            writer.WriteCodePoint(44);
                        }
                        writer.WriteCodePoint(34);
                        CBORJsonWriter.WriteJSONStringUnquoted(cBORObject.AsString(), writer, options);
                        writer.WriteCodePoint(34);
                        writer.WriteCodePoint(58);
                        boolean pop = CBORJsonWriter.CheckCircularRef(stack, obj, value2);
                        CBORJsonWriter.WriteJSONToInternal(value2, writer, options, stack);
                        CBORJsonWriter.PopRefIfNeeded(stack, pop);
                        first = false;
                    }
                    writer.WriteCodePoint(125);
                    break;
                }
                HashMap<String, CBORObject> stringMap = new HashMap<String, CBORObject>();
                for (Map.Entry<CBORObject, CBORObject> entry : entries) {
                    key = entry.getKey();
                    value = entry.getValue();
                    String str = null;
                    switch (((CBORObject)key).getType()) {
                        case TextString: {
                            str = ((CBORObject)key).AsString();
                            break;
                        }
                        case Array: 
                        case Map: {
                            StringBuilder sb = new StringBuilder();
                            StringOutput sw = new StringOutput(sb);
                            boolean pop = CBORJsonWriter.CheckCircularRef(stack, obj, (CBORObject)key);
                            CBORJsonWriter.WriteJSONToInternal((CBORObject)key, sw, options, stack);
                            CBORJsonWriter.PopRefIfNeeded(stack, pop);
                            str = sb.toString();
                            break;
                        }
                        default: {
                            str = ((CBORObject)key).ToJSONString(options);
                        }
                    }
                    if (stringMap.containsKey(str)) {
                        throw new CBORException("Duplicate JSON String equivalents of map keys");
                    }
                    stringMap.put(str, value);
                }
                first = true;
                writer.WriteCodePoint(123);
                for (Map.Entry<CBORObject, CBORObject> entry : stringMap.entrySet()) {
                    key = (String)((Object)entry.getKey());
                    value = entry.getValue();
                    if (!first) {
                        writer.WriteCodePoint(44);
                    }
                    writer.WriteCodePoint(34);
                    CBORJsonWriter.WriteJSONStringUnquoted((String)key, writer, options);
                    writer.WriteCodePoint(34);
                    writer.WriteCodePoint(58);
                    boolean pop = CBORJsonWriter.CheckCircularRef(stack, obj, value);
                    CBORJsonWriter.WriteJSONToInternal(value, writer, options, stack);
                    CBORJsonWriter.PopRefIfNeeded(stack, pop);
                    first = false;
                }
                writer.WriteCodePoint(125);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected item type");
            }
        }
    }
}

