/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.upyun.UpAPIException;
import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UpYun {
    private static final String UTF8 = "UTF-8";
    private final String SEPARATOR = "/";
    private final String AUTHORIZATION = "Authorization";
    private final String DATE = "Date";
    private final String CONTENT_LENGTH = "Content-Length";
    private final String CONTENT_MD5 = "Content-MD5";
    private final String CONTENT_SECRET = "Content-Secret";
    private final String MKDIR = "mkdir";
    private final String METHOD_HEAD = "HEAD";
    private final String METHOD_GET = "GET";
    private final String METHOD_PUT = "PUT";
    private final String METHOD_DELETE = "DELETE";
    public static final String ED_AUTO = "v0.api.upyun.com";
    public static final String ED_TELECOM = "v1.api.upyun.com";
    public static final String ED_CNC = "v2.api.upyun.com";
    public static final String ED_CTT = "v3.api.upyun.com";
    public boolean debug = false;
    private int timeout = 30000;
    private String apiDomain = "v0.api.upyun.com";
    private String contentMD5 = null;
    private String fileSecret = null;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    private Map<String, String> headers;

    public UpYun(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYun.md5(password);
    }

    public void setApiDomain(String domain) {
        this.apiDomain = domain;
    }

    public String getApiDomain() {
        return this.apiDomain;
    }

    public void setTimeout(int second) {
        this.timeout = second * 1000;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setContentMD5(String md5Value) {
        this.contentMD5 = md5Value;
    }

    public void setFileSecret(String secret) {
        this.fileSecret = secret;
    }

    public String version() {
        return "upyun-java-sdk/4.2.0";
    }

    public long getBucketUsage() throws IOException, UpException {
        long usage = -1L;
        String result = this.HttpAction("GET", this.formatPath("/") + "/?usage");
        if (!this.isEmpty(result)) {
            try {
                usage = Long.parseLong(result.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return usage;
    }

    @Deprecated
    public long getFolderUsage(String path) throws IOException, UpException {
        long usage = -1L;
        String result = this.HttpAction("GET", this.formatPath(path) + "/?usage");
        if (!this.isEmpty(result)) {
            try {
                usage = Long.parseLong(result.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return usage;
    }

    public boolean writeFile(String filePath, byte[] datas) throws IOException, UpException {
        return this.writeFile(filePath, datas, false, null);
    }

    public boolean writeFile(String filePath, byte[] datas, boolean auto) throws IOException, UpException {
        return this.writeFile(filePath, datas, auto, null);
    }

    public boolean writeFile(String filePath, byte[] datas, boolean auto, Map<String, String> params) throws IOException, UpException {
        return this.HttpAction("PUT", this.formatPath(filePath), datas, null, auto, params) != null;
    }

    public boolean writeFile(String filePath, String datas) throws IOException, UpException {
        return this.writeFile(filePath, datas, false, null);
    }

    public boolean writeFile(String filePath, String datas, boolean auto) throws IOException, UpException {
        return this.writeFile(filePath, datas, auto, null);
    }

    public boolean writeFile(String filePath, String datas, boolean auto, Map<String, String> params) throws IOException, UpException {
        return this.writeFile(filePath, datas.getBytes(UTF8), auto, params);
    }

    public boolean writeFile(String filePath, File file) throws IOException, UpException {
        return this.writeFile(filePath, file, false, null);
    }

    public boolean writeFile(String filePath, File file, boolean auto) throws IOException, UpException {
        return this.writeFile(filePath, file, auto, null);
    }

    public boolean writeFile(String filePath, File file, boolean auto, Map<String, String> params) throws IOException, UpException {
        FileInputStream inputStream = new FileInputStream(file);
        return this.writeFile(filePath, inputStream, auto, params);
    }

    public boolean writeFile(String filePath, InputStream inputStream, boolean auto, Map<String, String> params) throws IOException, UpException {
        filePath = this.formatPath(filePath);
        OutputStream os = null;
        HttpURLConnection conn = null;
        URL url = new URL("http://" + this.apiDomain + filePath);
        conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod("PUT");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        String date = this.getGMTDate();
        conn.setRequestProperty("Date", date);
        conn.setRequestProperty("User-Agent", "upyun-java-sdk/4.2.0");
        if (!this.isEmpty(this.contentMD5)) {
            conn.setRequestProperty("Content-MD5", this.contentMD5);
        }
        conn.setRequestProperty("Authorization", UpYunUtils.sign("PUT", date, filePath, this.userName, this.password, this.contentMD5).trim());
        this.contentMD5 = null;
        if (!this.isEmpty(this.fileSecret)) {
            conn.setRequestProperty("Content-Secret", this.fileSecret);
            this.fileSecret = null;
        }
        if (auto) {
            conn.setRequestProperty("mkdir", "true");
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                conn.setRequestProperty(param.getKey(), param.getValue());
            }
        }
        conn.connect();
        os = conn.getOutputStream();
        byte[] data = new byte[4096];
        int temp = 0;
        while ((temp = inputStream.read(data)) != -1) {
            os.write(data, 0, temp);
        }
        this.getText(conn, false);
        if (os != null) {
            os.close();
            os = null;
        }
        if (inputStream != null) {
            inputStream.close();
            inputStream = null;
        }
        if (conn != null) {
            conn.disconnect();
            conn = null;
        }
        return true;
    }

    public String readFile(String filePath) throws IOException, UpException {
        return this.HttpAction("GET", this.formatPath(filePath));
    }

    public boolean readFile(String filePath, File file) throws IOException, UpException {
        String result = this.HttpAction("GET", this.formatPath(filePath), null, file, false);
        return "".equals(result);
    }

    public Map<String, String> getFileInfo(String filePath) throws IOException, UpException {
        this.HttpAction("HEAD", this.formatPath(filePath));
        return this.headers;
    }

    public boolean deleteFile(String filePath, Map<String, String> params) throws IOException, UpException {
        return this.HttpAction("DELETE", this.formatPath(filePath), params) != null;
    }

    public boolean mkDir(String path) throws IOException, UpException {
        return this.mkDir(path, false);
    }

    public boolean mkDir(String path, boolean auto) throws IOException, UpException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(PARAMS.KEY_MAKE_DIR.getValue(), "true");
        String result = this.HttpAction("PUT", this.formatPath(path), null, null, auto, params);
        return result != null;
    }

    @Deprecated
    public List<FolderItem> readDir(String path, Map<String, String> params) throws IOException, UpException {
        String result = this.HttpAction("GET", this.formatPath(path) + "/", params);
        if (this.isEmpty(result)) {
            return null;
        }
        LinkedList<FolderItem> list = new LinkedList<FolderItem>();
        String[] datas = result.split("\n");
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i].indexOf("\t") <= 0) continue;
            list.add(new FolderItem(datas[i]));
        }
        return list;
    }

    public String readDirJson(String path, Map<String, String> params) throws IOException, UpException {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("Accept", "application/json");
        return this.HttpAction("GET", this.formatPath(path) + "/", params);
    }

    public FolderItemIter readDirIter(String path, Map<String, String> params) throws IOException, UpException {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("Accept", "application/json");
        String result = this.HttpAction("GET", this.formatPath(path) + "/", params);
        JSONObject jObject1 = new JSONObject(result);
        FolderItemIter folderItemIter = new FolderItemIter();
        folderItemIter.iter = jObject1.getString("iter");
        folderItemIter.files = new ArrayList();
        JSONArray jsonArray2 = jObject1.getJSONArray("files");
        for (int i = 0; i < jsonArray2.length(); ++i) {
            JSONObject jObject3 = jsonArray2.getJSONObject(i);
            FolderItem folderItem = new FolderItem(jObject3.getString("type"), jObject3.getString("name"), jObject3.getLong("length"), jObject3.getLong("last_modified"));
            folderItemIter.files.add(folderItem);
        }
        return folderItemIter;
    }

    public boolean rmDir(String path) throws IOException, UpException {
        return this.HttpAction("DELETE", this.formatPath(path)) != null;
    }

    public boolean copyFile(String path, String sourcePath) throws IOException, UpException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(PARAMS.KEY_X_UPYUN_COPY_SOURCE.getValue(), sourcePath);
        String result = this.HttpAction("PUT", this.formatPath(path), null, null, false, params);
        return result != null;
    }

    public boolean moveFile(String path, String sourcePath) throws IOException, UpException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(PARAMS.KEY_X_UPYUN_MOVE_SOURCE.getValue(), sourcePath);
        String result = this.HttpAction("PUT", this.formatPath(path), null, null, false, params);
        return result != null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static String md5(String str) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        byte[] encodedValue = md5.digest();
        int j = encodedValue.length;
        char[] finalValue = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte encoded = encodedValue[i];
            finalValue[k++] = hexDigits[encoded >> 4 & 0xF];
            finalValue[k++] = hexDigits[encoded & 0xF];
        }
        return new String(finalValue);
    }

    public static String md5(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            int n = 0;
            byte[] buffer = new byte[1024];
            do {
                if ((n = is.read(buffer)) <= 0) continue;
                md5.update(buffer, 0, n);
            } while (n != -1);
            is.skip(0L);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            is.close();
        }
        byte[] encodedValue = md5.digest();
        int j = encodedValue.length;
        char[] finalValue = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte encoded = encodedValue[i];
            finalValue[k++] = hexDigits[encoded >> 4 & 0xF];
            finalValue[k++] = hexDigits[encoded & 0xF];
        }
        return new String(finalValue);
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private String sign(HttpURLConnection conn, String uri, long length) {
        String sign = conn.getRequestMethod() + "&" + uri + "&" + conn.getRequestProperty("Date") + "&" + length + "&" + this.password;
        return "UpYun " + this.userName + ":" + UpYun.md5(sign);
    }

    private String HttpAction(String method, String uri) throws IOException, UpException {
        return this.HttpAction(method, uri, null, null, false);
    }

    private String HttpAction(String method, String uri, Map<String, String> param) throws IOException, UpException {
        return this.HttpAction(method, uri, null, null, false, param);
    }

    private String HttpAction(String method, String uri, byte[] datas, File outFile, boolean auto) throws IOException, UpException {
        return this.HttpAction(method, uri, datas, outFile, auto, null);
    }

    private String HttpAction(String method, String uri, byte[] datas, File outFile, boolean auto, Map<String, String> params) throws IOException, UpException {
        String result = null;
        HttpURLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        URL url = new URL("http://" + this.apiDomain + uri);
        conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod(method);
        conn.setUseCaches(false);
        if (!(method.equals("DELETE") || method.equals("HEAD") || method.equals("GET"))) {
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
        }
        String date = this.getGMTDate();
        conn.setRequestProperty("Date", date);
        conn.setRequestProperty("User-Agent", "upyun-java-sdk/4.2.0");
        if (auto) {
            conn.setRequestProperty("mkdir", "true");
        }
        long contentLength = 0L;
        if (datas == null) {
            conn.setRequestProperty("Content-Length", "0");
        } else {
            contentLength = datas.length;
            conn.setRequestProperty("Content-Length", String.valueOf(datas.length));
            if (!this.isEmpty(this.contentMD5)) {
                conn.setRequestProperty("Content-MD5", this.contentMD5);
            }
            if (!this.isEmpty(this.fileSecret)) {
                conn.setRequestProperty("Content-Secret", this.fileSecret);
                this.fileSecret = null;
            }
        }
        conn.setRequestProperty("Authorization", UpYunUtils.sign(method, date, uri, this.userName, this.password, this.contentMD5));
        this.contentMD5 = null;
        boolean isFolder = false;
        if (params != null && !params.isEmpty()) {
            isFolder = !this.isEmpty(params.get(PARAMS.KEY_MAKE_DIR.getValue()));
            for (Map.Entry<String, String> param : params.entrySet()) {
                conn.setRequestProperty(param.getKey(), param.getValue());
            }
        }
        conn.connect();
        if (datas != null) {
            os = conn.getOutputStream();
            os.write(datas);
            os.flush();
        }
        if (isFolder) {
            os = conn.getOutputStream();
            os.flush();
        }
        if (outFile == null) {
            result = this.getText(conn, "HEAD".equals(method));
        } else {
            result = "";
            os = new FileOutputStream(outFile);
            byte[] data = new byte[4096];
            int temp = 0;
            is = conn.getInputStream();
            while ((temp = is.read(data)) != -1) {
                os.write(data, 0, temp);
            }
        }
        try {
            if (os != null) {
                os.close();
                os = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (conn != null) {
            conn.disconnect();
            conn = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText(HttpURLConnection conn, boolean isHeadMethod) throws IOException, UpAPIException {
        StringBuilder text = new StringBuilder();
        InputStream is = null;
        InputStreamReader sr = null;
        BufferedReader br = null;
        this.headers = null;
        int code = conn.getResponseCode();
        try {
            InputStream inputStream = is = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (!isHeadMethod) {
                sr = new InputStreamReader(is);
                br = new BufferedReader(sr);
                char[] chars = new char[4096];
                int length = 0;
                while ((length = br.read(chars)) != -1) {
                    text.append(chars, 0, length);
                }
            }
            if (code >= 200 && code < 300) {
                this.headers = new HashMap<String, String>();
                Map<String, List<String>> h = conn.getHeaderFields();
                Set<String> keys = h.keySet();
                for (String key : keys) {
                    String val = conn.getHeaderField(key);
                    if (key == null || val == null) continue;
                    this.headers.put(key, val);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
            if (sr != null) {
                sr.close();
                sr = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        if (isHeadMethod) {
            if (code >= 400) {
                return null;
            }
            return "";
        }
        if (code >= 400) {
            throw new UpAPIException(code, text.toString());
        }
        return text.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private String formatPath(String path) {
        if (!this.isEmpty(path) && !(path = path.trim()).startsWith("/")) {
            return "/" + this.bucketName + "/" + path;
        }
        return "/" + this.bucketName + path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PARAMS {
        KEY_X_GMKERL_TYPE("x-gmkerl-type"),
        KEY_X_GMKERL_VALUE("x-gmkerl-value"),
        KEY_X_GMKERL_QUALITY("x-gmkerl-quality"),
        KEY_X_GMKERL_UNSHARP("x-gmkerl-unsharp"),
        KEY_X_GMKERL_THUMBNAIL("x-gmkerl-thumbnail"),
        KEY_X_GMKERL_ROTATE("x-gmkerl-rotate"),
        KEY_X_GMKERL_CROP("x-gmkerl-crop"),
        KEY_X_GMKERL_EXIF_SWITCH("x-gmkerl-exif-switch"),
        KEY_MAKE_DIR("folder"),
        KEY_X_UPYUN_COPY_SOURCE("X-Upyun-Copy-Source"),
        KEY_X_UPYUN_MOVE_SOURCE("X-Upyun-Move-Source"),
        KEY_X_LIST_ITER("x-list-iter"),
        KEY_X_LIST_LIMIT("x-list-limit"),
        KEY_X_LIST_ORDER("x-list-order"),
        KEY_ACCEPT("Accept"),
        KEY_X_UPYUN_ASYNC("x-upyun-async"),
        VALUE_FIX_MAX("fix_max"),
        VALUE_FIX_MIN("fix_min"),
        VALUE_FIX_WIDTH_OR_HEIGHT("fix_width_or_height"),
        VALUE_FIX_WIDTH("fix_width"),
        VALUE_FIX_HEIGHT("fix_height"),
        VALUE_SQUARE("square"),
        VALUE_FIX_BOTH("fix_both"),
        VALUE_FIX_SCALE("fix_scale"),
        VALUE_ROTATE_AUTO("auto"),
        VALUE_ROTATE_90("90"),
        VALUE_ROTATE_180("180"),
        VALUE_ROTATE_270("270");

        private final String value;

        private PARAMS(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class FolderItemIter {
        public String iter;
        public ArrayList<FolderItem> files;

        public String toString() {
            return "FolderItemIter{iter='" + this.iter + '\'' + ", files=" + this.files + '}';
        }
    }

    public class FolderItem {
        public String name;
        public String type;
        public long size;
        public Date date;

        public FolderItem(String data) {
            String[] a = data.split("\t");
            if (a.length == 4) {
                this.name = a[0];
                this.type = "N".equals(a[1]) ? "File" : "Folder";
                try {
                    this.size = Long.parseLong(a[2].trim());
                }
                catch (NumberFormatException e) {
                    this.size = -1L;
                }
                long da = 0L;
                try {
                    da = Long.parseLong(a[3].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.date = new Date(da * 1000L);
            }
        }

        public FolderItem(String type, String name, long length, long last_modified) {
            this.type = type;
            this.name = name;
            this.size = length;
            this.date = new Date(last_modified * 1000L);
        }

        public String toString() {
            return "FolderItem{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", size=" + this.size + ", date=" + this.date + '}';
        }
    }
}

