/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.BaseUploader;
import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialUploader
extends BaseUploader {
    private int nextPartIndex;

    public boolean resume() throws IOException, UpException {
        this.paused = false;
        return this.startUpload();
    }

    public boolean resume(String uuid, int nextPartIndex) throws IOException, UpException {
        this.uuid = uuid;
        this.nextPartIndex = nextPartIndex;
        if (uuid == null) {
            throw new UpException("uuid is null, please restart!");
        }
        this.paused = false;
        return this.startUpload();
    }

    public SerialUploader(String bucketName, String userName, String password) {
        super(bucketName, userName, password);
    }

    public boolean upload(String filePath, String uploadPath, Map<String, String> params) throws IOException, UpException {
        this.init(filePath, uploadPath, params);
        return this.startUpload();
    }

    public int getNextPartIndex() {
        return this.nextPartIndex;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setNextPartIndex(int nextPartIndex) {
        this.nextPartIndex = nextPartIndex;
    }

    @Override
    boolean processUpload() throws IOException, UpException {
        while (this.nextPartIndex >= 0) {
            if (this.paused) {
                throw new UpException("upload paused");
            }
            byte[] data = this.readBlockByIndex(this.nextPartIndex);
            RequestBody requestBody = RequestBody.create(null, (byte[])data);
            String date = this.getGMTDate();
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5(data);
            }
            String sign = UpYunUtils.sign("PUT", date, this.uri, this.userName, this.password, md5);
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header("Authorization", sign.trim()).header("X-Upyun-Multi-Stage", "upload").header("X-Upyun-Multi-UUID", this.uuid).header("X-Upyun-Part-ID", this.nextPartIndex + "").header("User-Agent", "upyun-java-sdk/4.2.0").put(requestBody);
            if (md5 != null) {
                builder.header("Content-MD5", md5);
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onProgress(this.nextPartIndex + 2, this.totalBlock);
            }
            this.callProcessRequest(builder.build());
        }
        return this.completeUpload();
    }

    @Override
    boolean completeUpload() throws IOException, UpException {
        this.completeRequest();
        this.uuid = null;
        return true;
    }

    private void callProcessRequest(Request request) throws IOException, UpException {
        Response response = this.mClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            int x_error_code = Integer.parseInt(response.header("X-Error-Code", "-1"));
            if (x_error_code != 40011061 && x_error_code != 40011059) {
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                }
                this.uuid = null;
                throw new UpException(response.body().string());
            }
            this.nextPartIndex = Integer.parseInt(response.header("X-Upyun-Next-Part-ID", "-2"));
            return;
        }
        this.uuid = response.header("X-Upyun-Multi-UUID", "");
        this.nextPartIndex = Integer.parseInt(response.header("X-Upyun-Next-Part-ID", "-2"));
    }
}

