/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.actions.ActionArguments;
import com.urbanairship.actions.ActionCompletionCallback;
import com.urbanairship.actions.ActionResult;
import com.urbanairship.actions.ActionRunRequestFactory;
import com.urbanairship.automation.AutomationDriver;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelegate;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.experiment.ExperimentResult;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ActionsScheduleDelegate
implements ScheduleDelegate<Actions> {
    private final ActionRunRequestFactory actionRunRequestFactory;
    private final Map<String, Actions> actionsMap = new HashMap<String, Actions>();

    ActionsScheduleDelegate(ActionRunRequestFactory actionRunRequestFactory) {
        this.actionRunRequestFactory = actionRunRequestFactory;
    }

    ActionsScheduleDelegate() {
        this(new ActionRunRequestFactory());
    }

    @Override
    public void onNewSchedule(@NonNull Schedule<? extends ScheduleData> schedule) {
    }

    @Override
    public void onScheduleFinished(@NonNull Schedule<? extends ScheduleData> schedule) {
    }

    @Override
    public void onPrepareSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull Actions scheduleData, @Nullable ExperimentResult experimentResult, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        this.actionsMap.put(schedule.getId(), scheduleData);
        callback.onFinish(0);
    }

    @Override
    public void onExecutionInvalidated(@NonNull Schedule<? extends ScheduleData> schedule) {
        this.actionsMap.remove(schedule.getId());
    }

    @Override
    public void onExecutionInterrupted(@NonNull Schedule<? extends ScheduleData> schedule) {
    }

    @Override
    public void onExecute(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull AutomationDriver.ExecutionCallback callback) {
        Actions actions = this.actionsMap.get(schedule.getId());
        if (actions == null) {
            callback.onFinish();
            return;
        }
        Bundle metadata = new Bundle();
        metadata.putString("com.urbanairship.ACTION_SCHEDULE_ID", schedule.getId());
        ActionCallback actionCallback = new ActionCallback(callback, actions.getActionsMap().size());
        for (Map.Entry entry : actions.getActionsMap().entrySet()) {
            this.actionRunRequestFactory.createActionRequest((String)entry.getKey()).setValue(entry.getValue()).setSituation(6).setMetadata(metadata).run(Looper.getMainLooper(), (ActionCompletionCallback)actionCallback);
        }
    }

    @Override
    public int onCheckExecutionReadiness(@NonNull Schedule<? extends ScheduleData> schedule) {
        if (this.actionsMap.containsKey(schedule.getId())) {
            return 1;
        }
        return -1;
    }

    static class ActionCallback
    implements ActionCompletionCallback {
        private final AutomationDriver.ExecutionCallback callback;
        private int pendingActionCallbacks;

        ActionCallback(AutomationDriver.ExecutionCallback callback, int pendingActionCallbacks) {
            this.callback = callback;
            this.pendingActionCallbacks = pendingActionCallbacks;
        }

        public void onFinish(@NonNull ActionArguments arguments, @NonNull ActionResult result) {
            --this.pendingActionCallbacks;
            if (this.pendingActionCallbacks == 0) {
                this.callback.onFinish();
            }
        }
    }
}

