/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.audience.DeviceTagSelector;
import com.urbanairship.automation.tags.TagSelector;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonPredicate;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.json.ValueMatcher;
import com.urbanairship.util.VersionUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class Audience
implements JsonSerializable {
    private AudienceSelector audienceSelector;
    @NonNull
    public static final String MISS_BEHAVIOR_CANCEL = "cancel";
    @NonNull
    public static final String MISS_BEHAVIOR_SKIP = "skip";
    @NonNull
    public static final String MISS_BEHAVIOR_PENALIZE = "penalize";

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Audience(@NonNull AudienceSelector selector) {
        this.audienceSelector = selector;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return this.audienceSelector.toJsonValue();
    }

    @NonNull
    public static Audience fromJson(@NonNull JsonValue value) throws JsonException {
        return new Audience(AudienceSelector.Companion.fromJson(value));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public List<String> getLanguageTags() {
        return this.audienceSelector.getLanguageTags();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public AudienceSelector getAudienceSelector() {
        return this.audienceSelector;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public List<String> getTestDevices() {
        return this.audienceSelector.getTestDevices();
    }

    @Nullable
    public Boolean getNotificationsOptIn() {
        return this.audienceSelector.getNotificationsOptIn();
    }

    @Nullable
    public Boolean getLocationOptIn() {
        return this.audienceSelector.getLocationOptIn();
    }

    @Nullable
    public Boolean getRequiresAnalytics() {
        return this.audienceSelector.getRequiresAnalytics();
    }

    @Nullable
    public Boolean getNewUser() {
        return this.audienceSelector.getNewUser();
    }

    @Nullable
    public TagSelector getTagSelector() {
        DeviceTagSelector core = this.audienceSelector.getTagSelector();
        if (core == null) {
            return null;
        }
        return new TagSelector(core);
    }

    @Nullable
    public JsonPredicate getVersionPredicate() {
        return this.audienceSelector.getVersionPredicate();
    }

    @Nullable
    public JsonPredicate getPermissionsPredicate() {
        return this.audienceSelector.getPermissionsPredicate();
    }

    @NonNull
    public String getMissBehavior() {
        return this.audienceSelector.getMissBehavior().getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Audience audience = (Audience)o;
        return this.audienceSelector.equals((Object)audience.audienceSelector);
    }

    public int hashCode() {
        return this.audienceSelector.hashCode();
    }

    public String toString() {
        return this.audienceSelector.toString();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private AudienceSelector.Builder coreBuilder = AudienceSelector.Companion.newBuilder();

        private Builder() {
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        Builder setNewUser(boolean newUser) {
            this.coreBuilder.setNewUser(newUser);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        Builder addTestDevice(String hash) {
            this.coreBuilder.addTestDevice(hash);
            return this;
        }

        @NonNull
        public Builder setLocationOptIn(boolean optIn) {
            this.coreBuilder.setLocationOptIn(optIn);
            return this;
        }

        @NonNull
        public Builder setRequiresAnalytics(boolean requiresAnalytics) {
            this.coreBuilder.setRequiresAnalytics(requiresAnalytics);
            return this;
        }

        @NonNull
        public Builder setNotificationsOptIn(boolean optIn) {
            this.coreBuilder.setNotificationsOptIn(optIn);
            return this;
        }

        @NonNull
        public Builder addLanguageTag(@NonNull String languageTag) {
            this.coreBuilder.addLanguageTag(languageTag);
            return this;
        }

        @NonNull
        private Builder setVersionPredicate(@Nullable JsonPredicate predicate) {
            this.coreBuilder.setVersionPredicate(predicate);
            return this;
        }

        @NonNull
        public Builder setPermissionsPredicate(@NonNull JsonPredicate predicate) {
            this.coreBuilder.setPermissionsPredicate(predicate);
            return this;
        }

        @NonNull
        public Builder setVersionMatcher(@Nullable ValueMatcher valueMatcher) {
            return this.setVersionPredicate(valueMatcher == null ? null : VersionUtils.createVersionPredicate((ValueMatcher)valueMatcher));
        }

        @NonNull
        public Builder setTagSelector(@Nullable TagSelector tagSelector) {
            this.coreBuilder.setTagSelector(tagSelector.getTagSelector());
            return this;
        }

        @NonNull
        public Builder setMissBehavior(@NonNull String missBehavior) {
            AudienceSelector.MissBehavior behavior = AudienceSelector.MissBehavior.Companion.parse(missBehavior);
            this.coreBuilder.setMissBehavior(behavior);
            return this;
        }

        @NonNull
        public Audience build() {
            return new Audience(this.coreBuilder.build());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MissBehavior {
    }
}

