/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Consumer;
import com.urbanairship.CancelableOperation;
import com.urbanairship.PendingResult;
import com.urbanairship.Predicate;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.UALog;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.analytics.AnalyticsListener;
import com.urbanairship.analytics.CustomEvent;
import com.urbanairship.analytics.Event;
import com.urbanairship.analytics.location.RegionEvent;
import com.urbanairship.app.ActivityListener;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.app.ApplicationListener;
import com.urbanairship.app.SimpleActivityListener;
import com.urbanairship.automation.AutomationDriver;
import com.urbanairship.automation.NetworkMonitor;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleConverters;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleEdits;
import com.urbanairship.automation.TriggerContext;
import com.urbanairship.automation.TriggerObservables;
import com.urbanairship.automation.alarms.AlarmOperationScheduler;
import com.urbanairship.automation.alarms.OperationScheduler;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.AutomationDaoWrapper;
import com.urbanairship.automation.storage.AutomationDatabase;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.LegacyDataMigrator;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.iam.InAppActivityMonitor;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.reactive.Function;
import com.urbanairship.reactive.Observable;
import com.urbanairship.reactive.Observer;
import com.urbanairship.reactive.Scheduler;
import com.urbanairship.reactive.Schedulers;
import com.urbanairship.reactive.Subject;
import com.urbanairship.reactive.Subscriber;
import com.urbanairship.reactive.Subscription;
import com.urbanairship.util.AirshipHandlerThread;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AutomationEngine {
    private long SCHEDULE_LIMIT = 1000L;
    private final List<Integer> COMPOUND_TRIGGER_TYPES = Arrays.asList(9, 10);
    private final Comparator<FullSchedule> SCHEDULE_COMPARATOR = new Comparator<FullSchedule>(){

        @Override
        public int compare(@NonNull FullSchedule lh, @NonNull FullSchedule rh) {
            if (lh.schedule.triggeredTime == rh.schedule.triggeredTime) {
                if (lh.schedule.priority == rh.schedule.priority) {
                    return 0;
                }
                return lh.schedule.priority > rh.schedule.priority ? 1 : -1;
            }
            return lh.schedule.triggeredTime > rh.schedule.triggeredTime ? 1 : -1;
        }
    };
    private final ActivityMonitor activityMonitor;
    private AutomationDriver driver;
    private final Analytics analytics;
    private final OperationScheduler scheduler;
    private volatile boolean isStarted;
    private Handler backgroundHandler;
    private final Handler mainHandler;
    private ScheduleListener scheduleListener;
    private final LegacyDataMigrator legacyDataMigrator;
    private long startTime;
    private final SparseArray<Long> stateChangeTimeStamps = new SparseArray();
    private NetworkMonitor networkMonitor;
    @VisibleForTesting
    HandlerThread backgroundThread;
    private final List<ScheduleOperation> pendingAlarmOperations = new ArrayList<ScheduleOperation>();
    private String screen;
    private String regionId;
    private Subject<TriggerUpdate> stateObservableUpdates;
    private Subscription compoundTriggerSubscription;
    private Scheduler backgroundScheduler;
    private final AutomationDao dao;
    private final ApplicationListener applicationListener = new ApplicationListener(){

        public void onForeground(long time) {
            AutomationEngine.this.onEventAdded((JsonSerializable)JsonValue.NULL, 1, 1.0);
            AutomationEngine.this.checkPendingSchedules();
        }

        public void onBackground(long time) {
            AutomationEngine.this.onEventAdded((JsonSerializable)JsonValue.NULL, 2, 1.0);
            AutomationEngine.this.checkPendingSchedules();
        }
    };
    private final ActivityListener activityListener = new SimpleActivityListener(){

        public void onActivityResumed(@NonNull Activity activity) {
            AutomationEngine.this.checkPendingSchedules();
        }
    };
    private final AnalyticsListener analyticsListener = new AnalyticsListener(){

        public void onRegionEventAdded(@NonNull RegionEvent regionEvent) {
            AutomationEngine.this.regionId = regionEvent.toJsonValue().optMap().opt("region_id").getString();
            int type = regionEvent.getBoundaryEvent() == 1 ? 3 : 4;
            AutomationEngine.this.onEventAdded((JsonSerializable)regionEvent.toJsonValue(), type, 1.0);
            AutomationEngine.this.checkPendingSchedules();
        }

        public void onCustomEventAdded(@NonNull CustomEvent customEvent) {
            AutomationEngine.this.onEventAdded((JsonSerializable)customEvent.toJsonValue(), 5, 1.0);
            BigDecimal eventValue = customEvent.getEventValue();
            if (eventValue != null) {
                AutomationEngine.this.onEventAdded((JsonSerializable)customEvent.toJsonValue(), 6, eventValue.doubleValue());
            }
        }

        public void onFeatureFlagInteractedEventAdded(@NonNull Event event) {
            AutomationEngine.this.onEventAdded((JsonSerializable)event.getEventData(), 11, 1.0);
        }

        public void onScreenTracked(@NonNull String screenName) {
            AutomationEngine.this.screen = screenName;
            AutomationEngine.this.onEventAdded((JsonSerializable)JsonValue.wrap((String)screenName), 7, 1.0);
            AutomationEngine.this.checkPendingSchedules();
        }
    };
    private final NetworkMonitor.ConnectionListener connectionListener = isConnected -> {
        if (isConnected) {
            this.checkPendingSchedules();
        }
    };
    private final PausedManager pausedManager;

    AutomationEngine(@NonNull Context context, @NonNull AirshipRuntimeConfig runtimeConfig, @NonNull Analytics analytics, @NonNull PreferenceDataStore dataStore) {
        this(analytics, InAppActivityMonitor.shared(context), AlarmOperationScheduler.shared(context), new AutomationDaoWrapper(AutomationDatabase.createDatabase(context, runtimeConfig).getScheduleDao()), new LegacyDataMigrator(context, runtimeConfig, dataStore));
    }

    @VisibleForTesting
    AutomationEngine(@NonNull Analytics analytics, @NonNull ActivityMonitor activityMonitor, @NonNull OperationScheduler scheduler, @NonNull AutomationDao dao, @NonNull LegacyDataMigrator legacyDataMigrator) {
        this.analytics = analytics;
        this.activityMonitor = activityMonitor;
        this.scheduler = scheduler;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.dao = dao;
        this.legacyDataMigrator = legacyDataMigrator;
        this.pausedManager = new PausedManager();
    }

    public void start(@NonNull AutomationDriver driver) {
        if (this.isStarted) {
            return;
        }
        this.driver = driver;
        this.startTime = System.currentTimeMillis();
        this.backgroundThread = new AirshipHandlerThread("automation");
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
        this.backgroundScheduler = Schedulers.looper((Looper)this.backgroundThread.getLooper());
        this.networkMonitor = new NetworkMonitor();
        this.networkMonitor.setConnectionListener(this.connectionListener);
        this.activityMonitor.addApplicationListener(this.applicationListener);
        this.activityMonitor.addActivityListener(this.activityListener);
        this.analytics.addAnalyticsListener(this.analyticsListener);
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.legacyDataMigrator.migrateData(AutomationEngine.this.dao);
                AutomationEngine.this.finishExecutingSchedules();
                AutomationEngine.this.cleanSchedules();
                AutomationEngine.this.resetWaitingSchedules();
                AutomationEngine.this.restoreDelayAlarms();
                AutomationEngine.this.restoreIntervalAlarms();
                AutomationEngine.this.prepareSchedules(AutomationEngine.this.dao.getSchedulesWithStates(6));
            }
        });
        this.restoreCompoundTriggers();
        this.onEventAdded((JsonSerializable)JsonValue.NULL, 8, 1.0);
        this.isStarted = true;
        this.checkPendingSchedules();
    }

    public void setPaused(boolean isPaused) {
        this.pausedManager.setPaused(isPaused);
        if (!isPaused && this.isStarted) {
            this.checkPendingSchedules();
        }
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.compoundTriggerSubscription.cancel();
        this.activityMonitor.removeApplicationListener(this.applicationListener);
        this.analytics.removeAnalyticsListener(this.analyticsListener);
        this.networkMonitor.teardown();
        this.cancelAlarms();
        this.backgroundThread.quit();
        this.backgroundThread = null;
        this.isStarted = false;
    }

    @NonNull
    public PendingResult<Boolean> schedule(final @NonNull Schedule<? extends ScheduleData> schedule) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                if ((long)AutomationEngine.this.dao.getScheduleCount() >= AutomationEngine.this.SCHEDULE_LIMIT) {
                    UALog.e((String)"AutomationEngine - Unable to insert schedule due to schedule exceeded limit.", (Object[])new Object[0]);
                    pendingResult.setResult((Object)false);
                    return;
                }
                FullSchedule entry = ScheduleConverters.convert(schedule);
                AutomationEngine.this.dao.insert(entry);
                AutomationEngine.this.subscribeStateObservables(Collections.singletonList(entry));
                AutomationEngine.this.notifyNewSchedule(Collections.singletonList(schedule));
                UALog.v((String)"Scheduled entries: %s", (Object[])new Object[]{schedule});
                pendingResult.setResult((Object)true);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Boolean> schedule(final @NonNull List<Schedule<? extends ScheduleData>> schedules) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                if ((long)(AutomationEngine.this.dao.getScheduleCount() + schedules.size()) > AutomationEngine.this.SCHEDULE_LIMIT) {
                    UALog.e((String)"AutomationDataManager - Unable to insert schedule due to schedule exceeded limit.", (Object[])new Object[0]);
                    pendingResult.setResult((Object)false);
                    return;
                }
                List<FullSchedule> entries = ScheduleConverters.convertSchedules(schedules);
                if (entries.isEmpty()) {
                    pendingResult.setResult((Object)false);
                    return;
                }
                AutomationEngine.this.dao.insert(entries);
                AutomationEngine.this.subscribeStateObservables(entries);
                Collection result = AutomationEngine.this.convertSchedulesUnknownTypes(entries);
                AutomationEngine.this.notifyNewSchedule(result);
                UALog.v((String)"Scheduled entries: %s", (Object[])new Object[]{result});
                pendingResult.setResult((Object)true);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Boolean> cancel(final @NonNull Collection<String> ids) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                List<FullSchedule> entries = AutomationEngine.this.dao.getSchedules(ids);
                if (entries.isEmpty()) {
                    pendingResult.setResult((Object)false);
                    return;
                }
                UALog.v((String)"Cancelled schedules: %s", (Object[])new Object[]{ids});
                AutomationEngine.this.dao.deleteSchedules(entries);
                AutomationEngine.this.notifyCancelledSchedule(entries);
                AutomationEngine.this.cancelScheduleAlarms(ids);
                pendingResult.setResult((Object)true);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Boolean> cancelByType(final @NonNull String type) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                List<FullSchedule> entries = AutomationEngine.this.dao.getSchedulesByType(type);
                if (entries.isEmpty()) {
                    pendingResult.setResult((Object)false);
                    return;
                }
                ArrayList<String> ids = new ArrayList<String>();
                for (FullSchedule entry : entries) {
                    ids.add(entry.schedule.scheduleId);
                }
                UALog.v((String)"Cancelled schedules: %s", (Object[])new Object[]{ids});
                AutomationEngine.this.dao.deleteSchedules(entries);
                AutomationEngine.this.notifyCancelledSchedule(entries);
                AutomationEngine.this.cancelScheduleAlarms(ids);
                pendingResult.setResult((Object)true);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Boolean> cancelGroup(final @NonNull String group) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                List<FullSchedule> entries = AutomationEngine.this.dao.getSchedulesWithGroup(group);
                if (entries.isEmpty()) {
                    UALog.v((String)"Failed to cancel schedule group: %s", (Object[])new Object[]{group});
                    pendingResult.setResult((Object)false);
                } else {
                    AutomationEngine.this.dao.deleteSchedules(entries);
                    AutomationEngine.this.cancelGroupAlarms(Collections.singletonList(group));
                    AutomationEngine.this.notifyCancelledSchedule(entries);
                }
            }
        });
        return pendingResult;
    }

    @NonNull
    public <T extends ScheduleData> PendingResult<Collection<Schedule<T>>> getSchedulesByType(final String type) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                List<FullSchedule> entries = AutomationEngine.this.dao.getSchedulesByType(type);
                Collection schedules = AutomationEngine.this.convertSchedules(entries);
                pendingResult.setResult((Object)schedules);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Schedule<? extends ScheduleData>> getSchedule(final @NonNull String scheduleId) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                Schedule result = AutomationEngine.this.convert(AutomationEngine.this.dao.getSchedule(scheduleId));
                pendingResult.setResult((Object)result);
            }
        });
        return pendingResult;
    }

    @NonNull
    public <T extends ScheduleData> PendingResult<Schedule<T>> getSchedule(final @NonNull String scheduleId, final String type) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                Schedule result = AutomationEngine.this.convert(AutomationEngine.this.dao.getSchedule(scheduleId, type));
                pendingResult.setResult((Object)result);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Collection<Schedule<? extends ScheduleData>>> getSchedules(final @NonNull Set<String> scheduleIds) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                pendingResult.setResult((Object)AutomationEngine.this.convertSchedulesUnknownTypes(AutomationEngine.this.dao.getSchedules(scheduleIds)));
            }
        });
        return pendingResult;
    }

    @NonNull
    public <T extends ScheduleData> PendingResult<Collection<Schedule<T>>> getSchedules(final @NonNull String group, final @NonNull String type) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.cleanSchedules();
                Collection schedules = AutomationEngine.this.convertSchedules(AutomationEngine.this.dao.getSchedulesWithGroup(group, type));
                pendingResult.setResult((Object)schedules);
            }
        });
        return pendingResult;
    }

    @NonNull
    public PendingResult<Boolean> editSchedule(final @NonNull String scheduleId, final @NonNull ScheduleEdits<? extends ScheduleData> edits) {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                FullSchedule entry = AutomationEngine.this.dao.getSchedule(scheduleId);
                if (entry == null) {
                    UALog.e((String)"AutomationEngine - Schedule no longer exists. Unable to edit: %s", (Object[])new Object[]{scheduleId});
                    pendingResult.setResult((Object)false);
                    return;
                }
                AutomationEngine.this.applyEdits(entry, edits);
                boolean subscribeForStateChanges = false;
                long stateChangeTimeStamp = -1L;
                boolean isOverLimit = AutomationEngine.this.isOverLimit(entry);
                boolean isExpired = AutomationEngine.this.isExpired(entry);
                if (entry.schedule.executionState == 4 && !isOverLimit && !isExpired) {
                    subscribeForStateChanges = true;
                    stateChangeTimeStamp = entry.schedule.executionStateChangeDate;
                    AutomationEngine.this.updateExecutionState(entry, 0);
                } else if (entry.schedule.executionState != 4 && (isOverLimit || isExpired)) {
                    AutomationEngine.this.updateExecutionState(entry, 4);
                    if (isOverLimit) {
                        AutomationEngine.this.notifyScheduleLimitReached(entry);
                    } else {
                        AutomationEngine.this.notifyExpiredSchedules(Collections.singleton(entry));
                    }
                }
                AutomationEngine.this.dao.update(entry);
                if (subscribeForStateChanges) {
                    AutomationEngine.this.subscribeStateObservables(entry, stateChangeTimeStamp);
                }
                UALog.v((String)"Updated schedule: %s", (Object[])new Object[]{scheduleId});
                pendingResult.setResult((Object)true);
            }
        });
        return pendingResult;
    }

    public void checkPendingSchedules() {
        if (this.isStarted) {
            this.backgroundHandler.post(() -> {
                List<FullSchedule> entries = this.dao.getSchedulesWithStates(1);
                if (entries.isEmpty()) {
                    return;
                }
                this.sortSchedules(entries);
                for (FullSchedule entry : entries) {
                    this.attemptExecution(entry);
                }
            });
        }
    }

    @NonNull
    public PendingResult<Collection<Schedule<? extends ScheduleData>>> getSchedules() {
        final PendingResult pendingResult = new PendingResult();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                pendingResult.setResult((Object)AutomationEngine.this.convertSchedulesUnknownTypes(AutomationEngine.this.dao.getSchedules()));
            }
        });
        return pendingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduleListener(@Nullable ScheduleListener scheduleListener) {
        AutomationEngine automationEngine = this;
        synchronized (automationEngine) {
            this.scheduleListener = scheduleListener;
        }
    }

    @NonNull
    private Observable<JsonSerializable> createEventObservable(int type) {
        switch (type) {
            case 9: {
                return TriggerObservables.newSession(this.activityMonitor, this.pausedManager);
            }
        }
        return Observable.empty();
    }

    @NonNull
    private Observable<JsonSerializable> createStateObservable(int type) {
        switch (type) {
            case 9: {
                return TriggerObservables.foregrounded(this.activityMonitor);
            }
            case 10: {
                return TriggerObservables.appVersionUpdated();
            }
        }
        return Observable.empty();
    }

    @WorkerThread
    private void restoreCompoundTriggers() {
        ArrayList<Observable> eventObservables = new ArrayList<Observable>();
        for (final int type : this.COMPOUND_TRIGGER_TYPES) {
            Observable observable = this.createEventObservable(type).observeOn(this.backgroundScheduler).map((Function)new Function<JsonSerializable, TriggerUpdate>(){

                @NonNull
                public TriggerUpdate apply(@NonNull JsonSerializable json) {
                    AutomationEngine.this.stateChangeTimeStamps.put(type, (Object)System.currentTimeMillis());
                    return new TriggerUpdate(AutomationEngine.this.dao.getActiveTriggers(type), json, 1.0);
                }
            });
            eventObservables.add(observable);
        }
        Observable eventStream = Observable.merge(eventObservables);
        this.stateObservableUpdates = Subject.create();
        this.compoundTriggerSubscription = Observable.merge((Observable)eventStream, this.stateObservableUpdates).subscribe((Observer)new Subscriber<TriggerUpdate>(){

            public void onNext(@NonNull TriggerUpdate update) {
                AutomationEngine.this.updateTriggers(update.triggerEntities, update.json, update.value);
            }
        });
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.subscribeStateObservables(AutomationEngine.this.dao.getSchedules());
            }
        });
    }

    @WorkerThread
    private void sortSchedules(@NonNull List<FullSchedule> entries) {
        if (entries.size() > 1) {
            Collections.sort(entries, this.SCHEDULE_COMPARATOR);
        }
    }

    @WorkerThread
    private void subscribeStateObservables(@NonNull List<FullSchedule> entries) {
        this.sortSchedules(entries);
        for (FullSchedule entity : entries) {
            this.subscribeStateObservables(entity, -1L);
        }
    }

    @WorkerThread
    private void subscribeStateObservables(final @NonNull FullSchedule entry, final long lastStateChangeTime) {
        Observable.from(this.COMPOUND_TRIGGER_TYPES).filter((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer triggerType) {
                if ((Long)AutomationEngine.this.stateChangeTimeStamps.get(triggerType.intValue(), (Object)AutomationEngine.this.startTime) <= lastStateChangeTime) {
                    return false;
                }
                for (TriggerEntity triggerEntity : entry.triggers) {
                    if (triggerEntity.triggerType != triggerType) continue;
                    return true;
                }
                return false;
            }
        }).flatMap((Function)new Function<Integer, Observable<TriggerUpdate>>(){

            @NonNull
            public Observable<TriggerUpdate> apply(final @NonNull Integer type) {
                return AutomationEngine.this.createStateObservable(type).observeOn(AutomationEngine.this.backgroundScheduler).map((Function)new Function<JsonSerializable, TriggerUpdate>(){

                    @NonNull
                    public TriggerUpdate apply(@NonNull JsonSerializable json) {
                        return new TriggerUpdate(AutomationEngine.this.dao.getActiveTriggers(type, entry.schedule.scheduleId), json, 1.0);
                    }
                });
            }
        }).subscribe((Observer)new Subscriber<TriggerUpdate>(){

            public void onNext(@NonNull TriggerUpdate value) {
                AutomationEngine.this.stateObservableUpdates.onNext((Object)value);
            }
        });
    }

    @WorkerThread
    private void finishExecutingSchedules() {
        List<FullSchedule> entries = this.dao.getSchedulesWithStates(2);
        for (FullSchedule entry : entries) {
            this.driver.onScheduleExecutionInterrupted(this.convert(entry));
            this.onScheduleFinishedExecuting(entry);
        }
    }

    @WorkerThread
    private void resetWaitingSchedules() {
        List<FullSchedule> entries = this.dao.getSchedulesWithStates(1);
        if (entries.isEmpty()) {
            return;
        }
        for (FullSchedule entry : entries) {
            this.updateExecutionState(entry, 6);
        }
        this.dao.updateSchedules(entries);
        UALog.v((String)"AutomationEngine: Schedules reset state to STATE_PREPARING_SCHEDULE: %s", (Object[])new Object[]{entries});
    }

    @WorkerThread
    private void cleanSchedules() {
        List<FullSchedule> expired = this.dao.getActiveExpiredSchedules();
        List<FullSchedule> finished = this.dao.getSchedulesWithStates(4);
        this.handleExpiredEntries(expired);
        HashSet<FullSchedule> schedulesToDelete = new HashSet<FullSchedule>();
        for (FullSchedule entry : finished) {
            long finishDate;
            if (entry.schedule.editGracePeriod == 0L) {
                finishDate = entry.schedule.executionStateChangeDate;
            } else {
                if (entry.schedule.scheduleEnd < 0L) continue;
                finishDate = entry.schedule.scheduleEnd + entry.schedule.editGracePeriod;
            }
            if (System.currentTimeMillis() < finishDate) continue;
            schedulesToDelete.add(entry);
        }
        if (!schedulesToDelete.isEmpty()) {
            UALog.v((String)"Deleting finished schedules: %s", (Object[])new Object[]{schedulesToDelete});
            this.dao.deleteSchedules(schedulesToDelete);
        }
    }

    @WorkerThread
    private void cancelScheduleAlarms(@NonNull Collection<String> scheduleIds) {
        for (ScheduleOperation alarmOperation : new ArrayList<ScheduleOperation>(this.pendingAlarmOperations)) {
            if (!scheduleIds.contains(alarmOperation.scheduleId)) continue;
            alarmOperation.cancel();
            this.pendingAlarmOperations.remove((Object)alarmOperation);
        }
    }

    @WorkerThread
    private void cancelGroupAlarms(@NonNull Collection<String> groups) {
        for (ScheduleOperation alarmOperation : new ArrayList<ScheduleOperation>(this.pendingAlarmOperations)) {
            if (!groups.contains(alarmOperation.group)) continue;
            alarmOperation.cancel();
            this.pendingAlarmOperations.remove((Object)alarmOperation);
        }
    }

    @WorkerThread
    private void cancelAlarms() {
        for (ScheduleOperation operation : this.pendingAlarmOperations) {
            operation.cancel();
        }
        this.pendingAlarmOperations.clear();
    }

    @WorkerThread
    private void restoreDelayAlarms() {
        List<FullSchedule> entries = this.dao.getSchedulesWithStates(5);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<FullSchedule> schedulesToUpdate = new ArrayList<FullSchedule>();
        for (FullSchedule entry : entries) {
            if (entry.schedule.seconds == 0L) continue;
            long delay = TimeUnit.SECONDS.toMillis(entry.schedule.seconds);
            long remainingDelay = Math.min(delay, System.currentTimeMillis() - entry.schedule.executionStateChangeDate);
            if (remainingDelay <= 0L) {
                this.updateExecutionState(entry, 6);
                schedulesToUpdate.add(entry);
                continue;
            }
            this.scheduleDelayAlarm(entry, remainingDelay);
        }
        this.dao.updateSchedules(schedulesToUpdate);
    }

    @WorkerThread
    private void restoreIntervalAlarms() {
        List<FullSchedule> entries = this.dao.getSchedulesWithStates(3);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<FullSchedule> schedulesToUpdate = new ArrayList<FullSchedule>();
        for (FullSchedule entry : entries) {
            long pausedTime = System.currentTimeMillis() - entry.schedule.executionStateChangeDate;
            long remaining = entry.schedule.interval - pausedTime;
            if (remaining > 0L) {
                this.scheduleIntervalAlarm(entry, remaining);
                continue;
            }
            this.updateExecutionState(entry, 0);
            schedulesToUpdate.add(entry);
        }
        this.dao.updateSchedules(schedulesToUpdate);
    }

    private void onEventAdded(final @NonNull JsonSerializable json, final int type, final double value) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                UALog.d((String)"Updating triggers with type: %s", (Object[])new Object[]{type});
                List<TriggerEntity> triggerEntities = AutomationEngine.this.dao.getActiveTriggers(type);
                if (triggerEntities.isEmpty()) {
                    return;
                }
                AutomationEngine.this.updateTriggers(triggerEntities, json, value);
            }
        });
    }

    private void updateTriggers(final @NonNull List<TriggerEntity> triggerEntities, final @NonNull JsonSerializable json, final double value) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AutomationEngine.this.pausedManager.isPaused() || triggerEntities.isEmpty()) {
                    return;
                }
                HashSet<String> triggeredSchedules = new HashSet<String>();
                HashSet<String> cancelledSchedules = new HashSet<String>();
                HashMap<String, TriggerContext> triggerContextMap = new HashMap<String, TriggerContext>();
                ArrayList<TriggerEntity> triggersToUpdate = new ArrayList<TriggerEntity>();
                for (TriggerEntity trigger : triggerEntities) {
                    if (trigger.jsonPredicate != null && !trigger.jsonPredicate.apply(json)) continue;
                    triggersToUpdate.add(trigger);
                    trigger.progress += value;
                    if (!(trigger.progress >= trigger.goal)) continue;
                    trigger.progress = 0.0;
                    if (trigger.isCancellation) {
                        cancelledSchedules.add(trigger.parentScheduleId);
                        AutomationEngine.this.cancelScheduleAlarms(Collections.singletonList(trigger.parentScheduleId));
                        continue;
                    }
                    triggeredSchedules.add(trigger.parentScheduleId);
                    triggerContextMap.put(trigger.parentScheduleId, new TriggerContext(ScheduleConverters.convert(trigger), json.toJsonValue()));
                }
                AutomationEngine.this.dao.updateTriggers(triggersToUpdate);
                if (!cancelledSchedules.isEmpty()) {
                    AutomationEngine.this.handleCancelledSchedules(AutomationEngine.this.dao.getSchedules(cancelledSchedules));
                }
                if (!triggeredSchedules.isEmpty()) {
                    AutomationEngine.this.handleTriggeredSchedules(AutomationEngine.this.dao.getSchedules(triggeredSchedules), triggerContextMap);
                }
            }
        });
    }

    @WorkerThread
    private void handleCancelledSchedules(@NonNull List<FullSchedule> scheduleEntries) {
        if (scheduleEntries.isEmpty()) {
            return;
        }
        for (FullSchedule entry : scheduleEntries) {
            this.updateExecutionState(entry, 0);
        }
        this.dao.updateSchedules(scheduleEntries);
    }

    @WorkerThread
    private void handleTriggeredSchedules(@NonNull List<FullSchedule> scheduleEntries, Map<String, TriggerContext> triggerContextMap) {
        if (this.pausedManager.isPaused() || scheduleEntries.isEmpty()) {
            return;
        }
        ArrayList<FullSchedule> schedulesToUpdate = new ArrayList<FullSchedule>();
        ArrayList<FullSchedule> expiredSchedules = new ArrayList<FullSchedule>();
        ArrayList<FullSchedule> schedulesToPrepare = new ArrayList<FullSchedule>();
        for (FullSchedule entry : scheduleEntries) {
            if (entry.schedule.executionState != 0) continue;
            schedulesToUpdate.add(entry);
            entry.schedule.triggerContext = triggerContextMap.get(entry.schedule.scheduleId);
            if (this.isExpired(entry)) {
                expiredSchedules.add(entry);
                continue;
            }
            for (TriggerEntity trigger : entry.triggers) {
                if (!trigger.isCancellation) continue;
                trigger.progress = 0.0;
            }
            if (entry.schedule.seconds > 0L) {
                this.updateExecutionState(entry, 5);
                this.scheduleDelayAlarm(entry, TimeUnit.SECONDS.toMillis(entry.schedule.seconds));
                continue;
            }
            this.updateExecutionState(entry, 6);
            schedulesToPrepare.add(entry);
        }
        this.dao.updateSchedules(schedulesToUpdate);
        this.prepareSchedules(schedulesToPrepare);
        this.handleExpiredEntries(expiredSchedules);
    }

    @WorkerThread
    private void prepareSchedules(@Nullable List<FullSchedule> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        this.sortSchedules(entries);
        for (FullSchedule entry : entries) {
            Schedule schedule = this.convert(entry);
            if (schedule == null) continue;
            final String scheduleId = schedule.getId();
            this.driver.onPrepareSchedule(schedule, entry.schedule.triggerContext, new AutomationDriver.PrepareScheduleCallback(){

                @Override
                public void onFinish(final int result) {
                    AutomationEngine.this.backgroundHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            FullSchedule entry = AutomationEngine.this.dao.getSchedule(scheduleId);
                            if (entry == null || entry.schedule.executionState != 6) {
                                return;
                            }
                            if (AutomationEngine.this.isExpired(entry)) {
                                AutomationEngine.this.handleExpiredEntry(entry);
                                return;
                            }
                            switch (result) {
                                case 1: {
                                    AutomationEngine.this.dao.delete(entry);
                                    AutomationEngine.this.notifyCancelledSchedule(Collections.singleton(entry));
                                    break;
                                }
                                case 0: {
                                    AutomationEngine.this.updateExecutionState(entry, 1);
                                    AutomationEngine.this.dao.update(entry);
                                    AutomationEngine.this.checkPendingSchedules();
                                    break;
                                }
                                case 3: {
                                    AutomationEngine.this.updateExecutionState(entry, 0);
                                    AutomationEngine.this.dao.update(entry);
                                    break;
                                }
                                case 2: {
                                    AutomationEngine.this.onScheduleFinishedExecuting(entry);
                                    break;
                                }
                                case 4: {
                                    AutomationEngine.this.prepareSchedules(Collections.singletonList(entry));
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    @Nullable
    private <T extends ScheduleData> Schedule<T> convert(@Nullable FullSchedule entry) {
        if (entry == null) {
            return null;
        }
        try {
            return ScheduleConverters.convert(entry);
        }
        catch (ClassCastException e) {
            UALog.e((Throwable)e, (String)"Exception converting entity to schedule %s", (Object[])new Object[]{entry.schedule.scheduleId});
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Exception converting entity to schedule %s. Cancelling.", (Object[])new Object[]{entry.schedule.scheduleId});
            this.cancel(Collections.singleton(entry.schedule.scheduleId));
        }
        return null;
    }

    @NonNull
    private Collection<Schedule<? extends ScheduleData>> convertSchedulesUnknownTypes(@NonNull Collection<FullSchedule> entries) {
        ArrayList<Schedule<? extends ScheduleData>> schedules = new ArrayList<Schedule<? extends ScheduleData>>();
        for (FullSchedule entry : entries) {
            Schedule schedule = this.convert(entry);
            if (schedule == null) continue;
            schedules.add(schedule);
        }
        return schedules;
    }

    @NonNull
    private <T extends ScheduleData> Collection<Schedule<T>> convertSchedules(@NonNull Collection<FullSchedule> entries) {
        ArrayList<Schedule<T>> schedules = new ArrayList<Schedule<T>>();
        for (FullSchedule entry : entries) {
            Schedule<T> schedule = this.convert(entry);
            if (schedule == null) continue;
            schedules.add(schedule);
        }
        return schedules;
    }

    @WorkerThread
    private void attemptExecution(final @NonNull FullSchedule entry) {
        if (entry.schedule.executionState != 1) {
            UALog.e((String)"Unable to execute schedule when state is %s scheduleID: %s", (Object[])new Object[]{entry.schedule.executionState, entry.schedule.scheduleId});
            return;
        }
        if (this.isExpired(entry)) {
            this.handleExpiredEntry(entry);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        ScheduleRunnable<Integer> runnable = new ScheduleRunnable<Integer>(entry.schedule.scheduleId, entry.schedule.group){

            @Override
            public void run() {
                Schedule schedule = null;
                this.result = 0;
                if (AutomationEngine.this.pausedManager.isPaused()) {
                    return;
                }
                if (AutomationEngine.this.isScheduleConditionsSatisfied(entry)) {
                    try {
                        schedule = ScheduleConverters.convert(entry);
                        this.result = AutomationEngine.this.driver.onCheckExecutionReadiness(schedule);
                    }
                    catch (Exception e) {
                        UALog.e((Throwable)e, (String)"Unable to create schedule.", (Object[])new Object[0]);
                        this.exception = e;
                    }
                }
                latch.countDown();
                if (1 == (Integer)this.result && schedule != null) {
                    entry.schedule.triggeredTime = new Date().getTime();
                    AutomationEngine.this.driver.onExecuteTriggeredSchedule(schedule, new ScheduleExecutorCallback(entry.schedule.scheduleId));
                }
            }
        };
        this.mainHandler.post((Runnable)runnable);
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            UALog.e((Throwable)ex, (String)"Failed to execute schedule. ", (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
        if (runnable.exception != null) {
            UALog.e((String)"Failed to check conditions. Deleting schedule: %s", (Object[])new Object[]{entry.schedule.scheduleId});
            this.dao.delete(entry);
            this.notifyCancelledSchedule(Collections.singleton(entry));
        } else {
            int result = runnable.result == null ? 0 : (Integer)runnable.result;
            switch (result) {
                case -1: {
                    UALog.v((String)"Schedule invalidated: %s", (Object[])new Object[]{entry.schedule.scheduleId});
                    this.updateExecutionState(entry, 6);
                    this.dao.update(entry);
                    this.prepareSchedules(Collections.singletonList(this.dao.getSchedule(entry.schedule.scheduleId)));
                    break;
                }
                case 1: {
                    UALog.v((String)"Schedule executing: %s", (Object[])new Object[]{entry.schedule.scheduleId});
                    this.updateExecutionState(entry, 2);
                    this.dao.update(entry);
                    break;
                }
                case 0: {
                    UALog.v((String)"Schedule not ready for execution: %s", (Object[])new Object[]{entry.schedule.scheduleId});
                    break;
                }
                case 2: {
                    UALog.v((String)"Schedule execution skipped: %s", (Object[])new Object[]{entry.schedule.scheduleId});
                    this.updateExecutionState(entry, 0);
                    this.dao.update(entry);
                }
            }
        }
    }

    @WorkerThread
    private void notifyExpiredSchedules(@NonNull Collection<FullSchedule> entries) {
        this.notifyHelper(this.convertSchedulesUnknownTypes(entries), new NotifySchedule(){

            @Override
            public void notify(@NonNull ScheduleListener listener, @NonNull Schedule<? extends ScheduleData> schedule) {
                listener.onScheduleExpired(schedule);
            }
        });
    }

    @WorkerThread
    private void notifyCancelledSchedule(@NonNull Collection<FullSchedule> entries) {
        this.notifyHelper(this.convertSchedulesUnknownTypes(entries), new NotifySchedule(){

            @Override
            public void notify(@NonNull ScheduleListener listener, @NonNull Schedule<? extends ScheduleData> schedule) {
                listener.onScheduleCancelled(schedule);
            }
        });
    }

    @WorkerThread
    private void notifyScheduleLimitReached(@NonNull FullSchedule entry) {
        this.notifyHelper(this.convertSchedulesUnknownTypes(Collections.singleton(entry)), new NotifySchedule(){

            @Override
            public void notify(@NonNull ScheduleListener listener, @NonNull Schedule<? extends ScheduleData> schedule) {
                listener.onScheduleLimitReached(schedule);
            }
        });
    }

    @WorkerThread
    private void notifyNewSchedule(@NonNull Collection<Schedule<? extends ScheduleData>> schedules) {
        this.notifyHelper(schedules, new NotifySchedule(){

            public void notify(@NonNull ScheduleListener listener, @NonNull Schedule schedule) {
                listener.onNewSchedule(schedule);
            }
        });
    }

    @WorkerThread
    private void notifyHelper(final @NonNull Collection<Schedule<? extends ScheduleData>> entries, final @NonNull NotifySchedule notify) {
        if (this.scheduleListener == null || entries.isEmpty()) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (Schedule schedule : entries) {
                    ScheduleListener listener = AutomationEngine.this.scheduleListener;
                    if (listener == null) continue;
                    notify.notify(listener, schedule);
                }
            }
        });
    }

    @WorkerThread
    private void onScheduleFinishedExecuting(@Nullable FullSchedule entry) {
        if (entry == null) {
            return;
        }
        UALog.v((String)"Schedule finished: %s", (Object[])new Object[]{entry.schedule.scheduleId});
        ++entry.schedule.count;
        boolean isOverLimit = this.isOverLimit(entry);
        if (this.isExpired(entry)) {
            this.handleExpiredEntry(entry);
            return;
        }
        if (isOverLimit) {
            this.updateExecutionState(entry, 4);
            this.notifyScheduleLimitReached(entry);
            if (entry.schedule.editGracePeriod <= 0L) {
                this.dao.delete(entry);
                return;
            }
        } else if (entry.schedule.interval > 0L) {
            this.updateExecutionState(entry, 3);
            this.scheduleIntervalAlarm(entry, entry.schedule.interval);
        } else {
            this.updateExecutionState(entry, 0);
        }
        this.dao.update(entry);
    }

    private void scheduleDelayAlarm(@NonNull FullSchedule entry, long delay) {
        final ScheduleOperation operation = new ScheduleOperation(entry.schedule.scheduleId, entry.schedule.group){

            protected void onRun() {
                FullSchedule entry = AutomationEngine.this.dao.getSchedule(this.scheduleId);
                if (entry != null && entry.schedule.executionState == 5) {
                    if (AutomationEngine.this.isExpired(entry)) {
                        AutomationEngine.this.handleExpiredEntry(entry);
                        return;
                    }
                    AutomationEngine.this.updateExecutionState(entry, 6);
                    AutomationEngine.this.dao.update(entry);
                    AutomationEngine.this.prepareSchedules(Collections.singletonList(entry));
                }
            }
        };
        operation.addOnRun(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.pendingAlarmOperations.remove((Object)operation);
            }
        });
        this.pendingAlarmOperations.add(operation);
        this.scheduler.schedule(delay, (Runnable)((Object)operation));
    }

    @WorkerThread
    private void scheduleIntervalAlarm(@NonNull FullSchedule entry, long interval) {
        final ScheduleOperation operation = new ScheduleOperation(entry.schedule.scheduleId, entry.schedule.group){

            protected void onRun() {
                FullSchedule entry = AutomationEngine.this.dao.getSchedule(this.scheduleId);
                if (entry == null || entry.schedule.executionState != 3) {
                    return;
                }
                if (AutomationEngine.this.isExpired(entry)) {
                    AutomationEngine.this.handleExpiredEntry(entry);
                    return;
                }
                long pauseStartTime = entry.schedule.executionStateChangeDate;
                AutomationEngine.this.updateExecutionState(entry, 0);
                AutomationEngine.this.dao.update(entry);
                AutomationEngine.this.subscribeStateObservables(entry, pauseStartTime);
            }
        };
        operation.addOnRun(new Runnable(){

            @Override
            public void run() {
                AutomationEngine.this.pendingAlarmOperations.remove((Object)operation);
            }
        });
        this.pendingAlarmOperations.add(operation);
        this.scheduler.schedule(interval, (Runnable)((Object)operation));
    }

    @MainThread
    private boolean isScheduleConditionsSatisfied(@NonNull FullSchedule entry) {
        if (entry.schedule.screens != null && !entry.schedule.screens.isEmpty() && !entry.schedule.screens.contains(this.screen)) {
            return false;
        }
        if (entry.schedule.regionId != null && !entry.schedule.regionId.equals(this.regionId)) {
            return false;
        }
        switch (entry.schedule.appState) {
            case 2: {
                if (this.activityMonitor.isAppForegrounded()) break;
                return false;
            }
            case 3: {
                if (!this.activityMonitor.isAppForegrounded()) break;
                return false;
            }
        }
        return true;
    }

    private void handleExpiredEntry(@NonNull FullSchedule entity) {
        this.handleExpiredEntries(Collections.singleton(entity));
    }

    private void handleExpiredEntries(@NonNull Collection<FullSchedule> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<FullSchedule> schedulesToDelete = new ArrayList<FullSchedule>();
        ArrayList<FullSchedule> schedulesToUpdate = new ArrayList<FullSchedule>();
        for (FullSchedule entry : entries) {
            this.updateExecutionState(entry, 4);
            if (entry.schedule.editGracePeriod > 0L) {
                schedulesToUpdate.add(entry);
                continue;
            }
            schedulesToDelete.add(entry);
        }
        this.dao.updateSchedules(schedulesToUpdate);
        this.dao.deleteSchedules(schedulesToDelete);
        this.notifyExpiredSchedules(entries);
    }

    public void applyEdits(@NonNull FullSchedule entry, @NonNull ScheduleEdits edits) {
        ScheduleEntity scheduleEntity = entry.schedule;
        scheduleEntity.scheduleStart = edits.getStart() == null ? scheduleEntity.scheduleStart : edits.getStart();
        scheduleEntity.scheduleEnd = edits.getEnd() == null ? scheduleEntity.scheduleEnd : edits.getEnd();
        scheduleEntity.limit = edits.getLimit() == null ? scheduleEntity.limit : edits.getLimit();
        scheduleEntity.data = edits.getData() == null ? scheduleEntity.data : edits.getData().toJsonValue();
        scheduleEntity.priority = edits.getPriority() == null ? scheduleEntity.priority : edits.getPriority();
        scheduleEntity.interval = edits.getInterval() == null ? scheduleEntity.interval : edits.getInterval();
        scheduleEntity.editGracePeriod = edits.getEditGracePeriod() == null ? scheduleEntity.editGracePeriod : edits.getEditGracePeriod();
        scheduleEntity.metadata = edits.getMetadata() == null ? scheduleEntity.metadata : edits.getMetadata();
        scheduleEntity.scheduleType = edits.getType() == null ? scheduleEntity.scheduleType : edits.getType();
        scheduleEntity.audience = edits.getAudienceSelector() == null ? scheduleEntity.audience : edits.getAudienceSelector();
        scheduleEntity.campaigns = edits.getCampaigns() == null ? scheduleEntity.campaigns : edits.getCampaigns();
        scheduleEntity.reportingContext = edits.getReportingContext() == null ? scheduleEntity.reportingContext : edits.getReportingContext();
        scheduleEntity.frequencyConstraintIds = edits.getFrequencyConstraintIds() == null ? scheduleEntity.frequencyConstraintIds : edits.getFrequencyConstraintIds();
        scheduleEntity.messageType = edits.getMessageType() == null ? scheduleEntity.messageType : edits.getMessageType();
        scheduleEntity.bypassHoldoutGroups = edits.getBypassHoldoutGroup() == null ? scheduleEntity.bypassHoldoutGroups : edits.getBypassHoldoutGroup();
        scheduleEntity.newUserEvaluationDate = edits.getNewUserEvaluationDate();
        scheduleEntity.productId = edits.getProductId();
    }

    private boolean isExpired(@NonNull FullSchedule entry) {
        return entry.schedule.scheduleEnd >= 0L && entry.schedule.scheduleEnd < System.currentTimeMillis();
    }

    private boolean isOverLimit(@NonNull FullSchedule entry) {
        return entry.schedule.limit > 0 && entry.schedule.count >= entry.schedule.limit;
    }

    private void updateExecutionState(@NonNull FullSchedule schedule, int executionState) {
        if (schedule.schedule.executionState != executionState) {
            schedule.schedule.executionState = executionState;
            schedule.schedule.executionStateChangeDate = System.currentTimeMillis();
        }
    }

    private static class TriggerUpdate {
        final List<TriggerEntity> triggerEntities;
        final JsonSerializable json;
        final double value;

        TriggerUpdate(@NonNull List<TriggerEntity> triggerEntities, @NonNull JsonSerializable json, double value) {
            this.triggerEntities = triggerEntities;
            this.json = json;
            this.value = value;
        }
    }

    private class ScheduleExecutorCallback
    implements AutomationDriver.ExecutionCallback {
        private final String scheduleId;

        ScheduleExecutorCallback(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public void onFinish() {
            AutomationEngine.this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    AutomationEngine.this.onScheduleFinishedExecuting(AutomationEngine.this.dao.getSchedule(ScheduleExecutorCallback.this.scheduleId));
                }
            });
        }
    }

    private static abstract class ScheduleRunnable<T>
    implements Runnable {
        final String scheduleId;
        final String group;
        T result;
        Exception exception;

        ScheduleRunnable(String scheduleId, String group) {
            this.scheduleId = scheduleId;
            this.group = group;
        }
    }

    private class ScheduleOperation
    extends CancelableOperation {
        final String scheduleId;
        final String group;

        ScheduleOperation(String scheduleId, String group) {
            super(AutomationEngine.this.backgroundHandler.getLooper());
            this.scheduleId = scheduleId;
            this.group = group;
        }
    }

    private static interface NotifySchedule {
        public void notify(@NonNull ScheduleListener var1, @NonNull Schedule<? extends ScheduleData> var2);
    }

    public static interface ScheduleListener {
        @MainThread
        public void onScheduleExpired(@NonNull Schedule<? extends ScheduleData> var1);

        @MainThread
        public void onScheduleCancelled(@NonNull Schedule<? extends ScheduleData> var1);

        @MainThread
        public void onScheduleLimitReached(@NonNull Schedule<? extends ScheduleData> var1);

        @MainThread
        public void onNewSchedule(@NonNull Schedule<? extends ScheduleData> var1);
    }

    class PausedManager {
        private final AtomicBoolean isPaused = new AtomicBoolean(false);
        private final List<Consumer<Boolean>> consumers = new CopyOnWriteArrayList<Consumer<Boolean>>();

        PausedManager() {
        }

        public boolean isPaused() {
            return this.isPaused.get();
        }

        public void setPaused(boolean isPaused) {
            if (this.isPaused.compareAndSet(!isPaused, isPaused)) {
                for (Consumer<Boolean> consumer : this.consumers) {
                    consumer.accept((Object)isPaused);
                }
            }
        }

        public void addConsumer(Consumer<Boolean> consumer) {
            this.consumers.add(consumer);
        }

        public void removeConsumer(Consumer<Boolean> consumer) {
            this.consumers.remove(consumer);
        }
    }
}

