/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.urbanairship.AirshipComponent;
import com.urbanairship.AirshipExecutors;
import com.urbanairship.PendingResult;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.PrivacyManager;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.audience.AudienceOverridesProvider;
import com.urbanairship.audience.DeviceInfoProvider;
import com.urbanairship.automation.ActionsScheduleDelegate;
import com.urbanairship.automation.AutomationDriver;
import com.urbanairship.automation.AutomationEngine;
import com.urbanairship.automation.Cancelable;
import com.urbanairship.automation.InAppMessageScheduleDelegate;
import com.urbanairship.automation.InAppRemoteDataObserver;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelegate;
import com.urbanairship.automation.ScheduleEdits;
import com.urbanairship.automation.TriggerContext;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.automation.deferred.AutomationDeferredResult;
import com.urbanairship.automation.deferred.Deferred;
import com.urbanairship.automation.limits.FrequencyChecker;
import com.urbanairship.automation.limits.FrequencyConstraint;
import com.urbanairship.automation.limits.FrequencyLimitManager;
import com.urbanairship.channel.AirshipChannel;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.contacts.Contact;
import com.urbanairship.deferred.DeferredRequest;
import com.urbanairship.deferred.DeferredResolver;
import com.urbanairship.deferred.DeferredResult;
import com.urbanairship.experiment.ExperimentManager;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.experiment.MessageInfo;
import com.urbanairship.iam.InAppAutomationScheduler;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageManager;
import com.urbanairship.json.JsonValue;
import com.urbanairship.locale.LocaleManager;
import com.urbanairship.meteredusage.AirshipMeteredUsage;
import com.urbanairship.meteredusage.MeteredUsageEventEntity;
import com.urbanairship.meteredusage.MeteredUsageType;
import com.urbanairship.remotedata.RemoteData;
import com.urbanairship.remotedata.RemoteDataInfo;
import com.urbanairship.util.Clock;
import com.urbanairship.util.RetryingExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class InAppAutomation
extends AirshipComponent
implements InAppAutomationScheduler {
    private static final String PAUSE_KEY = "com.urbanairship.iam.paused";
    private final InAppRemoteDataObserver remoteDataSubscriber;
    private final AirshipChannel airshipChannel;
    private final Contact contact;
    private final AutomationEngine automationEngine;
    private final InAppMessageManager inAppMessageManager;
    private final RetryingExecutor retryingExecutor;
    private final FrequencyLimitManager frequencyLimitManager;
    private final PrivacyManager privacyManager;
    private final AirshipMeteredUsage meteredUsage;
    private final DeferredResolver deferredResolver;
    private final LocaleManager localeManager;
    private final ActionsScheduleDelegate actionScheduleDelegate;
    private final InAppMessageScheduleDelegate inAppMessageScheduleDelegate;
    private final Map<String, ScheduleDelegate<?>> scheduleDelegateMap = new HashMap();
    private final Map<String, FrequencyChecker> frequencyCheckerMap = new HashMap<String, FrequencyChecker>();
    private final Map<String, RemoteDataInfo> remoteDataInfoMap = new HashMap<String, RemoteDataInfo>();
    private final Map<String, Uri> redirectURLs = new HashMap<String, Uri>();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private Cancelable subscription;
    private final ExperimentManager experimentManager;
    private final DeviceInfoProvider infoProvider;
    private final AirshipRuntimeConfig config;
    private final Clock clock;
    private final Executor backgroundExecutor;
    private final AutomationDriver driver = new AutomationDriver(){

        @Override
        public void onScheduleExecutionInterrupted(Schedule<? extends ScheduleData> schedule) {
            InAppAutomation.this.onScheduleExecutionInterrupted(schedule);
        }

        @Override
        public void onPrepareSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @Nullable TriggerContext triggerContext, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
            InAppAutomation.this.onPrepareSchedule(schedule, triggerContext, callback);
        }

        @Override
        public int onCheckExecutionReadiness(@NonNull Schedule<? extends ScheduleData> schedule) {
            return InAppAutomation.this.onCheckExecutionReadiness(schedule);
        }

        @Override
        public void onExecuteTriggeredSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull AutomationDriver.ExecutionCallback finishCallback) {
            InAppAutomation.this.onExecuteTriggeredSchedule(schedule, finishCallback);
        }
    };
    private final InAppRemoteDataObserver.Delegate remoteDataObserverDelegate = new InAppRemoteDataObserver.Delegate(){

        @Override
        @NonNull
        public PendingResult<Collection<Schedule<? extends ScheduleData>>> getSchedules() {
            return InAppAutomation.this.getSchedules();
        }

        @Override
        @NonNull
        public PendingResult<Boolean> editSchedule(@NonNull String scheduleId, @NonNull ScheduleEdits<? extends ScheduleData> edits) {
            return InAppAutomation.this.editSchedule(scheduleId, edits);
        }

        @Override
        @NonNull
        public PendingResult<Boolean> schedule(@NonNull List<Schedule<? extends ScheduleData>> schedules) {
            return InAppAutomation.this.schedule(schedules);
        }

        @Override
        public Future<Boolean> updateConstraints(@NonNull Collection<FrequencyConstraint> constraints) {
            return InAppAutomation.this.frequencyLimitManager.updateConstraints(constraints);
        }
    };
    private final PrivacyManager.Listener privacyManagerListener = () -> {
        this.checkUpdatesSubscription();
        this.updateEnginePauseState();
    };

    @NonNull
    public static InAppAutomation shared() {
        return (InAppAutomation)UAirship.shared().requireComponent(InAppAutomation.class);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public InAppAutomation(@NonNull Context context, @NonNull PreferenceDataStore preferenceDataStore, @NonNull AirshipRuntimeConfig runtimeConfig, @NonNull PrivacyManager privacyManager, @NonNull Analytics analytics, @NonNull RemoteData remoteData, @NonNull AirshipChannel airshipChannel, @NonNull ExperimentManager experimentManager, @NonNull DeviceInfoProvider infoProvider, @NonNull AirshipMeteredUsage meteredUsage, @NonNull Contact contact, @NonNull DeferredResolver deferredResolver, @NonNull LocaleManager localeManager) {
        super(context, preferenceDataStore);
        this.privacyManager = privacyManager;
        this.automationEngine = new AutomationEngine(context, runtimeConfig, analytics, preferenceDataStore);
        this.airshipChannel = airshipChannel;
        this.remoteDataSubscriber = new InAppRemoteDataObserver(context, preferenceDataStore, remoteData);
        this.inAppMessageManager = new InAppMessageManager(context, preferenceDataStore, analytics, this.automationEngine::checkPendingSchedules);
        this.retryingExecutor = RetryingExecutor.newSerialExecutor((Looper)Looper.getMainLooper());
        this.actionScheduleDelegate = new ActionsScheduleDelegate();
        this.inAppMessageScheduleDelegate = new InAppMessageScheduleDelegate(this.inAppMessageManager);
        this.frequencyLimitManager = new FrequencyLimitManager(context, runtimeConfig);
        this.config = runtimeConfig;
        this.experimentManager = experimentManager;
        this.infoProvider = infoProvider;
        this.meteredUsage = meteredUsage;
        this.clock = Clock.DEFAULT_CLOCK;
        this.backgroundExecutor = AirshipExecutors.newSerialExecutor();
        this.contact = contact;
        this.deferredResolver = deferredResolver;
        this.localeManager = localeManager;
    }

    @VisibleForTesting
    InAppAutomation(@NonNull Context context, @NonNull PreferenceDataStore preferenceDataStore, @NonNull AirshipRuntimeConfig runtimeConfig, @NonNull PrivacyManager privacyManager, @NonNull AutomationEngine engine, @NonNull AirshipChannel airshipChannel, @NonNull InAppRemoteDataObserver observer, @NonNull InAppMessageManager inAppMessageManager, @NonNull RetryingExecutor retryingExecutor, @NonNull ActionsScheduleDelegate actionsScheduleDelegate, @NonNull InAppMessageScheduleDelegate inAppMessageScheduleDelegate, @NonNull FrequencyLimitManager frequencyLimitManager, @NonNull AudienceOverridesProvider audienceOverridesProvider, @NonNull ExperimentManager experimentManager, @NonNull DeviceInfoProvider infoProvider, @NonNull AirshipMeteredUsage meteredUsage, @NonNull Clock clock, @NonNull Executor executor, @NonNull Contact contact, @NonNull DeferredResolver deferredResolver, @NonNull LocaleManager localeManager) {
        super(context, preferenceDataStore);
        this.privacyManager = privacyManager;
        this.automationEngine = engine;
        this.airshipChannel = airshipChannel;
        this.remoteDataSubscriber = observer;
        this.inAppMessageManager = inAppMessageManager;
        this.retryingExecutor = retryingExecutor;
        this.actionScheduleDelegate = actionsScheduleDelegate;
        this.inAppMessageScheduleDelegate = inAppMessageScheduleDelegate;
        this.frequencyLimitManager = frequencyLimitManager;
        this.config = runtimeConfig;
        this.experimentManager = experimentManager;
        this.infoProvider = infoProvider;
        this.meteredUsage = meteredUsage;
        this.clock = clock;
        this.backgroundExecutor = executor;
        this.contact = contact;
        this.deferredResolver = deferredResolver;
        this.localeManager = localeManager;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void init() {
        super.init();
        if (this.config.getConfigOptions().autoPauseInAppAutomationOnLaunch) {
            this.setPaused(true);
        }
        this.automationEngine.setScheduleListener(new AutomationEngine.ScheduleListener(){

            @Override
            public void onScheduleExpired(@NonNull Schedule<? extends ScheduleData> schedule) {
                ScheduleDelegate delegate = InAppAutomation.this.delegateForSchedule(schedule);
                if (delegate != null) {
                    delegate.onScheduleFinished(schedule);
                }
            }

            @Override
            public void onScheduleCancelled(@NonNull Schedule<? extends ScheduleData> schedule) {
                ScheduleDelegate delegate = InAppAutomation.this.delegateForSchedule(schedule);
                if (delegate != null) {
                    delegate.onScheduleFinished(schedule);
                }
            }

            @Override
            public void onScheduleLimitReached(@NonNull Schedule<? extends ScheduleData> schedule) {
                ScheduleDelegate delegate = InAppAutomation.this.delegateForSchedule(schedule);
                if (delegate != null) {
                    delegate.onScheduleFinished(schedule);
                }
            }

            @Override
            public void onNewSchedule(@NonNull Schedule<? extends ScheduleData> schedule) {
                ScheduleDelegate delegate = InAppAutomation.this.delegateForSchedule(schedule);
                if (delegate != null) {
                    delegate.onNewSchedule(schedule);
                }
            }
        });
        this.updateEnginePauseState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getComponentGroup() {
        return 3;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAirshipReady(@NonNull UAirship airship) {
        super.onAirshipReady(airship);
        this.inAppMessageManager.onAirshipReady();
        this.privacyManager.addListener(this.privacyManagerListener);
        this.checkUpdatesSubscription();
    }

    protected void tearDown() {
        super.tearDown();
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
        this.automationEngine.stop();
        this.isStarted.set(false);
        this.privacyManager.removeListener(this.privacyManagerListener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onComponentEnableChange(boolean isEnabled) {
        this.updateEnginePauseState();
    }

    public InAppMessageManager getInAppMessageManager() {
        return this.inAppMessageManager;
    }

    @Override
    @NonNull
    public PendingResult<Boolean> schedule(@NonNull List<Schedule<? extends ScheduleData>> schedules) {
        this.ensureStarted();
        return this.automationEngine.schedule(schedules);
    }

    @Override
    @NonNull
    public PendingResult<Boolean> schedule(@NonNull Schedule<? extends ScheduleData> schedule) {
        this.ensureStarted();
        return this.automationEngine.schedule(schedule);
    }

    @Override
    @NonNull
    public PendingResult<Boolean> cancelSchedule(@NonNull String scheduleId) {
        this.ensureStarted();
        return this.automationEngine.cancel(Collections.singletonList(scheduleId));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PendingResult<Boolean> cancelSchedules(@NonNull String type) {
        this.ensureStarted();
        return this.automationEngine.cancelByType(type);
    }

    @Override
    @NonNull
    public PendingResult<Boolean> cancelScheduleGroup(@NonNull String group) {
        this.ensureStarted();
        return this.automationEngine.cancelGroup(group);
    }

    @Override
    @NonNull
    public PendingResult<Collection<Schedule<Actions>>> getActionScheduleGroup(@NonNull String group) {
        this.ensureStarted();
        return this.automationEngine.getSchedules(group, "actions");
    }

    @Override
    @NonNull
    public PendingResult<Schedule<Actions>> getActionSchedule(@NonNull String scheduleId) {
        this.ensureStarted();
        return this.automationEngine.getSchedule(scheduleId, "actions");
    }

    @Override
    @NonNull
    public PendingResult<Collection<Schedule<Actions>>> getActionSchedules() {
        this.ensureStarted();
        return this.automationEngine.getSchedulesByType("actions");
    }

    @Override
    @NonNull
    public PendingResult<Collection<Schedule<InAppMessage>>> getMessageScheduleGroup(@NonNull String group) {
        this.ensureStarted();
        return this.automationEngine.getSchedules(group, "in_app_message");
    }

    @Override
    @NonNull
    public PendingResult<Schedule<InAppMessage>> getMessageSchedule(@NonNull String scheduleId) {
        this.ensureStarted();
        return this.automationEngine.getSchedule(scheduleId, "in_app_message");
    }

    @Override
    @NonNull
    public PendingResult<Collection<Schedule<InAppMessage>>> getMessageSchedules() {
        this.ensureStarted();
        return this.automationEngine.getSchedulesByType("in_app_message");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public PendingResult<Schedule<Deferred>> getDeferredMessageSchedule(@NonNull String scheduleId) {
        this.ensureStarted();
        return this.automationEngine.getSchedule(scheduleId, "deferred");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public PendingResult<Schedule<? extends ScheduleData>> getSchedule(@NonNull String scheduleId) {
        this.ensureStarted();
        return this.automationEngine.getSchedule(scheduleId);
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PendingResult<Collection<Schedule<? extends ScheduleData>>> getSchedules() {
        this.ensureStarted();
        return this.automationEngine.getSchedules();
    }

    @Override
    @NonNull
    public PendingResult<Boolean> editSchedule(@NonNull String scheduleId, @NonNull ScheduleEdits<? extends ScheduleData> edits) {
        this.ensureStarted();
        return this.automationEngine.editSchedule(scheduleId, edits);
    }

    public void setPaused(boolean paused) {
        boolean storedPausedState = this.getDataStore().getBoolean(PAUSE_KEY, paused);
        if (storedPausedState && !paused) {
            this.automationEngine.checkPendingSchedules();
        }
        this.getDataStore().put(PAUSE_KEY, paused);
    }

    public boolean isPaused() {
        return this.getDataStore().getBoolean(PAUSE_KEY, false);
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.privacyManager.enable(new int[]{1});
        } else {
            this.privacyManager.disable(new int[]{1});
        }
    }

    @Deprecated
    public boolean isEnabled() {
        return this.privacyManager.isEnabled(new int[]{1});
    }

    @WorkerThread
    private void onPrepareSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @Nullable TriggerContext triggerContext, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        UALog.v((String)"onPrepareSchedule schedule: %s, trigger context: %s", (Object[])new Object[]{schedule.getId(), triggerContext});
        AutomationDriver.PrepareScheduleCallback callbackWrapper = result -> {
            if (result != 0) {
                this.frequencyCheckerMap.remove(schedule.getId());
                this.remoteDataInfoMap.remove(schedule.getId());
            }
            callback.onFinish(result);
        };
        RetryingExecutor.Operation checkValid = () -> {
            if (this.remoteDataSubscriber.requiresRefresh(schedule)) {
                this.remoteDataSubscriber.waitFullRefresh(schedule, () -> callbackWrapper.onFinish(4));
                return RetryingExecutor.cancelResult();
            }
            if (!this.remoteDataSubscriber.bestEffortRefresh(schedule)) {
                callbackWrapper.onFinish(4);
                return RetryingExecutor.cancelResult();
            }
            RemoteDataInfo info = this.remoteDataSubscriber.parseRemoteDataInfo(schedule);
            if (info != null) {
                this.remoteDataInfoMap.put(schedule.getId(), info);
            }
            return RetryingExecutor.finishedResult();
        };
        RetryingExecutor.Operation frequencyChecks = () -> {
            if (!schedule.getFrequencyConstraintIds().isEmpty()) {
                FrequencyChecker frequencyChecker = this.getFrequencyChecker(schedule);
                if (frequencyChecker == null) {
                    this.remoteDataSubscriber.notifyOutdated(schedule);
                    callbackWrapper.onFinish(4);
                    return RetryingExecutor.cancelResult();
                }
                this.frequencyCheckerMap.put(schedule.getId(), frequencyChecker);
                if (frequencyChecker.isOverLimit()) {
                    callbackWrapper.onFinish(3);
                    return RetryingExecutor.cancelResult();
                }
            }
            return RetryingExecutor.finishedResult();
        };
        RetryingExecutor.Operation audienceChecks = () -> {
            if (schedule.getAudienceSelector() == null) {
                return RetryingExecutor.finishedResult();
            }
            RemoteDataInfo info = this.remoteDataSubscriber.parseRemoteDataInfo(schedule);
            String contactId = info == null ? null : info.getContactId();
            PendingResult result = schedule.getAudienceSelector().evaluateAsPendingResult(this.getContext(), schedule.getNewUserEvaluationDate(), this.infoProvider, contactId);
            try {
                if (Boolean.TRUE.equals(result.get())) {
                    return RetryingExecutor.finishedResult();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            callbackWrapper.onFinish(this.getPrepareResultMissedAudience(schedule));
            return RetryingExecutor.cancelResult();
        };
        PendingResult experimentResults = new PendingResult();
        RetryingExecutor.Operation evaluateExperiments = () -> {
            try {
                Objects.requireNonNull(this.infoProvider.getChannelId(), "Channel ID must be available to evaluate experiments.");
                ExperimentResult result = this.evaluateExperiments(schedule);
                experimentResults.setResult((Object)result);
                return RetryingExecutor.finishedResult();
            }
            catch (Exception ex) {
                UALog.e((Throwable)ex, (String)("Error on evaluating experiments for schedule " + schedule.getId()), (Object[])new Object[0]);
                return RetryingExecutor.retryResult();
            }
        };
        RetryingExecutor.Operation prepareSchedule = () -> {
            switch (schedule.getType()) {
                case "deferred": {
                    return this.resolveDeferred(schedule, triggerContext, (ExperimentResult)experimentResults.getResult(), callbackWrapper);
                }
                case "actions": {
                    this.prepareSchedule(schedule, (Actions)schedule.coerceType(), (ExperimentResult)experimentResults.getResult(), this.actionScheduleDelegate, callbackWrapper);
                    break;
                }
                case "in_app_message": {
                    this.prepareSchedule(schedule, (InAppMessage)schedule.coerceType(), (ExperimentResult)experimentResults.getResult(), this.inAppMessageScheduleDelegate, callbackWrapper);
                }
            }
            return RetryingExecutor.finishedResult();
        };
        RetryingExecutor.Operation[] operations = new RetryingExecutor.Operation[]{checkValid, frequencyChecks, audienceChecks, evaluateExperiments, prepareSchedule};
        this.retryingExecutor.execute(operations);
    }

    @Nullable
    private ExperimentResult evaluateExperiments(@NonNull Schedule<? extends ScheduleData> schedule) throws ExecutionException, InterruptedException {
        RemoteDataInfo remoteDataInfo = this.remoteDataSubscriber.parseRemoteDataInfo(schedule);
        if (schedule.getType().equals("actions")) {
            return null;
        }
        if (schedule.isBypassHoldoutGroups()) {
            return null;
        }
        MessageInfo messageInfo = new MessageInfo(schedule.getMessageType(), schedule.getCampaigns());
        return (ExperimentResult)this.experimentManager.evaluateGlobalHoldoutsPendingResult(messageInfo, remoteDataInfo == null ? null : remoteDataInfo.getContactId()).get();
    }

    private <T extends ScheduleData> void prepareSchedule(Schedule<? extends ScheduleData> schedule, T scheduleData, ExperimentResult experimentResult, ScheduleDelegate<T> delegate, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        delegate.onPrepareSchedule(schedule, scheduleData, experimentResult, result -> {
            if (result == 0) {
                this.scheduleDelegateMap.put(schedule.getId(), delegate);
            }
            callback.onFinish(result);
        });
    }

    private RetryingExecutor.Result resolveDeferred(@NonNull Schedule<? extends ScheduleData> schedule, @Nullable TriggerContext triggerContext, @Nullable ExperimentResult experimentResult, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        DeferredResult result;
        String channelId = this.airshipChannel.getId();
        if (channelId == null) {
            return RetryingExecutor.retryResult();
        }
        Deferred scheduleData = (Deferred)schedule.coerceType();
        try {
            DeferredRequest request = this.makeDeferredRequest(scheduleData, channelId, triggerContext);
            result = (DeferredResult)this.deferredResolver.resolveAsPendingResult(request, AutomationDeferredResult::parse).get();
        }
        catch (Exception ex) {
            UALog.e((Throwable)ex, (String)"Failed to resolve deferred", (Object[])new Object[0]);
            if (scheduleData.getRetryOnTimeout()) {
                return RetryingExecutor.retryResult();
            }
            callback.onFinish(2);
            return RetryingExecutor.cancelResult();
        }
        if (result instanceof DeferredResult.Success) {
            DeferredResult.Success success = (DeferredResult.Success)result;
            AutomationDeferredResult response = (AutomationDeferredResult)success.getResult();
            if (!response.isAudienceMatched()) {
                callback.onFinish(this.getPrepareResultMissedAudience(schedule));
                return RetryingExecutor.cancelResult();
            }
            if (response.getInAppMessage() == null) {
                callback.onFinish(2);
            }
            this.prepareSchedule(schedule, response.getInAppMessage(), experimentResult, this.inAppMessageScheduleDelegate, callback);
            return RetryingExecutor.finishedResult();
        }
        if (result instanceof DeferredResult.TimedOut) {
            if (scheduleData.getRetryOnTimeout()) {
                return RetryingExecutor.retryResult();
            }
            callback.onFinish(2);
            return RetryingExecutor.cancelResult();
        }
        if (result instanceof DeferredResult.OutOfDate) {
            this.remoteDataSubscriber.notifyOutdated(schedule);
            callback.onFinish(4);
            return RetryingExecutor.cancelResult();
        }
        if (result instanceof DeferredResult.RetriableError) {
            DeferredResult.RetriableError retry = (DeferredResult.RetriableError)result;
            long backOff = retry.getRetryAfter() == null ? -1L : retry.getRetryAfter();
            return RetryingExecutor.retryResult((long)backOff);
        }
        this.remoteDataSubscriber.notifyOutdated(schedule);
        callback.onFinish(4);
        return RetryingExecutor.cancelResult();
    }

    private DeferredRequest makeDeferredRequest(@NonNull Deferred schedule, @NonNull String channelId, @Nullable TriggerContext triggerContext) throws ExecutionException, InterruptedException {
        String triggerType = null;
        JsonValue triggerEvent = null;
        Double triggerGoal = 0.0;
        if (triggerContext != null) {
            triggerType = triggerContext.getTrigger().getTriggerName();
            triggerEvent = triggerContext.getEvent();
            triggerGoal = triggerContext.getTrigger().getGoal();
        }
        return (DeferredRequest)DeferredRequest.automation((Uri)schedule.getUrl(), (String)channelId, (DeviceInfoProvider)this.infoProvider, (String)triggerType, (JsonValue)triggerEvent, (double)triggerGoal, (LocaleManager)this.localeManager).get();
    }

    @MainThread
    private int onCheckExecutionReadiness(@NonNull Schedule<? extends ScheduleData> schedule) {
        UALog.v((String)"onCheckExecutionReadiness schedule: %s", (Object[])new Object[]{schedule.getId()});
        if (this.isPaused()) {
            return 0;
        }
        RemoteDataInfo info = this.remoteDataSubscriber.parseRemoteDataInfo(schedule);
        if (info != null && !info.equals((Object)this.remoteDataInfoMap.get(schedule.getId())) || !this.remoteDataSubscriber.isScheduleValid(schedule)) {
            ScheduleDelegate<?> delegate = this.scheduleDelegateMap.remove(schedule.getId());
            if (delegate != null) {
                delegate.onExecutionInvalidated(schedule);
            }
            return -1;
        }
        ScheduleDelegate<?> delegate = this.scheduleDelegateMap.get(schedule.getId());
        if (delegate == null) {
            return 0;
        }
        int result = delegate.onCheckExecutionReadiness(schedule);
        if (result != 1) {
            return result;
        }
        FrequencyChecker frequencyChecker = this.frequencyCheckerMap.get(schedule.getId());
        if (frequencyChecker != null && !frequencyChecker.checkAndIncrement()) {
            delegate.onExecutionInvalidated(schedule);
            return 2;
        }
        return 1;
    }

    @MainThread
    private void onExecuteTriggeredSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull AutomationDriver.ExecutionCallback callback) {
        UALog.v((String)"onExecuteTriggeredSchedule schedule: %s", (Object[])new Object[]{schedule.getId()});
        this.frequencyCheckerMap.remove(schedule.getId());
        this.remoteDataInfoMap.remove(schedule.getId());
        ScheduleDelegate<?> delegate = this.scheduleDelegateMap.remove(schedule.getId());
        if (delegate != null) {
            delegate.onExecute(schedule, callback);
            this.reportMeteredUsage(schedule);
        } else {
            UALog.e((String)"Unexpected schedule type: %s", (Object[])new Object[]{schedule.getType()});
            callback.onFinish();
        }
    }

    private void reportMeteredUsage(Schedule<? extends ScheduleData> schedule) {
        if (TextUtils.isEmpty((CharSequence)schedule.getProductId())) {
            return;
        }
        RemoteDataInfo info = this.remoteDataSubscriber.parseRemoteDataInfo(schedule);
        String contactId = info == null ? null : info.getContactId();
        contactId = contactId == null ? this.contact.getLastContactId() : contactId;
        MeteredUsageEventEntity event = new MeteredUsageEventEntity(UUID.randomUUID().toString(), schedule.getId(), MeteredUsageType.IN_APP_EXPERIENCE_IMPRESSION, schedule.getProductId(), schedule.getReportingContext(), Long.valueOf(this.clock.currentTimeMillis()), contactId);
        this.backgroundExecutor.execute(() -> this.meteredUsage.addEvent(event));
    }

    private void onScheduleExecutionInterrupted(Schedule<? extends ScheduleData> schedule) {
        UALog.v((String)"onScheduleExecutionInterrupted schedule: %s", (Object[])new Object[]{schedule.getId()});
        ScheduleDelegate<? extends ScheduleData> delegate = this.delegateForSchedule(schedule);
        if (delegate != null) {
            delegate.onExecutionInterrupted(schedule);
        }
    }

    private void updateEnginePauseState() {
        boolean isEnabled = this.privacyManager.isEnabled(new int[]{1}) && this.isComponentEnabled();
        this.automationEngine.setPaused(!isEnabled);
    }

    @Nullable
    private FrequencyChecker getFrequencyChecker(@NonNull Schedule<? extends ScheduleData> schedule) {
        try {
            return this.frequencyLimitManager.getFrequencyChecker(schedule.getFrequencyConstraintIds()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            UALog.e((String)("InAppAutomation - Failed to get Frequency Limit Checker : " + e), (Object[])new Object[0]);
            return null;
        }
    }

    private int getPrepareResultMissedAudience(@NonNull Schedule<? extends ScheduleData> schedule) {
        int result = 2;
        if (schedule.getAudienceSelector() == null) {
            return result;
        }
        switch (schedule.getAudienceSelector().getMissBehavior()) {
            case CANCEL: {
                result = 1;
                break;
            }
            case SKIP: {
                result = 3;
                break;
            }
            case PENALIZE: {
                result = 2;
            }
        }
        return result;
    }

    @Nullable
    private ScheduleDelegate<? extends ScheduleData> delegateForSchedule(Schedule<? extends ScheduleData> schedule) {
        ScheduleDelegate<Actions> delegate = null;
        switch (schedule.getType()) {
            case "actions": {
                delegate = this.actionScheduleDelegate;
                break;
            }
            case "deferred": {
                Deferred deferred = (Deferred)schedule.coerceType();
                if (!"in_app_message".equals(deferred.getType())) break;
                delegate = this.inAppMessageScheduleDelegate;
                break;
            }
            case "in_app_message": {
                delegate = this.inAppMessageScheduleDelegate;
            }
        }
        return delegate;
    }

    private void ensureStarted() {
        if (!this.isStarted.getAndSet(true)) {
            UALog.v((String)"Starting In-App automation", (Object[])new Object[0]);
            this.automationEngine.start(this.driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdatesSubscription() {
        InAppRemoteDataObserver.Delegate delegate = this.remoteDataObserverDelegate;
        synchronized (delegate) {
            if (this.privacyManager.isEnabled(new int[]{1})) {
                this.ensureStarted();
                if (this.subscription == null) {
                    this.subscription = this.remoteDataSubscriber.subscribe(this.remoteDataObserverDelegate);
                }
            } else if (this.subscription != null) {
                this.subscription.cancel();
                this.subscription = null;
            }
        }
    }
}

