/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.automation.AutomationDriver;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelegate;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class InAppMessageScheduleDelegate
implements ScheduleDelegate<InAppMessage> {
    private InAppMessageManager messageManager;

    public InAppMessageScheduleDelegate(InAppMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    @Override
    public void onNewSchedule(@NonNull Schedule<? extends ScheduleData> schedule) {
        if ("in_app_message".equals(schedule.getType())) {
            this.messageManager.onNewMessageSchedule(schedule.getId(), (InAppMessage)schedule.coerceType());
        }
    }

    @Override
    public void onScheduleFinished(@NonNull Schedule<? extends ScheduleData> schedule) {
        this.messageManager.onMessageScheduleFinished(schedule.getId());
    }

    @Override
    public void onPrepareSchedule(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull InAppMessage message, @Nullable ExperimentResult experimentResult, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        this.messageManager.onPrepare(schedule.getId(), schedule.getCampaigns(), schedule.getReportingContext(), message, experimentResult, callback);
    }

    @Override
    public void onExecutionInvalidated(@NonNull Schedule<? extends ScheduleData> schedule) {
        this.messageManager.onExecutionInvalidated(schedule.getId());
    }

    @Override
    public void onExecutionInterrupted(@NonNull Schedule<? extends ScheduleData> schedule) {
        InAppMessage message = "in_app_message".equals(schedule.getType()) ? (InAppMessage)schedule.coerceType() : null;
        this.messageManager.onExecutionInterrupted(schedule.getId(), schedule.getCampaigns(), schedule.getReportingContext(), message);
    }

    @Override
    public void onExecute(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull AutomationDriver.ExecutionCallback callback) {
        this.messageManager.onExecute(schedule.getId(), callback);
    }

    @Override
    public int onCheckExecutionReadiness(@NonNull Schedule<? extends ScheduleData> schedule) {
        return this.messageManager.onCheckExecutionReadiness(schedule.getId());
    }
}

