/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Consumer;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.PendingResult;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.Cancelable;
import com.urbanairship.automation.RemoteDataAccess;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelay;
import com.urbanairship.automation.ScheduleEdits;
import com.urbanairship.automation.Trigger;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.automation.deferred.Deferred;
import com.urbanairship.automation.limits.FrequencyConstraint;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.remotedata.RemoteData;
import com.urbanairship.remotedata.RemoteDataInfo;
import com.urbanairship.remotedata.RemoteDataPayload;
import com.urbanairship.remotedata.RemoteDataSource;
import com.urbanairship.util.DateUtils;
import com.urbanairship.util.UAStringUtil;
import com.urbanairship.util.VersionUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class InAppRemoteDataObserver {
    private static final String MESSAGES_JSON_KEY = "in_app_messages";
    private static final String CONSTRAINTS_JSON_KEY = "frequency_constraints";
    private static final String CONSTRAINTS_PERIOD_KEY = "period";
    private static final String CONSTRAINT_ID_KEY = "id";
    private static final String CONSTRAINT_RANGE_KEY = "range";
    private static final String CONSTRAINT_BOUNDARY_KEY = "boundary";
    private static final String CREATED_JSON_KEY = "created";
    private static final String UPDATED_JSON_KEY = "last_updated";
    private static final String LIMIT_KEY = "limit";
    private static final String PRIORITY_KEY = "priority";
    private static final String GROUP_KEY = "group";
    private static final String END_KEY = "end";
    private static final String START_KEY = "start";
    private static final String DELAY_KEY = "delay";
    private static final String TRIGGERS_KEY = "triggers";
    private static final String EDIT_GRACE_PERIOD_KEY = "edit_grace_period";
    private static final String INTERVAL_KEY = "interval";
    private static final String AUDIENCE_KEY = "audience";
    private static final String TYPE_KEY = "type";
    private static final String SCHEDULE_ID_KEY = "id";
    private static final String LEGACY_MESSAGE_ID_KEY = "message_id";
    private static final String MESSAGE_KEY = "message";
    private static final String DEFERRED_KEY = "deferred";
    private static final String ACTIONS_KEY = "actions";
    private static final String CAMPAIGNS_KEY = "campaigns";
    private static final String REPORTING_CONTEXT_KEY = "reporting_context";
    private static final String FREQUENCY_CONSTRAINT_IDS_KEY = "frequency_constraint_ids";
    private static final String MESSAGE_TYPE_KEY = "message_type";
    private static final String BYPASS_HOLDOUT_GROUP_KEY = "bypass_holdout_groups";
    private static final String PRODUCT_ID_KEY = "product_id";
    private static final String APP_LAST_PAYLOAD_TIMESTAMP_KEY = "com.urbanairship.iam.data.LAST_PAYLOAD_TIMESTAMP";
    private static final String APP_LAST_PAYLOAD_INFO = "com.urbanairship.iam.data.last_payload_info";
    private static final String APP_LAST_SDK_VERSION_KEY = "com.urbanairship.iaa.last_sdk_version";
    private static final String CONTACT_LAST_PAYLOAD_TIMESTAMP_KEY = "com.urbanairship.iam.data.contact_last_payload_timestamp";
    private static final String CONTACT_LAST_PAYLOAD_INFO = "com.urbanairship.iam.data.contact_last_payload_info";
    private static final String CONTACT_LAST_SDK_VERSION_KEY = "com.urbanairship.iaa.contact_last_sdk_version";
    private static final String LAST_PAYLOAD_METADATA = "com.urbanairship.iam.data.LAST_PAYLOAD_METADATA";
    static final String REMOTE_DATA_METADATA = "com.urbanairship.iaa.REMOTE_DATA_METADATA";
    static final String REMOTE_DATA_INFO = "com.urbanairship.iaa.REMOTE_DATA_INFO";
    private static final String MIN_SDK_VERSION_KEY = "min_sdk_version";
    private final PreferenceDataStore preferenceDataStore;
    private final RemoteDataAccess remoteData;
    private final String sdkVersion;

    InAppRemoteDataObserver(@NonNull Context context, @NonNull PreferenceDataStore preferenceDataStore, @NonNull RemoteData remoteData) {
        this.preferenceDataStore = preferenceDataStore;
        this.remoteData = new RemoteDataAccess(context, remoteData);
        this.sdkVersion = UAirship.getVersion();
    }

    @VisibleForTesting
    InAppRemoteDataObserver(@NonNull PreferenceDataStore preferenceDataStore, @NonNull RemoteDataAccess remoteDataAccess, @NonNull String sdkVersion) {
        this.preferenceDataStore = preferenceDataStore;
        this.remoteData = remoteDataAccess;
        this.sdkVersion = sdkVersion;
    }

    Cancelable subscribe(@NonNull Delegate delegate) {
        return this.remoteData.subscribe((Consumer<List<RemoteDataPayload>>)((Consumer)payloads -> {
            try {
                this.processPayloads((List<RemoteDataPayload>)payloads, delegate);
                UALog.d((String)"Finished processing messages.", (Object[])new Object[0]);
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"InAppRemoteDataObserver - Failed to process payload: ", (Object[])new Object[0]);
            }
        }));
    }

    @Nullable
    private RemoteDataPayload findPayload(@NonNull List<RemoteDataPayload> payloads, RemoteDataSource source) {
        for (RemoteDataPayload payload : payloads) {
            if (!(payload.getRemoteDataInfo() == null ? source == RemoteDataSource.APP : payload.getRemoteDataInfo().getSource() == source)) continue;
            return payload;
        }
        return null;
    }

    private void processPayloads(@NonNull List<RemoteDataPayload> payloads, @NonNull Delegate delegate) throws ExecutionException, InterruptedException {
        if (this.preferenceDataStore.isSet(LAST_PAYLOAD_METADATA)) {
            this.preferenceDataStore.remove(LAST_PAYLOAD_METADATA);
            this.preferenceDataStore.remove(APP_LAST_PAYLOAD_INFO);
            this.preferenceDataStore.remove(CONTACT_LAST_PAYLOAD_INFO);
        }
        if (payloads.isEmpty()) {
            return;
        }
        this.processAppPayload(this.findPayload(payloads, RemoteDataSource.APP), delegate);
        this.processContactPayload(this.findPayload(payloads, RemoteDataSource.CONTACT), delegate);
    }

    private void processAppPayload(@Nullable RemoteDataPayload payload, @NonNull Delegate delegate) throws ExecutionException, InterruptedException {
        String lastSdkVersion;
        if (payload == null) {
            this.stopAll(RemoteDataSource.APP, delegate);
            this.preferenceDataStore.remove(APP_LAST_PAYLOAD_INFO);
            return;
        }
        long lastUpdate = this.preferenceDataStore.getLong(APP_LAST_PAYLOAD_TIMESTAMP_KEY, -1L);
        RemoteDataInfo lastPayloadRemoteInfo = this.getLastPayloadRemoteInfo(APP_LAST_PAYLOAD_INFO);
        boolean processed = this.processPayload(payload, delegate, lastPayloadRemoteInfo, lastUpdate, lastSdkVersion = this.preferenceDataStore.getString(APP_LAST_SDK_VERSION_KEY, null), RemoteDataSource.APP);
        if (processed) {
            this.preferenceDataStore.put(APP_LAST_PAYLOAD_TIMESTAMP_KEY, payload.getTimestamp());
            this.preferenceDataStore.put(APP_LAST_PAYLOAD_INFO, (JsonSerializable)payload.getRemoteDataInfo());
            this.preferenceDataStore.put(APP_LAST_SDK_VERSION_KEY, this.sdkVersion);
        }
    }

    private void processContactPayload(@Nullable RemoteDataPayload payload, @NonNull Delegate delegate) throws ExecutionException, InterruptedException {
        if (payload == null) {
            this.stopAll(RemoteDataSource.CONTACT, delegate);
            this.preferenceDataStore.remove(CONTACT_LAST_PAYLOAD_INFO);
            return;
        }
        String contactId = "";
        if (payload.getRemoteDataInfo() != null && payload.getRemoteDataInfo().getContactId() != null) {
            contactId = payload.getRemoteDataInfo().getContactId();
        }
        long lastUpdate = this.preferenceDataStore.getLong(CONTACT_LAST_PAYLOAD_TIMESTAMP_KEY + contactId, -1L);
        String lastSdkVersion = this.preferenceDataStore.getString(CONTACT_LAST_SDK_VERSION_KEY + contactId, null);
        RemoteDataInfo lastPayloadRemoteInfo = this.getLastPayloadRemoteInfo(CONTACT_LAST_PAYLOAD_INFO);
        boolean processed = this.processPayload(payload, delegate, lastPayloadRemoteInfo, lastUpdate, lastSdkVersion, RemoteDataSource.CONTACT);
        if (processed) {
            this.preferenceDataStore.put(CONTACT_LAST_PAYLOAD_TIMESTAMP_KEY + contactId, payload.getTimestamp());
            this.preferenceDataStore.put(CONTACT_LAST_SDK_VERSION_KEY + contactId, this.sdkVersion);
            this.preferenceDataStore.put(CONTACT_LAST_PAYLOAD_INFO, (JsonSerializable)payload.getRemoteDataInfo());
        }
    }

    private Boolean processPayload(@NonNull RemoteDataPayload payload, @NonNull Delegate delegate, @Nullable RemoteDataInfo lastPayloadRemoteInfo, long lastUpdate, @Nullable String lastSdkVersion, @NonNull RemoteDataSource source) throws ExecutionException, InterruptedException {
        Object constraints;
        boolean isMetadataUpToDate = ObjectsCompat.equals((Object)payload.getRemoteDataInfo(), (Object)lastPayloadRemoteInfo);
        if (lastUpdate == payload.getTimestamp() && isMetadataUpToDate) {
            return false;
        }
        JsonMap scheduleMetadata = JsonMap.newBuilder().put(REMOTE_DATA_INFO, (JsonSerializable)payload.getRemoteDataInfo()).putOpt(REMOTE_DATA_METADATA, (Object)JsonMap.EMPTY_MAP).build();
        ArrayList<Schedule<? extends ScheduleData>> newSchedules = new ArrayList<Schedule<? extends ScheduleData>>();
        ArrayList<String> incomingScheduleIds = new ArrayList<String>();
        Set<String> scheduledRemoteIds = this.filterRemoteSchedules((Collection)delegate.getSchedules().get(), source);
        if (source == RemoteDataSource.APP && !delegate.updateConstraints((Collection<FrequencyConstraint>)(constraints = this.parseConstraints(payload.getData().opt(CONSTRAINTS_JSON_KEY).optList()))).get().booleanValue()) {
            return false;
        }
        for (JsonValue messageJson : payload.getData().opt(MESSAGES_JSON_KEY).optList()) {
            long lastUpdatedTimeStamp;
            long createdTimeStamp;
            try {
                createdTimeStamp = DateUtils.parseIso8601((String)messageJson.optMap().opt(CREATED_JSON_KEY).getString());
                lastUpdatedTimeStamp = DateUtils.parseIso8601((String)messageJson.optMap().opt(UPDATED_JSON_KEY).getString());
            }
            catch (ParseException e) {
                UALog.e((Throwable)e, (String)"Failed to parse in-app message timestamps: %s", (Object[])new Object[]{messageJson});
                continue;
            }
            String scheduleId = InAppRemoteDataObserver.parseScheduleId(messageJson);
            if (UAStringUtil.isEmpty((String)scheduleId)) {
                UALog.e((String)"Missing schedule ID: %s", (Object[])new Object[]{messageJson});
                continue;
            }
            incomingScheduleIds.add(scheduleId);
            if (isMetadataUpToDate && lastUpdatedTimeStamp <= lastUpdate) continue;
            if (scheduledRemoteIds.contains(scheduleId)) {
                try {
                    ScheduleEdits<? extends ScheduleData> edits = InAppRemoteDataObserver.parseEdits(messageJson, scheduleMetadata, createdTimeStamp);
                    Boolean edited = (Boolean)delegate.editSchedule(scheduleId, edits).get();
                    if (edited == null || !edited.booleanValue()) continue;
                    UALog.d((String)"Updated in-app automation: %s with edits: %s", (Object[])new Object[]{scheduleId, edits});
                }
                catch (JsonException e) {
                    UALog.e((Throwable)e, (String)"Failed to parse in-app automation edits: %s", (Object[])new Object[]{scheduleId});
                }
                continue;
            }
            String minSdkVersion = messageJson.optMap().opt(MIN_SDK_VERSION_KEY).optString();
            if (!this.isNewSchedule(minSdkVersion, lastSdkVersion, createdTimeStamp, lastUpdate)) continue;
            try {
                Schedule<? extends ScheduleData> schedule = InAppRemoteDataObserver.parseSchedule(scheduleId, messageJson, scheduleMetadata, createdTimeStamp);
                newSchedules.add(schedule);
                UALog.d((String)"New in-app automation: %s", (Object[])new Object[]{schedule});
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"Failed to parse in-app automation: %s", (Object[])new Object[]{messageJson});
            }
        }
        if (!newSchedules.isEmpty()) {
            delegate.schedule(newSchedules).get();
        }
        HashSet<String> schedulesToRemove = new HashSet<String>(scheduledRemoteIds);
        schedulesToRemove.removeAll(incomingScheduleIds);
        if (!schedulesToRemove.isEmpty()) {
            ScheduleEdits<?> edits = ScheduleEdits.newBuilder().setMetadata(scheduleMetadata).setStart(payload.getTimestamp()).setEnd(payload.getTimestamp()).build();
            for (String scheduleId : schedulesToRemove) {
                delegate.editSchedule(scheduleId, edits).get();
            }
        }
        return true;
    }

    private void stopAll(RemoteDataSource source, @NonNull Delegate delegate) throws ExecutionException, InterruptedException {
        Set<String> scheduledRemoteIds = this.filterRemoteSchedules((Collection)delegate.getSchedules().get(), source);
        if (scheduledRemoteIds.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        ScheduleEdits<?> edits = ScheduleEdits.newBuilder().setStart(time).setEnd(time).build();
        for (String scheduleId : scheduledRemoteIds) {
            delegate.editSchedule(scheduleId, edits).get();
        }
    }

    @NonNull
    private Collection<FrequencyConstraint> parseConstraints(@NonNull JsonList constraintsJson) {
        ArrayList<FrequencyConstraint> constraints = new ArrayList<FrequencyConstraint>();
        for (JsonValue value : constraintsJson) {
            try {
                constraints.add(this.parseConstraint(value.optMap()));
            }
            catch (JsonException e) {
                UALog.e((Throwable)e, (String)("Invalid constraint: " + value), (Object[])new Object[0]);
            }
        }
        return constraints;
    }

    @NonNull
    private FrequencyConstraint parseConstraint(@NonNull JsonMap constraintJson) throws JsonException {
        String period;
        FrequencyConstraint.Builder builder = FrequencyConstraint.newBuilder().setId(constraintJson.opt("id").getString()).setCount(constraintJson.opt(CONSTRAINT_BOUNDARY_KEY).getInt(0));
        long range = constraintJson.opt(CONSTRAINT_RANGE_KEY).getLong(0L);
        switch (period = constraintJson.opt(CONSTRAINTS_PERIOD_KEY).optString()) {
            case "seconds": {
                builder.setRange(TimeUnit.SECONDS, range);
                break;
            }
            case "minutes": {
                builder.setRange(TimeUnit.MINUTES, range);
                break;
            }
            case "hours": {
                builder.setRange(TimeUnit.HOURS, range);
                break;
            }
            case "days": {
                builder.setRange(TimeUnit.DAYS, range);
                break;
            }
            case "weeks": {
                builder.setRange(TimeUnit.DAYS, range * 7L);
                break;
            }
            case "months": {
                builder.setRange(TimeUnit.DAYS, range * 30L);
                break;
            }
            case "years": {
                builder.setRange(TimeUnit.DAYS, range * 365L);
                break;
            }
            default: {
                throw new JsonException("Invalid period: " + period);
            }
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid constraint: " + constraintJson, (Throwable)e);
        }
    }

    @Nullable
    private static String parseScheduleId(JsonValue json) {
        String scheduleId = json.optMap().opt("id").getString();
        if (scheduleId == null) {
            scheduleId = json.optMap().opt(MESSAGE_KEY).optMap().opt(LEGACY_MESSAGE_ID_KEY).getString();
        }
        return scheduleId;
    }

    @Nullable
    private static AudienceSelector parseAudience(@NonNull JsonValue jsonValue) throws JsonException {
        JsonValue audienceJson = jsonValue.optMap().get(AUDIENCE_KEY);
        if (audienceJson == null) {
            audienceJson = jsonValue.optMap().opt(MESSAGE_KEY).optMap().get(AUDIENCE_KEY);
        }
        return audienceJson == null ? null : AudienceSelector.Companion.fromJson(audienceJson);
    }

    private boolean isNewSchedule(@Nullable String minSdkVersion, @Nullable String lastSdkVersion, long createdTimeStamp, long lastUpdateTimeStamp) {
        if (createdTimeStamp > lastUpdateTimeStamp) {
            return true;
        }
        if (UAStringUtil.isEmpty((String)minSdkVersion)) {
            return false;
        }
        if (UAStringUtil.isEmpty((String)lastSdkVersion)) {
            return VersionUtils.isVersionNewerOrEqualTo((String)"16.2.0", (String)minSdkVersion);
        }
        return VersionUtils.isVersionNewer((String)lastSdkVersion, (String)minSdkVersion);
    }

    @NonNull
    private Set<String> filterRemoteSchedules(@Nullable Collection<Schedule<? extends ScheduleData>> schedules, RemoteDataSource source) {
        if (schedules == null) {
            return Collections.emptySet();
        }
        HashSet<String> scheduleIds = new HashSet<String>();
        for (Schedule<? extends ScheduleData> schedule : schedules) {
            if (!this.isRemoteSchedule(schedule)) continue;
            RemoteDataInfo info = this.parseRemoteDataInfo(schedule);
            if (info == null && source == RemoteDataSource.APP) {
                scheduleIds.add(schedule.getId());
                continue;
            }
            if (info == null || source != info.getSource()) continue;
            scheduleIds.add(schedule.getId());
        }
        return scheduleIds;
    }

    @Nullable
    private RemoteDataInfo getLastPayloadRemoteInfo(@NonNull String key) {
        JsonValue jsonValue = this.preferenceDataStore.getJsonValue(key);
        if (jsonValue.isNull()) {
            return null;
        }
        try {
            return new RemoteDataInfo(jsonValue);
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)"Failed to parse remote info.", (Object[])new Object[0]);
            return null;
        }
    }

    public static Schedule<? extends ScheduleData> parseSchedule(@NonNull String scheduleId, @NonNull JsonValue value, @NonNull JsonMap metadata, long createdDate) throws JsonException {
        Schedule.Builder<ScheduleData> builder;
        JsonMap jsonMap = value.optMap();
        String type = jsonMap.opt(TYPE_KEY).getString("in_app_message");
        switch (type) {
            case "actions": {
                JsonMap actionsMap = jsonMap.opt(ACTIONS_KEY).getMap();
                if (actionsMap == null) {
                    throw new JsonException("Missing actions payload");
                }
                builder = Schedule.newBuilder(new Actions(actionsMap));
                break;
            }
            case "in_app_message": {
                InAppMessage message = InAppMessage.fromJson(jsonMap.opt(MESSAGE_KEY), "remote-data");
                builder = Schedule.newBuilder(message);
                break;
            }
            case "deferred": {
                Deferred deferred = Deferred.fromJson(jsonMap.opt(DEFERRED_KEY));
                builder = Schedule.newBuilder(deferred);
                break;
            }
            default: {
                throw new JsonException("Unexpected type: " + type);
            }
        }
        builder.setId(scheduleId).setMetadata(metadata).setGroup(jsonMap.opt(GROUP_KEY).getString()).setLimit(jsonMap.opt(LIMIT_KEY).getInt(1)).setPriority(jsonMap.opt(PRIORITY_KEY).getInt(0)).setCampaigns(jsonMap.opt(CAMPAIGNS_KEY)).setReportingContext(jsonMap.opt(REPORTING_CONTEXT_KEY)).setAudience(InAppRemoteDataObserver.parseAudience(value)).setEditGracePeriod(jsonMap.opt(EDIT_GRACE_PERIOD_KEY).getLong(0L), TimeUnit.DAYS).setInterval(jsonMap.opt(INTERVAL_KEY).getLong(0L), TimeUnit.SECONDS).setStart(InAppRemoteDataObserver.parseTimeStamp(jsonMap.opt(START_KEY).getString())).setEnd(InAppRemoteDataObserver.parseTimeStamp(jsonMap.opt(END_KEY).getString())).setFrequencyConstraintIds(InAppRemoteDataObserver.parseConstraintIds(jsonMap.opt(FREQUENCY_CONSTRAINT_IDS_KEY).optList())).setMessageType(jsonMap.opt(MESSAGE_TYPE_KEY).getString()).setBypassHoldoutGroups(jsonMap.opt(BYPASS_HOLDOUT_GROUP_KEY).getBoolean()).setNewUserEvaluationDate(createdDate).setProductId(jsonMap.opt(PRODUCT_ID_KEY).getString());
        for (JsonValue triggerJson : jsonMap.opt(TRIGGERS_KEY).optList()) {
            builder.addTrigger(Trigger.fromJson(triggerJson));
        }
        if (jsonMap.containsKey(DELAY_KEY)) {
            builder.setDelay(ScheduleDelay.fromJson(jsonMap.opt(DELAY_KEY)));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid schedule", (Throwable)e);
        }
    }

    @NonNull
    public static ScheduleEdits<? extends ScheduleData> parseEdits(@NonNull JsonValue value, @Nullable JsonMap scheduleMetadata, long createdDate) throws JsonException {
        ScheduleEdits.Builder<ScheduleData> builder;
        String type;
        JsonMap jsonMap = value.optMap();
        switch (type = jsonMap.opt(TYPE_KEY).getString("in_app_message")) {
            case "actions": {
                JsonMap actionsMap = jsonMap.opt(ACTIONS_KEY).getMap();
                if (actionsMap == null) {
                    throw new JsonException("Missing actions payload");
                }
                builder = ScheduleEdits.newBuilder(new Actions(actionsMap));
                break;
            }
            case "in_app_message": {
                InAppMessage message = InAppMessage.fromJson(jsonMap.opt(MESSAGE_KEY), "remote-data");
                builder = ScheduleEdits.newBuilder(message);
                break;
            }
            case "deferred": {
                Deferred deferred = Deferred.fromJson(jsonMap.opt(DEFERRED_KEY));
                builder = ScheduleEdits.newBuilder(deferred);
                break;
            }
            default: {
                throw new JsonException("Unexpected schedule type: " + type);
            }
        }
        builder.setMetadata(scheduleMetadata).setLimit(jsonMap.opt(LIMIT_KEY).getInt(1)).setPriority(jsonMap.opt(PRIORITY_KEY).getInt(0)).setEditGracePeriod(jsonMap.opt(EDIT_GRACE_PERIOD_KEY).getLong(0L), TimeUnit.DAYS).setInterval(jsonMap.opt(INTERVAL_KEY).getLong(0L), TimeUnit.SECONDS).setAudience(InAppRemoteDataObserver.parseAudience(value)).setCampaigns(jsonMap.opt(CAMPAIGNS_KEY)).setReportingContext(jsonMap.opt(REPORTING_CONTEXT_KEY)).setStart(InAppRemoteDataObserver.parseTimeStamp(jsonMap.opt(START_KEY).getString())).setEnd(InAppRemoteDataObserver.parseTimeStamp(jsonMap.opt(END_KEY).getString())).setFrequencyConstraintIds(InAppRemoteDataObserver.parseConstraintIds(jsonMap.opt(FREQUENCY_CONSTRAINT_IDS_KEY).optList())).setMessageType(jsonMap.opt(MESSAGE_TYPE_KEY).getString()).setBypassHoldoutGroup(jsonMap.opt(BYPASS_HOLDOUT_GROUP_KEY).getBoolean()).setNewUserEvaluationDate(createdDate).setProductId(jsonMap.opt(PRODUCT_ID_KEY).getString());
        return builder.build();
    }

    private static long parseTimeStamp(@Nullable String timeStamp) throws JsonException {
        if (timeStamp == null) {
            return -1L;
        }
        try {
            return DateUtils.parseIso8601((String)timeStamp);
        }
        catch (ParseException e) {
            throw new JsonException("Invalid timestamp: " + timeStamp, (Throwable)e);
        }
    }

    @NonNull
    private static List<String> parseConstraintIds(@NonNull JsonList optList) throws JsonException {
        ArrayList<String> constraintIds = new ArrayList<String>();
        for (JsonValue value : optList) {
            if (!value.isString()) {
                throw new JsonException("Invalid constraint ID: " + value);
            }
            constraintIds.add(value.optString());
        }
        return constraintIds;
    }

    public boolean isScheduleValid(@NonNull Schedule<? extends ScheduleData> schedule) {
        if (!this.isRemoteSchedule(schedule)) {
            return true;
        }
        RemoteDataInfo remoteDataInfo = this.parseRemoteDataInfo(schedule);
        if (remoteDataInfo == null) {
            return false;
        }
        return this.remoteData.isCurrent(remoteDataInfo);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public RemoteDataInfo parseRemoteDataInfo(@NonNull Schedule<? extends ScheduleData> schedule) {
        JsonValue value = schedule.getMetadata().get(REMOTE_DATA_INFO);
        if (value == null) {
            return null;
        }
        try {
            return new RemoteDataInfo(value);
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)"Failed to parse remote info.", (Object[])new Object[0]);
            return null;
        }
    }

    public boolean isRemoteSchedule(@NonNull Schedule<? extends ScheduleData> schedule) {
        if (schedule.getMetadata().containsKey(REMOTE_DATA_INFO)) {
            return true;
        }
        if (schedule.getMetadata().containsKey(REMOTE_DATA_METADATA)) {
            return true;
        }
        if ("in_app_message".equals(schedule.getType())) {
            InAppMessage message = (InAppMessage)schedule.coerceType();
            return "remote-data".equals(message.getSource());
        }
        return false;
    }

    public boolean requiresRefresh(@NonNull Schedule<? extends ScheduleData> schedule) {
        if (!this.isRemoteSchedule(schedule)) {
            return false;
        }
        RemoteDataInfo remoteDataInfo = this.parseRemoteDataInfo(schedule);
        return this.remoteData.requiresRefresh(remoteDataInfo);
    }

    @WorkerThread
    public void waitFullRefresh(@NonNull Schedule<? extends ScheduleData> schedule, @NonNull Runnable runnable) {
        RemoteDataInfo remoteDataInfo = this.parseRemoteDataInfo(schedule);
        this.remoteData.waitFullRefresh(remoteDataInfo, runnable);
    }

    @WorkerThread
    public void notifyOutdated(@NonNull Schedule<? extends ScheduleData> schedule) {
        RemoteDataInfo remoteDataInfo = this.parseRemoteDataInfo(schedule);
        this.remoteData.notifyOutdated(remoteDataInfo);
    }

    @WorkerThread
    public boolean bestEffortRefresh(@NonNull Schedule<? extends ScheduleData> schedule) {
        if (!this.isRemoteSchedule(schedule)) {
            return true;
        }
        RemoteDataInfo remoteDataInfo = this.parseRemoteDataInfo(schedule);
        return this.remoteData.bestEffortRefresh(remoteDataInfo);
    }

    static interface Delegate {
        @NonNull
        public PendingResult<Collection<Schedule<? extends ScheduleData>>> getSchedules();

        @NonNull
        public PendingResult<Boolean> editSchedule(@NonNull String var1, @NonNull ScheduleEdits<? extends ScheduleData> var2);

        @NonNull
        public PendingResult<Boolean> schedule(@NonNull List<Schedule<? extends ScheduleData>> var1);

        public Future<Boolean> updateConstraints(@NonNull Collection<FrequencyConstraint> var1);
    }
}

