/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;

@RequiresApi(api=21)
public class NetworkMonitor {
    private ConnectionListener connectionListener;
    private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network network) {
            if (NetworkMonitor.this.connectionListener != null) {
                NetworkMonitor.this.connectionListener.onConnectionChanged(true);
            }
        }

        public void onLost(@NonNull Network network) {
            if (NetworkMonitor.this.connectionListener != null) {
                NetworkMonitor.this.connectionListener.onConnectionChanged(false);
            }
        }
    };

    public void registerNetworkCallback() {
        ConnectivityManager connectivityManager = (ConnectivityManager)UAirship.getApplicationContext().getSystemService("connectivity");
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                connectivityManager.registerDefaultNetworkCallback(this.networkCallback);
            } else {
                NetworkRequest request = new NetworkRequest.Builder().addCapability(12).build();
                connectivityManager.registerNetworkCallback(request, this.networkCallback);
            }
        }
        catch (SecurityException e) {
            UALog.w((Throwable)e, (String)"NetworkMonitor failed to register network callback!", (Object[])new Object[0]);
        }
    }

    public void unregisterNetworkCallback() {
        ConnectivityManager connectivityManager = (ConnectivityManager)UAirship.getApplicationContext().getSystemService("connectivity");
        try {
            connectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception e) {
            UALog.w((Throwable)e, (String)"NetworkMonitor failed to unregister network callback!", (Object[])new Object[0]);
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
        this.registerNetworkCallback();
    }

    public void teardown() {
        this.connectionListener = null;
        this.unregisterNetworkCallback();
    }

    public static interface ConnectionListener {
        public void onConnectionChanged(boolean var1);
    }
}

