/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.Audience;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelay;
import com.urbanairship.automation.Trigger;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.automation.deferred.Deferred;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class Schedule<T extends ScheduleData> {
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String TYPE_IN_APP_MESSAGE = "in_app_message";
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String TYPE_ACTION = "actions";
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String TYPE_DEFERRED = "deferred";
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String DEFAULT_MESSAGE_TYPE = "transactional";
    public static final long TRIGGER_LIMIT = 10L;
    private final String id;
    private final JsonMap metadata;
    private final int limit;
    private final long start;
    private final long end;
    private final List<Trigger> triggers;
    private final ScheduleDelay delay;
    private final int priority;
    private final long triggeredTime;
    private final long editGracePeriod;
    private final long interval;
    private final String group;
    private final AudienceSelector audience;
    private final JsonValue campaigns;
    private final JsonValue reportingContext;
    private final List<String> frequencyConstraintIds;
    private final String messageType;
    private final boolean bypassHoldoutGroups;
    private final long newUserEvaluationDate;
    private final String productId;
    private final String type;
    private final T data;

    private Schedule(@NonNull Builder<T> builder) {
        this.id = ((Builder)builder).id == null ? UUID.randomUUID().toString() : ((Builder)builder).id;
        this.metadata = ((Builder)builder).metadata == null ? JsonMap.EMPTY_MAP : ((Builder)builder).metadata;
        this.limit = ((Builder)builder).limit;
        this.start = ((Builder)builder).start;
        this.end = ((Builder)builder).end;
        this.triggers = Collections.unmodifiableList(((Builder)builder).triggers);
        this.delay = ((Builder)builder).delay == null ? ScheduleDelay.newBuilder().build() : ((Builder)builder).delay;
        this.priority = ((Builder)builder).priority;
        this.triggeredTime = ((Builder)builder).triggeredTime;
        this.editGracePeriod = ((Builder)builder).editGracePeriod;
        this.interval = ((Builder)builder).interval;
        this.data = ((Builder)builder).data;
        this.type = ((Builder)builder).type;
        this.group = ((Builder)builder).group;
        this.audience = ((Builder)builder).audienceSelector;
        this.campaigns = ((Builder)builder).campaigns == null ? JsonValue.NULL : ((Builder)builder).campaigns;
        this.reportingContext = ((Builder)builder).reportingContext == null ? JsonValue.NULL : ((Builder)builder).reportingContext;
        this.frequencyConstraintIds = ((Builder)builder).frequencyConstraintIds == null ? Collections.emptyList() : Collections.unmodifiableList(((Builder)builder).frequencyConstraintIds);
        this.messageType = ((Builder)builder).messageType == null ? DEFAULT_MESSAGE_TYPE : ((Builder)builder).messageType;
        this.bypassHoldoutGroups = ((Builder)builder).bypassHoldoutGroups == null ? false : ((Builder)builder).bypassHoldoutGroups;
        this.newUserEvaluationDate = ((Builder)builder).newUserEvaluationDate;
        this.productId = ((Builder)builder).productId;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public JsonMap getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Audience getAudience() {
        if (this.audience == null) {
            return null;
        }
        return new Audience(this.audience);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public AudienceSelector getAudienceSelector() {
        return this.audience;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public T getData() {
        return this.data;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JsonValue getCampaigns() {
        return this.campaigns;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JsonValue getReportingContext() {
        return this.reportingContext;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public List<String> getFrequencyConstraintIds() {
        return this.frequencyConstraintIds;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getMessageType() {
        return this.messageType;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isBypassHoldoutGroups() {
        return this.bypassHoldoutGroups;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getNewUserEvaluationDate() {
        return this.newUserEvaluationDate;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getProductId() {
        return this.productId;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public <S extends ScheduleData> S coerceType() {
        try {
            return (S)this.data;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Unexpected data", e);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTriggeredTime() {
        return this.triggeredTime;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Nullable
    public ScheduleDelay getDelay() {
        return this.delay;
    }

    public long getEditGracePeriod() {
        return this.editGracePeriod;
    }

    public long getInterval() {
        return this.interval;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    JsonValue getDataAsJson() {
        return this.data.toJsonValue();
    }

    @NonNull
    public static Builder<Actions> newBuilder(@NonNull Actions actions) {
        return new Builder<Actions>(TYPE_ACTION, actions, null);
    }

    @NonNull
    public static Builder<InAppMessage> newBuilder(@NonNull InAppMessage message) {
        return new Builder<InAppMessage>(TYPE_IN_APP_MESSAGE, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static Builder<Deferred> newBuilder(Deferred deferred) {
        return new Builder<Deferred>(TYPE_DEFERRED, deferred, null);
    }

    @NonNull
    public static <T extends ScheduleData> Builder<T> newBuilder(@NonNull Schedule<T> schedule) {
        return new Builder(schedule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        if (this.limit != schedule.limit) {
            return false;
        }
        if (this.start != schedule.start) {
            return false;
        }
        if (this.end != schedule.end) {
            return false;
        }
        if (this.priority != schedule.priority) {
            return false;
        }
        if (this.triggeredTime != schedule.triggeredTime) {
            return false;
        }
        if (this.editGracePeriod != schedule.editGracePeriod) {
            return false;
        }
        if (this.interval != schedule.interval) {
            return false;
        }
        if (!this.id.equals(schedule.id)) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)schedule.metadata) : schedule.metadata != null) {
            return false;
        }
        if (!this.triggers.equals(schedule.triggers)) {
            return false;
        }
        if (this.delay != null ? !this.delay.equals(schedule.delay) : schedule.delay != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(schedule.group) : schedule.group != null) {
            return false;
        }
        if (this.audience != null ? !this.audience.equals((Object)schedule.audience) : schedule.audience != null) {
            return false;
        }
        if (this.campaigns != null ? !this.campaigns.equals((Object)schedule.campaigns) : schedule.campaigns != null) {
            return false;
        }
        if (!ObjectsCompat.equals((Object)this.reportingContext, (Object)schedule.reportingContext)) {
            return false;
        }
        if (this.frequencyConstraintIds != null ? !this.frequencyConstraintIds.equals(schedule.frequencyConstraintIds) : schedule.frequencyConstraintIds != null) {
            return false;
        }
        if (!this.type.equals(schedule.type)) {
            return false;
        }
        if (!ObjectsCompat.equals((Object)this.messageType, (Object)schedule.messageType)) {
            return false;
        }
        if (this.bypassHoldoutGroups != schedule.bypassHoldoutGroups) {
            return false;
        }
        if (!ObjectsCompat.equals((Object)this.productId, (Object)schedule.productId)) {
            return false;
        }
        return this.data.equals(schedule.data);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + this.limit;
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + this.triggers.hashCode();
        result = 31 * result + (this.delay != null ? this.delay.hashCode() : 0);
        result = 31 * result + this.priority;
        result = 31 * result + (int)(this.triggeredTime ^ this.triggeredTime >>> 32);
        result = 31 * result + (int)(this.editGracePeriod ^ this.editGracePeriod >>> 32);
        result = 31 * result + (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.audience != null ? this.audience.hashCode() : 0);
        result = 31 * result + (this.campaigns != null ? this.campaigns.hashCode() : 0);
        result = 31 * result + (this.frequencyConstraintIds != null ? this.frequencyConstraintIds.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.data.hashCode();
        result = 31 * result + this.reportingContext.hashCode();
        result = 31 * result + this.productId.hashCode();
        return result;
    }

    @NonNull
    public String toString() {
        return "Schedule{id='" + this.id + '\'' + ", metadata=" + this.metadata + ", limit=" + this.limit + ", start=" + this.start + ", end=" + this.end + ", triggers=" + this.triggers + ", delay=" + this.delay + ", priority=" + this.priority + ", triggeredTime=" + this.triggeredTime + ", editGracePeriod=" + this.editGracePeriod + ", interval=" + this.interval + ", group='" + this.group + '\'' + ", audience=" + this.audience + ", type='" + this.type + '\'' + ", data=" + this.data + ", campaigns=" + this.campaigns + ", reportingContext=" + this.reportingContext + ", frequencyConstraintIds=" + this.frequencyConstraintIds + ", newUserEvaluationDate=" + this.newUserEvaluationDate + ", productId=" + this.productId + '}';
    }

    public static class Builder<T extends ScheduleData> {
        private int limit = 1;
        private long start = -1L;
        private long end = -1L;
        private final List<Trigger> triggers = new ArrayList<Trigger>();
        private ScheduleDelay delay;
        private int priority;
        private long triggeredTime = -1L;
        private long editGracePeriod;
        private long interval;
        private T data;
        private String type;
        private String group;
        private JsonMap metadata;
        private String id;
        private AudienceSelector audienceSelector;
        private JsonValue campaigns;
        private JsonValue reportingContext;
        private List<String> frequencyConstraintIds;
        private String messageType;
        private Boolean bypassHoldoutGroups = false;
        private long newUserEvaluationDate;
        private String productId = null;

        private Builder(@NonNull Schedule<T> info) {
            this.id = ((Schedule)info).id;
            this.metadata = ((Schedule)info).metadata == null ? JsonMap.EMPTY_MAP : ((Schedule)info).metadata;
            this.limit = ((Schedule)info).limit;
            this.start = ((Schedule)info).start;
            this.end = ((Schedule)info).end;
            this.triggers.addAll(((Schedule)info).triggers);
            this.delay = ((Schedule)info).delay;
            this.data = ((Schedule)info).data;
            this.type = ((Schedule)info).type;
            this.priority = ((Schedule)info).priority;
            this.triggeredTime = ((Schedule)info).triggeredTime;
            this.editGracePeriod = ((Schedule)info).editGracePeriod;
            this.interval = ((Schedule)info).interval;
            this.audienceSelector = ((Schedule)info).audience;
            this.group = ((Schedule)info).group;
            this.campaigns = ((Schedule)info).campaigns;
            this.frequencyConstraintIds = ((Schedule)info).frequencyConstraintIds;
            this.reportingContext = ((Schedule)info).reportingContext;
            this.messageType = ((Schedule)info).messageType;
            this.bypassHoldoutGroups = ((Schedule)info).bypassHoldoutGroups;
            this.newUserEvaluationDate = ((Schedule)info).newUserEvaluationDate;
            this.productId = ((Schedule)info).productId;
        }

        private Builder(@NonNull String type, @NonNull T data) {
            this.type = type;
            this.data = data;
        }

        @Deprecated
        @NonNull
        public Builder<T> setAudience(@Nullable Audience audience) {
            this.audienceSelector = audience == null ? null : audience.getAudienceSelector();
            return this;
        }

        @NonNull
        public Builder<T> setAudience(@Nullable AudienceSelector audience) {
            this.audienceSelector = audience;
            return this;
        }

        @NonNull
        public Builder<T> setId(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder<T> setMetadata(@NonNull JsonMap metadata) {
            this.metadata = metadata;
            return this;
        }

        @NonNull
        public Builder<T> setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        @NonNull
        public Builder<T> setStart(long start) {
            this.start = start;
            return this;
        }

        @NonNull
        public Builder<T> setEnd(long end) {
            this.end = end;
            return this;
        }

        @NonNull
        public Builder<T> setDelay(@Nullable ScheduleDelay delay) {
            this.delay = delay;
            return this;
        }

        @NonNull
        public Builder<T> setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setTriggeredTime(long triggeredTime) {
            this.triggeredTime = triggeredTime;
            return this;
        }

        @NonNull
        public Builder<T> setGroup(@Nullable String group) {
            this.group = group;
            return this;
        }

        @NonNull
        public Builder<T> addTrigger(@NonNull Trigger trigger) {
            this.triggers.add(trigger);
            return this;
        }

        @NonNull
        public Builder<T> addTriggers(@NonNull List<Trigger> triggers) {
            this.triggers.addAll(triggers);
            return this;
        }

        @NonNull
        public Builder<T> setTriggers(@Nullable List<Trigger> triggers) {
            this.triggers.clear();
            if (triggers != null) {
                this.triggers.addAll(triggers);
            }
            return this;
        }

        @NonNull
        public Builder<T> setEditGracePeriod(@IntRange(from=0L) long duration, @NonNull TimeUnit timeUnit) {
            this.editGracePeriod = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder<T> setInterval(@IntRange(from=0L) long duration, @NonNull TimeUnit timeUnit) {
            this.interval = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setReportingContext(@Nullable JsonValue reportingContext) {
            this.reportingContext = reportingContext;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setCampaigns(@Nullable JsonValue campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setFrequencyConstraintIds(@Nullable List<String> frequencyConstraintIds) {
            this.frequencyConstraintIds = frequencyConstraintIds;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setMessageType(@Nullable String messageType) {
            this.messageType = messageType;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setBypassHoldoutGroups(Boolean bypassHoldoutGroups) {
            this.bypassHoldoutGroups = bypassHoldoutGroups;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setNewUserEvaluationDate(long date) {
            this.newUserEvaluationDate = date;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setProductId(@Nullable String productId) {
            this.productId = productId;
            return this;
        }

        @NonNull
        public Schedule<T> build() {
            Checks.checkNotNull(this.data, (String)"Missing data.");
            Checks.checkNotNull((Object)this.type, (String)"Missing type.");
            Checks.checkArgument((this.start < 0L || this.end < 0L || this.start <= this.end ? 1 : 0) != 0, (String)"End must be on or after start.");
            Checks.checkArgument((this.triggers.size() > 0 ? 1 : 0) != 0, (String)"Must contain at least 1 trigger.");
            Checks.checkArgument(((long)this.triggers.size() <= 10L ? 1 : 0) != 0, (String)"No more than 10 triggers allowed.");
            return new Schedule(this);
        }

        /* synthetic */ Builder(String x0, ScheduleData x1, 1 x2) {
            this(x0, x1);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Type {
    }
}

