/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.ScheduleDelay;
import com.urbanairship.automation.Trigger;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.automation.deferred.Deferred;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

class ScheduleConverters {
    ScheduleConverters() {
    }

    @NonNull
    static List<FullSchedule> convertSchedules(@NonNull Collection<Schedule<? extends ScheduleData>> schedules) {
        ArrayList<FullSchedule> entries = new ArrayList<FullSchedule>();
        for (Schedule<? extends ScheduleData> schedule : schedules) {
            entries.add(ScheduleConverters.convert(schedule));
        }
        return entries;
    }

    @NonNull
    static <T extends ScheduleData> Schedule<T> convert(@NonNull FullSchedule entry) throws JsonException, IllegalArgumentException, ClassCastException {
        Schedule.Builder<T> scheduleBuilder = ScheduleConverters.createScheduleBuilder(entry.schedule.data, entry.schedule.scheduleType);
        scheduleBuilder = scheduleBuilder.setId(entry.schedule.scheduleId).setMetadata(entry.schedule.metadata).setGroup(entry.schedule.group).setEnd(entry.schedule.scheduleEnd).setStart(entry.schedule.scheduleStart).setLimit(entry.schedule.limit).setPriority(entry.schedule.priority).setTriggeredTime(entry.schedule.triggeredTime).setInterval(entry.schedule.interval, TimeUnit.MILLISECONDS).setEditGracePeriod(entry.schedule.editGracePeriod, TimeUnit.MILLISECONDS).setAudience(entry.schedule.audience).setCampaigns(entry.schedule.campaigns).setReportingContext(entry.schedule.reportingContext).setFrequencyConstraintIds(entry.schedule.frequencyConstraintIds).setMessageType(entry.schedule.messageType).setBypassHoldoutGroups(entry.schedule.bypassHoldoutGroups).setNewUserEvaluationDate(entry.schedule.newUserEvaluationDate).setProductId(entry.schedule.productId);
        ScheduleDelay.Builder delayBuilder = ScheduleDelay.newBuilder().setAppState(entry.schedule.appState).setRegionId(entry.schedule.regionId).setScreens(entry.schedule.screens).setSeconds(entry.schedule.seconds);
        for (TriggerEntity entity : entry.triggers) {
            if (entity.isCancellation) {
                delayBuilder.addCancellationTrigger(ScheduleConverters.convert(entity));
                continue;
            }
            scheduleBuilder.addTrigger(ScheduleConverters.convert(entity));
        }
        return scheduleBuilder.setDelay(delayBuilder.build()).build();
    }

    @NonNull
    static Trigger convert(@NonNull TriggerEntity entry) {
        return new Trigger(entry.triggerType, entry.goal, entry.jsonPredicate);
    }

    @NonNull
    static FullSchedule convert(@NonNull Schedule<?> schedule) {
        ScheduleEntity entity = new ScheduleEntity();
        ArrayList<TriggerEntity> triggerEntities = new ArrayList<TriggerEntity>();
        entity.scheduleId = schedule.getId();
        entity.group = schedule.getGroup();
        entity.metadata = schedule.getMetadata();
        entity.scheduleEnd = schedule.getEnd();
        entity.scheduleStart = schedule.getStart();
        entity.limit = schedule.getLimit();
        entity.priority = schedule.getPriority();
        entity.triggeredTime = schedule.getTriggeredTime();
        entity.interval = schedule.getInterval();
        entity.editGracePeriod = schedule.getEditGracePeriod();
        entity.audience = schedule.getAudienceSelector();
        entity.scheduleType = schedule.getType();
        entity.data = schedule.getDataAsJson();
        entity.campaigns = schedule.getCampaigns();
        entity.reportingContext = schedule.getReportingContext();
        entity.frequencyConstraintIds = schedule.getFrequencyConstraintIds();
        entity.messageType = schedule.getMessageType();
        entity.bypassHoldoutGroups = schedule.isBypassHoldoutGroups();
        entity.newUserEvaluationDate = schedule.getNewUserEvaluationDate();
        entity.productId = schedule.getProductId();
        for (Trigger trigger : schedule.getTriggers()) {
            triggerEntities.add(ScheduleConverters.convert(trigger, false, schedule.getId()));
        }
        ScheduleDelay delay = schedule.getDelay();
        if (delay != null) {
            entity.screens = delay.getScreens();
            entity.regionId = delay.getRegionId();
            entity.appState = delay.getAppState();
            entity.seconds = delay.getSeconds();
            for (Trigger trigger : delay.getCancellationTriggers()) {
                triggerEntities.add(ScheduleConverters.convert(trigger, true, schedule.getId()));
            }
        }
        return new FullSchedule(entity, triggerEntities);
    }

    @NonNull
    private static TriggerEntity convert(@NonNull Trigger trigger, boolean isCancellation, @NonNull String parentScheduleId) {
        TriggerEntity entity = new TriggerEntity();
        entity.goal = trigger.getGoal();
        entity.isCancellation = isCancellation;
        entity.triggerType = trigger.getType();
        entity.jsonPredicate = trigger.getPredicate();
        entity.parentScheduleId = parentScheduleId;
        return entity;
    }

    private static <T extends ScheduleData> Schedule.Builder<T> createScheduleBuilder(@NonNull JsonValue json, String type) throws JsonException {
        switch (type) {
            case "actions": {
                JsonMap actionsMap = json.optMap();
                return Schedule.newBuilder(new Actions(actionsMap));
            }
            case "in_app_message": {
                InAppMessage message = InAppMessage.fromJson(json);
                return Schedule.newBuilder(message);
            }
            case "deferred": {
                Deferred deferred = Deferred.fromJson(json);
                return Schedule.newBuilder(deferred);
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }
}

