/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.automation.Trigger;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ScheduleDelay
implements Parcelable,
JsonSerializable {
    private static final String SECONDS_KEY = "seconds";
    private static final String APP_STATE_KEY = "app_state";
    private static final String APP_STATE_ANY_NAME = "any";
    private static final String APP_STATE_FOREGROUND_NAME = "foreground";
    private static final String APP_STATE_BACKGROUND_NAME = "background";
    private static final String SCREEN_KEY = "screen";
    private static final String REGION_ID_KEY = "region_id";
    private static final String CANCELLATION_TRIGGERS_KEY = "cancellation_triggers";
    public static final int APP_STATE_ANY = 1;
    public static final int APP_STATE_FOREGROUND = 2;
    public static final int APP_STATE_BACKGROUND = 3;
    @NonNull
    public static final Parcelable.Creator<ScheduleDelay> CREATOR = new Parcelable.Creator<ScheduleDelay>(){

        public ScheduleDelay createFromParcel(@NonNull Parcel in) {
            return new ScheduleDelay(in);
        }

        public ScheduleDelay[] newArray(int size) {
            return new ScheduleDelay[size];
        }
    };
    private final long seconds;
    private final List<String> screens;
    private final int appState;
    private final String regionId;
    private final List<Trigger> cancellationTriggers;

    ScheduleDelay(@NonNull Builder builder) {
        this.seconds = builder.seconds;
        this.screens = builder.screens == null ? Collections.emptyList() : new ArrayList(builder.screens);
        this.appState = builder.appState;
        this.regionId = builder.regionId;
        this.cancellationTriggers = builder.cancellationTriggers;
    }

    protected ScheduleDelay(@NonNull Parcel in) {
        int appState;
        this.seconds = in.readLong();
        this.screens = new ArrayList<String>();
        in.readList(this.screens, String.class.getClassLoader());
        switch (in.readInt()) {
            case 1: {
                appState = 1;
                break;
            }
            case 2: {
                appState = 2;
                break;
            }
            case 3: {
                appState = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid app state from parcel.");
            }
        }
        this.appState = appState;
        this.regionId = in.readString();
        this.cancellationTriggers = in.createTypedArrayList(Trigger.CREATOR);
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.seconds);
        dest.writeList(this.screens);
        dest.writeInt(this.appState);
        dest.writeString(this.regionId);
        dest.writeTypedList(this.cancellationTriggers);
    }

    public int describeContents() {
        return 0;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public long getSeconds() {
        return this.seconds;
    }

    @Nullable
    public List<String> getScreens() {
        return this.screens;
    }

    public int getAppState() {
        return this.appState;
    }

    @Nullable
    public String getRegionId() {
        return this.regionId;
    }

    @NonNull
    public List<Trigger> getCancellationTriggers() {
        return this.cancellationTriggers;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleDelay that = (ScheduleDelay)o;
        if (this.seconds != that.seconds) {
            return false;
        }
        if (this.appState != that.appState) {
            return false;
        }
        if (this.screens != null ? !this.screens.equals(that.screens) : that.screens != null) {
            return false;
        }
        if (this.regionId != null ? !this.regionId.equals(that.regionId) : that.regionId != null) {
            return false;
        }
        return this.cancellationTriggers.equals(that.cancellationTriggers);
    }

    public int hashCode() {
        int result = (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + (this.screens != null ? this.screens.hashCode() : 0);
        result = 31 * result + this.appState;
        result = 31 * result + (this.regionId != null ? this.regionId.hashCode() : 0);
        result = 31 * result + this.cancellationTriggers.hashCode();
        return result;
    }

    @NonNull
    public static ScheduleDelay fromJson(@NonNull JsonValue value) throws JsonException {
        int appState;
        String appStateString;
        JsonMap jsonMap = value.optMap();
        Builder builder = ScheduleDelay.newBuilder().setSeconds(jsonMap.opt(SECONDS_KEY).getLong(0L));
        switch (appStateString = jsonMap.opt(APP_STATE_KEY).getString(APP_STATE_ANY_NAME).toLowerCase(Locale.ROOT)) {
            case "any": {
                appState = 1;
                break;
            }
            case "foreground": {
                appState = 2;
                break;
            }
            case "background": {
                appState = 3;
                break;
            }
            default: {
                throw new JsonException("Invalid app state: " + appStateString);
            }
        }
        builder.setAppState(appState);
        if (jsonMap.containsKey(SCREEN_KEY)) {
            JsonValue screenValue = jsonMap.opt(SCREEN_KEY);
            if (screenValue.isString()) {
                builder.setScreen(screenValue.optString());
            } else {
                builder.setScreens(screenValue.optList());
            }
        }
        if (jsonMap.containsKey(REGION_ID_KEY)) {
            builder.setRegionId(jsonMap.opt(REGION_ID_KEY).optString());
        }
        for (JsonValue triggerJson : jsonMap.opt(CANCELLATION_TRIGGERS_KEY).optList()) {
            builder.addCancellationTrigger(Trigger.fromJson(triggerJson));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid schedule delay info", (Throwable)e);
        }
    }

    @NonNull
    public JsonValue toJsonValue() {
        String appState = null;
        switch (this.getAppState()) {
            case 1: {
                appState = APP_STATE_ANY_NAME;
                break;
            }
            case 3: {
                appState = APP_STATE_BACKGROUND_NAME;
                break;
            }
            case 2: {
                appState = APP_STATE_FOREGROUND_NAME;
            }
        }
        return JsonMap.newBuilder().put(SECONDS_KEY, this.getSeconds()).put(APP_STATE_KEY, appState).put(SCREEN_KEY, (JsonSerializable)JsonValue.wrapOpt(this.getScreens())).put(REGION_ID_KEY, this.getRegionId()).put(CANCELLATION_TRIGGERS_KEY, (JsonSerializable)JsonValue.wrapOpt(this.getCancellationTriggers())).build().toJsonValue();
    }

    @NonNull
    public String toString() {
        return "ScheduleDelay{seconds=" + this.seconds + ", screens=" + this.screens + ", appState=" + this.appState + ", regionId='" + this.regionId + '\'' + ", cancellationTriggers=" + this.cancellationTriggers + '}';
    }

    public static class Builder {
        private long seconds;
        private List<String> screens;
        private int appState = 1;
        private String regionId = null;
        private final List<Trigger> cancellationTriggers = new ArrayList<Trigger>();

        @NonNull
        public Builder setSeconds(long seconds) {
            this.seconds = seconds;
            return this;
        }

        @NonNull
        public Builder setScreen(@NonNull String screen) {
            this.screens = Collections.singletonList(screen);
            return this;
        }

        @NonNull
        public Builder setScreens(@NonNull List<String> screens) {
            this.screens = screens;
            return this;
        }

        @NonNull
        public Builder setScreens(@NonNull JsonList screens) {
            this.screens = new ArrayList<String>();
            for (JsonValue value : screens) {
                if (value.getString() == null) continue;
                this.screens.add(value.getString());
            }
            return this;
        }

        @NonNull
        public Builder setAppState(int appState) {
            this.appState = appState;
            return this;
        }

        @NonNull
        public Builder setRegionId(@Nullable String regionId) {
            this.regionId = regionId;
            return this;
        }

        @NonNull
        public Builder addCancellationTrigger(@NonNull Trigger cancellationTrigger) {
            this.cancellationTriggers.add(cancellationTrigger);
            return this;
        }

        @NonNull
        public ScheduleDelay build() {
            if ((long)this.cancellationTriggers.size() > 10L) {
                throw new IllegalArgumentException("No more than 10 cancellation triggers allowed.");
            }
            return new ScheduleDelay(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppState {
    }
}

