/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.Audience;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.automation.deferred.Deferred;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ScheduleEdits<T extends ScheduleData> {
    private final Integer limit;
    private final Long start;
    private final Long end;
    private final T data;
    private final Integer priority;
    private final Long editGracePeriod;
    private final Long interval;
    private final JsonMap metadata;
    private final AudienceSelector audienceSelector;
    private final String type;
    private final JsonValue campaigns;
    private final JsonValue reportingContext;
    private final List<String> frequencyConstraintIds;
    private final String messageType;
    private final Boolean bypassHoldoutGroups;
    private final long newUserEvaluationDate;
    private final String productId;

    private ScheduleEdits(@NonNull Builder<T> builder) {
        this.limit = ((Builder)builder).limit;
        this.start = ((Builder)builder).start;
        this.end = ((Builder)builder).end;
        this.data = ((Builder)builder).data;
        this.type = ((Builder)builder).type;
        this.priority = ((Builder)builder).priority;
        this.interval = ((Builder)builder).interval;
        this.editGracePeriod = ((Builder)builder).editGracePeriod;
        this.metadata = ((Builder)builder).metadata;
        this.frequencyConstraintIds = ((Builder)builder).frequencyConstraintIds;
        this.campaigns = ((Builder)builder).campaigns;
        this.reportingContext = ((Builder)builder).reportingContext;
        this.messageType = ((Builder)builder).messageType;
        this.bypassHoldoutGroups = ((Builder)builder).bypassHoldoutGroups;
        this.audienceSelector = ((Builder)builder).audienceSelector;
        this.newUserEvaluationDate = ((Builder)builder).newUserEvaluationDate;
        this.productId = ((Builder)builder).productId;
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    @Nullable
    public Long getStart() {
        return this.start;
    }

    @Nullable
    public Long getEnd() {
        return this.end;
    }

    @Nullable
    public Long getInterval() {
        return this.interval;
    }

    @Nullable
    public Long getEditGracePeriod() {
        return this.editGracePeriod;
    }

    @Nullable
    public JsonMap getMetadata() {
        return this.metadata;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public Audience getAudience() {
        if (this.audienceSelector == null) {
            return null;
        }
        return new Audience(this.audienceSelector);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public AudienceSelector getAudienceSelector() {
        return this.audienceSelector;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JsonValue getCampaigns() {
        return this.campaigns;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JsonValue getReportingContext() {
        return this.reportingContext;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public List<String> getFrequencyConstraintIds() {
        return this.frequencyConstraintIds;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Boolean getBypassHoldoutGroup() {
        return this.bypassHoldoutGroups;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getNewUserEvaluationDate() {
        return this.newUserEvaluationDate;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getProductId() {
        return this.productId;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getMessageType() {
        return this.messageType;
    }

    @NonNull
    public static Builder<?> newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder<Actions> newBuilder(@NonNull Actions actions) {
        return new Builder<Actions>("actions", actions, null);
    }

    @NonNull
    public static Builder<InAppMessage> newBuilder(@NonNull InAppMessage message) {
        return new Builder<InAppMessage>("in_app_message", message, null);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Builder<Deferred> newBuilder(@NonNull Deferred deferred) {
        return new Builder<Deferred>("deferred", deferred, null);
    }

    @NonNull
    public static <T extends ScheduleData> Builder<T> newBuilder(@NonNull ScheduleEdits<T> edits) {
        return new Builder(edits);
    }

    public static class Builder<T extends ScheduleData> {
        private Integer limit;
        private Long start;
        private Long end;
        private Integer priority;
        private Long editGracePeriod;
        private Long interval;
        private JsonMap metadata;
        private T data;
        private JsonValue campaigns;
        private JsonValue reportingContext;
        private List<String> frequencyConstraintIds;
        private String messageType;
        private Boolean bypassHoldoutGroups;
        private long newUserEvaluationDate;
        private String productId;
        private String type;
        private AudienceSelector audienceSelector;

        private Builder() {
        }

        private Builder(@NonNull String type, @NonNull T scheduleData) {
            this.type = type;
            this.data = scheduleData;
        }

        private Builder(@NonNull ScheduleEdits<T> edits) {
            this.limit = ((ScheduleEdits)edits).limit;
            this.start = ((ScheduleEdits)edits).start;
            this.end = ((ScheduleEdits)edits).end;
            this.data = ((ScheduleEdits)edits).data;
            this.priority = ((ScheduleEdits)edits).priority;
            this.type = ((ScheduleEdits)edits).type;
            this.editGracePeriod = ((ScheduleEdits)edits).editGracePeriod;
            this.interval = ((ScheduleEdits)edits).interval;
            this.metadata = ((ScheduleEdits)edits).metadata;
            this.campaigns = ((ScheduleEdits)edits).campaigns;
            this.frequencyConstraintIds = ((ScheduleEdits)edits).frequencyConstraintIds;
            this.reportingContext = ((ScheduleEdits)edits).reportingContext;
            this.messageType = ((ScheduleEdits)edits).messageType;
            this.bypassHoldoutGroups = ((ScheduleEdits)edits).bypassHoldoutGroups;
            this.newUserEvaluationDate = ((ScheduleEdits)edits).newUserEvaluationDate;
            this.productId = ((ScheduleEdits)edits).productId;
        }

        @NonNull
        public Builder<T> setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        @NonNull
        public Builder<T> setStart(long start) {
            this.start = start;
            return this;
        }

        @NonNull
        public Builder<T> setEnd(long end) {
            this.end = end;
            return this;
        }

        @NonNull
        public Builder<T> setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @NonNull
        public Builder<T> setEditGracePeriod(@IntRange(from=0L) long duration, @NonNull TimeUnit timeUnit) {
            this.editGracePeriod = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder<T> setInterval(@IntRange(from=0L) long duration, @NonNull TimeUnit timeUnit) {
            this.interval = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder<T> setMetadata(@Nullable JsonMap metadata) {
            this.metadata = metadata;
            return this;
        }

        @Deprecated
        public Builder<T> setAudience(@Nullable Audience audience) {
            this.audienceSelector = audience == null ? null : audience.getAudienceSelector();
            return this;
        }

        public Builder<T> setAudience(@Nullable AudienceSelector audience) {
            this.audienceSelector = audience;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setCampaigns(@Nullable JsonValue campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setReportingContext(@Nullable JsonValue reportingContext) {
            this.reportingContext = reportingContext;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setFrequencyConstraintIds(@Nullable List<String> frequencyConstraintIds) {
            this.frequencyConstraintIds = frequencyConstraintIds == null ? null : new ArrayList<String>(frequencyConstraintIds);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setMessageType(@Nullable String messageType) {
            this.messageType = messageType;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setBypassHoldoutGroup(@Nullable Boolean flag) {
            this.bypassHoldoutGroups = flag;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setNewUserEvaluationDate(long date) {
            this.newUserEvaluationDate = date;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder<T> setProductId(@Nullable String productId) {
            this.productId = productId;
            return this;
        }

        @NonNull
        public ScheduleEdits<T> build() {
            return new ScheduleEdits(this);
        }

        /* synthetic */ Builder(String x0, ScheduleData x1, 1 x2) {
            this(x0, x1);
        }
    }
}

