/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonPredicate;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class Trigger
implements Parcelable,
JsonSerializable {
    private static final String GOAL_KEY = "goal";
    private static final String TYPE_KEY = "type";
    private static final String PREDICATE_KEY = "predicate";
    private static final String CUSTOM_EVENT_COUNT_NAME = "custom_event_count";
    private static final String CUSTOM_EVENT_VALUE_NAME = "custom_event_value";
    private static final String FOREGROUND_NAME = "foreground";
    private static final String BACKGROUND_NAME = "background";
    private static final String APP_INIT_NAME = "app_init";
    private static final String SCREEN_NAME = "screen";
    private static final String REGION_ENTER_NAME = "region_enter";
    private static final String REGION_EXIT_NAME = "region_exit";
    private static final String ACTIVE_SESSION_NAME = "active_session";
    private static final String VERSION_NAME = "version";
    private static final String FEATURE_FLAG_INTERACTED_NAME = "feature_flag_interaction";
    public static final int LIFE_CYCLE_FOREGROUND = 1;
    public static final int LIFE_CYCLE_BACKGROUND = 2;
    public static final int REGION_ENTER = 3;
    public static final int REGION_EXIT = 4;
    public static final int CUSTOM_EVENT_COUNT = 5;
    public static final int CUSTOM_EVENT_VALUE = 6;
    public static final int SCREEN_VIEW = 7;
    public static final int LIFE_CYCLE_APP_INIT = 8;
    public static final int ACTIVE_SESSION = 9;
    public static final int VERSION = 10;
    public static final int FEATURE_FLAG_INTERACTED = 11;
    @NonNull
    public static final Parcelable.Creator<Trigger> CREATOR = new Parcelable.Creator<Trigger>(){

        @NonNull
        public Trigger createFromParcel(@NonNull Parcel in) {
            return new Trigger(in);
        }

        @NonNull
        public Trigger[] newArray(int size) {
            return new Trigger[size];
        }
    };
    private final int type;
    private final double goal;
    private final JsonPredicate predicate;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Trigger(int type, double goal, @Nullable JsonPredicate predicate) {
        this.type = type;
        this.goal = goal;
        this.predicate = predicate;
    }

    public Trigger(@NonNull Parcel in) {
        int type;
        JsonPredicate predicate = null;
        switch (in.readInt()) {
            case 2: {
                type = 2;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            case 8: {
                type = 8;
                break;
            }
            case 3: {
                type = 3;
                break;
            }
            case 4: {
                type = 4;
                break;
            }
            case 5: {
                type = 5;
                break;
            }
            case 6: {
                type = 6;
                break;
            }
            case 7: {
                type = 7;
                break;
            }
            case 9: {
                type = 9;
                break;
            }
            case 10: {
                type = 10;
                break;
            }
            case 11: {
                type = 11;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid trigger type from parcel.");
            }
        }
        double goal = in.readDouble();
        JsonValue predicateJson = (JsonValue)in.readParcelable(JsonValue.class.getClassLoader());
        if (predicateJson != null) {
            try {
                predicate = JsonPredicate.parse((JsonValue)predicateJson);
            }
            catch (JsonException e) {
                throw new IllegalStateException("Invalid trigger predicate from parcel.", e);
            }
        }
        this.type = type;
        this.goal = goal;
        this.predicate = predicate;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeDouble(this.goal);
        dest.writeParcelable((Parcelable)(this.predicate == null ? null : this.predicate.toJsonValue()), flags);
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(TYPE_KEY, Trigger.convertType(this.type)).put(GOAL_KEY, this.goal).put(PREDICATE_KEY, (JsonSerializable)this.predicate).build().toJsonValue();
    }

    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public double getGoal() {
        return this.goal;
    }

    @Nullable
    public JsonPredicate getPredicate() {
        return this.predicate;
    }

    @NonNull
    public static Trigger fromJson(@NonNull JsonValue value) throws JsonException {
        int type;
        JsonMap jsonMap = value.optMap();
        JsonPredicate predicate = jsonMap.containsKey(PREDICATE_KEY) ? JsonPredicate.parse((JsonValue)jsonMap.opt(PREDICATE_KEY)) : null;
        double goal = jsonMap.opt(GOAL_KEY).getDouble(-1.0);
        if (!(goal > 0.0)) {
            throw new JsonException("Trigger goal must be defined and greater than 0.");
        }
        String typeString = jsonMap.opt(TYPE_KEY).optString().toLowerCase(Locale.ROOT);
        try {
            type = Trigger.convertType(typeString);
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid trigger type: " + typeString);
        }
        return new Trigger(type, goal, predicate);
    }

    private static int convertType(@NonNull String typeString) {
        switch (typeString) {
            case "custom_event_count": {
                return 5;
            }
            case "custom_event_value": {
                return 6;
            }
            case "foreground": {
                return 1;
            }
            case "background": {
                return 2;
            }
            case "app_init": {
                return 8;
            }
            case "screen": {
                return 7;
            }
            case "region_enter": {
                return 3;
            }
            case "region_exit": {
                return 4;
            }
            case "active_session": {
                return 9;
            }
            case "version": {
                return 10;
            }
            case "feature_flag_interaction": {
                return 11;
            }
        }
        throw new IllegalArgumentException("Invalid trigger type: " + typeString);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getTriggerName() {
        return Trigger.convertType(this.type);
    }

    @NonNull
    private static String convertType(int type) {
        switch (type) {
            case 5: {
                return CUSTOM_EVENT_COUNT_NAME;
            }
            case 6: {
                return CUSTOM_EVENT_VALUE_NAME;
            }
            case 1: {
                return FOREGROUND_NAME;
            }
            case 2: {
                return BACKGROUND_NAME;
            }
            case 8: {
                return APP_INIT_NAME;
            }
            case 7: {
                return SCREEN_NAME;
            }
            case 3: {
                return REGION_ENTER_NAME;
            }
            case 4: {
                return REGION_EXIT_NAME;
            }
            case 9: {
                return ACTIVE_SESSION_NAME;
            }
            case 10: {
                return VERSION_NAME;
            }
            case 11: {
                return FEATURE_FLAG_INTERACTED_NAME;
            }
        }
        throw new IllegalArgumentException("Invalid trigger type: " + type);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        if (this.type != trigger.type) {
            return false;
        }
        if (Double.compare(trigger.goal, this.goal) != 0) {
            return false;
        }
        return this.predicate != null ? this.predicate.equals((Object)trigger.predicate) : trigger.predicate == null;
    }

    public int hashCode() {
        int result = this.type;
        long temp = Double.doubleToLongBits(this.goal);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Trigger{type=" + Trigger.convertType(this.type) + ", goal=" + this.goal + ", predicate=" + this.predicate + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TriggerType {
    }
}

