/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.automation.Trigger;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TriggerContext
implements JsonSerializable {
    private static final String TRIGGER_KEY = "trigger";
    private static final String EVENT_KEY = "event";
    private Trigger trigger;
    private JsonValue event;

    public TriggerContext(@NonNull Trigger trigger, @NonNull JsonValue event) {
        this.trigger = trigger;
        this.event = event;
    }

    @NonNull
    public JsonValue getEvent() {
        return this.event;
    }

    @NonNull
    public Trigger getTrigger() {
        return this.trigger;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(TRIGGER_KEY, (JsonSerializable)this.trigger).put(EVENT_KEY, (JsonSerializable)this.event).build().toJsonValue();
    }

    @NonNull
    public static TriggerContext fromJson(@NonNull JsonValue jsonValue) throws JsonException {
        JsonValue event = jsonValue.optMap().opt(EVENT_KEY);
        Trigger trigger = Trigger.fromJson(jsonValue.optMap().opt(TRIGGER_KEY));
        return new TriggerContext(trigger, event);
    }

    @NonNull
    public String toString() {
        return "TriggerContext{trigger=" + this.trigger + ", event=" + this.event + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerContext that = (TriggerContext)o;
        if (!this.trigger.equals(that.trigger)) {
            return false;
        }
        return this.event.equals((Object)that.event);
    }

    public int hashCode() {
        int result = this.trigger.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }
}

