/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import androidx.core.util.Consumer;
import com.urbanairship.UAirship;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.app.ApplicationListener;
import com.urbanairship.app.SimpleApplicationListener;
import com.urbanairship.automation.AutomationEngine;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.reactive.Function;
import com.urbanairship.reactive.Observable;
import com.urbanairship.reactive.Observer;
import com.urbanairship.reactive.Scheduler;
import com.urbanairship.reactive.Schedulers;
import com.urbanairship.reactive.Subscription;
import com.urbanairship.reactive.Supplier;
import com.urbanairship.util.VersionUtils;
import java.util.concurrent.atomic.AtomicBoolean;

class TriggerObservables {
    TriggerObservables() {
    }

    public static Observable<JsonSerializable> foregrounded(final @NonNull ActivityMonitor monitor) {
        return Observable.create((Function)new Function<Observer<JsonSerializable>, Subscription>(){

            @NonNull
            public Subscription apply(@NonNull Observer<JsonSerializable> observer) {
                if (monitor.isAppForegrounded()) {
                    observer.onNext((Object)JsonValue.NULL);
                }
                observer.onCompleted();
                return Subscription.empty();
            }
        }).subscribeOn((Scheduler)Schedulers.main());
    }

    public static Observable<JsonSerializable> newSession(final @NonNull ActivityMonitor monitor, final @NonNull AutomationEngine.PausedManager pausedManager) {
        final AtomicBoolean processForegroundOnResume = new AtomicBoolean(false);
        return Observable.create((Function)new Function<Observer<JsonSerializable>, Subscription>(){

            @NonNull
            public Subscription apply(final @NonNull Observer<JsonSerializable> observer) {
                SimpleApplicationListener listener = new SimpleApplicationListener(){

                    public void onForeground(long time) {
                        if (pausedManager.isPaused()) {
                            processForegroundOnResume.set(true);
                        } else {
                            observer.onNext((Object)JsonValue.NULL);
                            processForegroundOnResume.set(false);
                        }
                    }

                    public void onBackground(long time) {
                        super.onBackground(time);
                        processForegroundOnResume.set(false);
                    }
                };
                pausedManager.addConsumer((Consumer<Boolean>)((Consumer)isPaused -> {
                    if (!isPaused.booleanValue() && processForegroundOnResume.get()) {
                        observer.onNext((Object)JsonValue.NULL);
                        processForegroundOnResume.set(false);
                    }
                }));
                monitor.addApplicationListener((ApplicationListener)listener);
                return Subscription.create(() -> 2.lambda$apply$1(monitor, (ApplicationListener)listener));
            }

            private static /* synthetic */ void lambda$apply$1(ActivityMonitor monitor2, ApplicationListener listener) {
                monitor2.removeApplicationListener(listener);
            }
        }).subscribeOn((Scheduler)Schedulers.main());
    }

    public static Observable<JsonSerializable> appVersionUpdated() {
        return Observable.defer((Supplier)new Supplier<Observable<JsonSerializable>>(){

            @NonNull
            public Observable<JsonSerializable> apply() {
                if (UAirship.shared().getApplicationMetrics().getAppVersionUpdated()) {
                    return Observable.just((Object)VersionUtils.createVersionObject());
                }
                return Observable.empty();
            }
        });
    }
}

