/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.automation.Trigger;
import com.urbanairship.json.JsonMatcher;
import com.urbanairship.json.JsonPredicate;
import com.urbanairship.json.JsonValue;
import com.urbanairship.json.ValueMatcher;
import com.urbanairship.util.UAStringUtil;
import com.urbanairship.util.VersionUtils;

public class Triggers {
    @NonNull
    public static LifeCycleTriggerBuilder newForegroundTriggerBuilder() {
        return new LifeCycleTriggerBuilder(1);
    }

    @NonNull
    public static LifeCycleTriggerBuilder newBackgroundTriggerBuilder() {
        return new LifeCycleTriggerBuilder(2);
    }

    @NonNull
    public static LifeCycleTriggerBuilder newAppInitTriggerBuilder() {
        return new LifeCycleTriggerBuilder(8);
    }

    @NonNull
    public static RegionTriggerBuilder newEnterRegionTriggerBuilder() {
        return new RegionTriggerBuilder(3);
    }

    @NonNull
    public static RegionTriggerBuilder newExitRegionTriggerBuilder() {
        return new RegionTriggerBuilder(4);
    }

    @NonNull
    public static ScreenTriggerBuilder newScreenTriggerBuilder() {
        return new ScreenTriggerBuilder();
    }

    @NonNull
    public static CustomEventTriggerBuilder newCustomEventTriggerBuilder() {
        return new CustomEventTriggerBuilder();
    }

    @NonNull
    public static ActiveSessionTriggerBuilder newActiveSessionTriggerBuilder() {
        return new ActiveSessionTriggerBuilder();
    }

    @NonNull
    public static VersionTriggerBuilder newVersionTriggerBuilder(@Nullable ValueMatcher versionMatcher) {
        return new VersionTriggerBuilder(versionMatcher);
    }

    @NonNull
    public static FeatureFlagEventTriggerBuilder newFeatureFlagInteractedTriggerBuilder() {
        return new FeatureFlagEventTriggerBuilder();
    }

    public static class FeatureFlagEventTriggerBuilder {
        private double goal = 1.0;
        private int type = 11;
        private String flagName;

        private FeatureFlagEventTriggerBuilder() {
        }

        @NonNull
        public FeatureFlagEventTriggerBuilder setCountGoal(double goal) {
            this.type = 11;
            this.goal = goal;
            return this;
        }

        @NonNull
        public FeatureFlagEventTriggerBuilder setValueGoal(double goal) {
            this.type = 11;
            this.goal = goal;
            return this;
        }

        @NonNull
        public FeatureFlagEventTriggerBuilder setFeatureFlagName(@Nullable String flagName) {
            this.flagName = flagName;
            return this;
        }

        @NonNull
        public Trigger build() {
            if (UAStringUtil.isEmpty((String)this.flagName)) {
                return new Trigger(this.type, this.goal, null);
            }
            JsonPredicate predicate = JsonPredicate.newBuilder().setPredicateType("and").addMatcher(JsonMatcher.newBuilder().setKey("flag_name").setValueMatcher(ValueMatcher.newValueMatcher((JsonValue)JsonValue.wrap((String)this.flagName))).build()).build();
            return new Trigger(this.type, this.goal, predicate);
        }
    }

    public static class VersionTriggerBuilder {
        private double goal = 1.0;
        private final ValueMatcher versionMatcher;

        private VersionTriggerBuilder(@Nullable ValueMatcher versionMatcher) {
            this.versionMatcher = versionMatcher;
        }

        @NonNull
        public VersionTriggerBuilder setGoal(double goal) {
            this.goal = goal;
            return this;
        }

        @NonNull
        public Trigger build() {
            JsonPredicate predicate = null;
            if (this.versionMatcher != null) {
                predicate = VersionUtils.createVersionPredicate((ValueMatcher)this.versionMatcher);
            }
            return new Trigger(10, this.goal, predicate);
        }
    }

    public static class ActiveSessionTriggerBuilder {
        private double goal = 1.0;

        private ActiveSessionTriggerBuilder() {
        }

        @NonNull
        public ActiveSessionTriggerBuilder setGoal(double goal) {
            this.goal = goal;
            return this;
        }

        @NonNull
        public Trigger build() {
            return new Trigger(9, this.goal, null);
        }
    }

    public static class CustomEventTriggerBuilder {
        private double goal = 1.0;
        private int type = 5;
        private String eventName;

        private CustomEventTriggerBuilder() {
        }

        @NonNull
        public CustomEventTriggerBuilder setCountGoal(double goal) {
            this.type = 5;
            this.goal = goal;
            return this;
        }

        @NonNull
        public CustomEventTriggerBuilder setValueGoal(double goal) {
            this.type = 6;
            this.goal = goal;
            return this;
        }

        @NonNull
        public CustomEventTriggerBuilder setEventName(@Nullable String eventName) {
            this.eventName = eventName;
            return this;
        }

        @NonNull
        public Trigger build() {
            if (UAStringUtil.isEmpty((String)this.eventName)) {
                return new Trigger(this.type, this.goal, null);
            }
            JsonPredicate predicate = JsonPredicate.newBuilder().setPredicateType("and").addMatcher(JsonMatcher.newBuilder().setKey("event_name").setValueMatcher(ValueMatcher.newValueMatcher((JsonValue)JsonValue.wrap((String)this.eventName))).build()).build();
            return new Trigger(this.type, this.goal, predicate);
        }
    }

    public static class ScreenTriggerBuilder {
        private double goal = 1.0;
        private String screenName;

        private ScreenTriggerBuilder() {
        }

        @NonNull
        public ScreenTriggerBuilder setGoal(double goal) {
            this.goal = goal;
            return this;
        }

        @NonNull
        public ScreenTriggerBuilder setScreenName(@Nullable String screenName) {
            this.screenName = screenName;
            return this;
        }

        @NonNull
        public Trigger build() {
            JsonPredicate predicate = UAStringUtil.isEmpty((String)this.screenName) ? null : JsonPredicate.newBuilder().addMatcher(JsonMatcher.newBuilder().setValueMatcher(ValueMatcher.newValueMatcher((JsonValue)JsonValue.wrap((String)this.screenName))).build()).build();
            return new Trigger(7, this.goal, predicate);
        }
    }

    public static class RegionTriggerBuilder {
        private final int type;
        private double goal = 1.0;
        private String regionId;

        private RegionTriggerBuilder(int type) {
            this.type = type;
        }

        @NonNull
        public RegionTriggerBuilder setGoal(double goal) {
            this.goal = goal;
            return this;
        }

        @NonNull
        public RegionTriggerBuilder setRegionId(@Nullable String regionId) {
            this.regionId = regionId;
            return this;
        }

        @NonNull
        public Trigger build() {
            JsonPredicate predicate = UAStringUtil.isEmpty((String)this.regionId) ? null : JsonPredicate.newBuilder().addMatcher(JsonMatcher.newBuilder().setKey("region_id").setValueMatcher(ValueMatcher.newValueMatcher((JsonValue)JsonValue.wrap((String)this.regionId))).build()).build();
            return new Trigger(this.type, this.goal, predicate);
        }
    }

    public static class LifeCycleTriggerBuilder {
        private double goal = 1.0;
        private final int type;

        private LifeCycleTriggerBuilder(int type) {
            this.type = type;
        }

        @NonNull
        public LifeCycleTriggerBuilder setGoal(double goal) {
            this.goal = goal;
            return this;
        }

        @NonNull
        public Trigger build() {
            return new Trigger(this.type, this.goal, null);
        }
    }
}

