/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.actions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.util.HashMap;
import java.util.Map;

public class Actions
implements ScheduleData {
    private final JsonMap actions;

    public Actions(@NonNull JsonMap actions) {
        this.actions = actions;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return this.actions.toJsonValue();
    }

    public JsonMap getActionsMap() {
        return this.actions;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Actions actions1 = (Actions)o;
        return this.actions.equals((Object)actions1.actions);
    }

    public int hashCode() {
        return this.actions.hashCode();
    }

    public static class Builder {
        private Map<String, JsonSerializable> actions = new HashMap<String, JsonSerializable>();

        private Builder() {
        }

        @NonNull
        public Builder addAction(@NonNull String action, @NonNull JsonSerializable actionValue) {
            this.actions.put(action, actionValue);
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String action, @NonNull String actionValue) {
            this.actions.put(action, (JsonSerializable)JsonValue.wrap((String)actionValue));
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String action, long actionValue) {
            this.actions.put(action, (JsonSerializable)JsonValue.wrap((long)actionValue));
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String action, double actionValue) {
            this.actions.put(action, (JsonSerializable)JsonValue.wrap((double)actionValue));
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String action, boolean actionValue) {
            this.actions.put(action, (JsonSerializable)JsonValue.wrap((boolean)actionValue));
            return this;
        }

        @NonNull
        public Actions build() {
            return new Actions(JsonValue.wrapOpt(this.actions).optMap());
        }
    }
}

