/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.actions;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.actions.Action;
import com.urbanairship.actions.ActionArguments;
import com.urbanairship.actions.ActionResult;
import com.urbanairship.automation.InAppAutomation;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.AirshipComponentUtils;
import java.util.concurrent.Callable;

public class CancelSchedulesAction
extends Action {
    @NonNull
    public static final String DEFAULT_REGISTRY_NAME = "cancel_scheduled_actions";
    @NonNull
    public static final String DEFAULT_REGISTRY_SHORT_NAME = "^csa";
    @NonNull
    public static final String GROUPS = "groups";
    @NonNull
    public static final String IDS = "ids";
    @NonNull
    public static final String ALL = "all";
    private final Callable<InAppAutomation> actionAutomationCallable;

    public CancelSchedulesAction() {
        this(AirshipComponentUtils.callableForComponent(InAppAutomation.class));
    }

    @VisibleForTesting
    CancelSchedulesAction(@NonNull Callable<InAppAutomation> actionAutomationCallable) {
        this.actionAutomationCallable = actionAutomationCallable;
    }

    public boolean acceptsArguments(@NonNull ActionArguments arguments) {
        switch (arguments.getSituation()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                if (arguments.getValue().toJsonValue().isString()) {
                    return ALL.equalsIgnoreCase(arguments.getValue().getString());
                }
                return arguments.getValue().toJsonValue().isJsonMap();
            }
        }
        return false;
    }

    @NonNull
    public ActionResult perform(@NonNull ActionArguments arguments) {
        InAppAutomation automation;
        try {
            automation = this.actionAutomationCallable.call();
        }
        catch (Exception e) {
            return ActionResult.newErrorResult((Exception)e);
        }
        JsonValue jsonValue = arguments.getValue().toJsonValue();
        if (jsonValue.isString() && ALL.equalsIgnoreCase(jsonValue.getString())) {
            automation.cancelSchedules("actions");
            return ActionResult.newEmptyResult();
        }
        JsonValue groupsJson = jsonValue.optMap().opt(GROUPS);
        if (groupsJson.isString()) {
            automation.cancelScheduleGroup(groupsJson.optString());
        } else if (groupsJson.isJsonList()) {
            for (JsonValue value : groupsJson.optList()) {
                if (!value.isString()) continue;
                automation.cancelScheduleGroup(value.optString());
            }
        }
        JsonValue idsJson = jsonValue.optMap().opt(IDS);
        if (idsJson.isString()) {
            automation.cancelSchedule(idsJson.optString());
        } else if (idsJson.isJsonList()) {
            for (JsonValue value : idsJson.optList()) {
                if (!value.isString()) continue;
                automation.cancelSchedule(value.optString());
            }
        }
        return ActionResult.newEmptyResult();
    }
}

