/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.actions;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.actions.Action;
import com.urbanairship.actions.ActionArguments;
import com.urbanairship.actions.ActionResult;
import com.urbanairship.actions.ActionValue;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.InAppAutomation;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.ScheduleDelay;
import com.urbanairship.automation.Trigger;
import com.urbanairship.automation.actions.Actions;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.AirshipComponentUtils;
import com.urbanairship.util.DateUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class ScheduleAction
extends Action {
    @NonNull
    public static final String DEFAULT_REGISTRY_NAME = "schedule_actions";
    @NonNull
    public static final String DEFAULT_REGISTRY_SHORT_NAME = "^sa";
    private static final String ACTIONS_KEY = "actions";
    private static final String LIMIT_KEY = "limit";
    private static final String PRIORITY_KEY = "priority";
    private static final String GROUP_KEY = "group";
    private static final String END_KEY = "end";
    private static final String START_KEY = "start";
    private static final String DELAY_KEY = "delay";
    private static final String TRIGGERS_KEY = "triggers";
    private static final String INTERVAL_KEY = "interval";
    private static final String AUDIENCE_KEY = "audience";
    private final Callable<InAppAutomation> actionAutomationCallable;

    public ScheduleAction() {
        this(AirshipComponentUtils.callableForComponent(InAppAutomation.class));
    }

    @VisibleForTesting
    ScheduleAction(@NonNull Callable<InAppAutomation> actionAutomationCallable) {
        this.actionAutomationCallable = actionAutomationCallable;
    }

    public boolean acceptsArguments(@NonNull ActionArguments arguments) {
        switch (arguments.getSituation()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                return arguments.getValue().toJsonValue().isJsonMap();
            }
        }
        return false;
    }

    @NonNull
    public ActionResult perform(@NonNull ActionArguments arguments) {
        InAppAutomation automation;
        try {
            automation = this.actionAutomationCallable.call();
        }
        catch (Exception e) {
            return ActionResult.newErrorResult((Exception)e);
        }
        try {
            Schedule<Actions> schedule = this.parseSchedule(arguments.getValue().toJsonValue());
            Boolean result = (Boolean)automation.schedule(schedule).get();
            return result != null && result != false ? ActionResult.newResult((ActionValue)ActionValue.wrap((String)schedule.getId())) : ActionResult.newEmptyResult();
        }
        catch (JsonException | InterruptedException | ExecutionException e) {
            return ActionResult.newErrorResult((Exception)e);
        }
    }

    @NonNull
    Schedule<Actions> parseSchedule(@NonNull JsonValue value) throws JsonException {
        JsonValue audienceJson;
        JsonMap jsonMap = value.optMap();
        Schedule.Builder<Actions> builder = Schedule.newBuilder(new Actions(jsonMap.opt(ACTIONS_KEY).optMap())).setLimit(jsonMap.opt(LIMIT_KEY).getInt(1)).setPriority(jsonMap.opt(PRIORITY_KEY).getInt(0)).setGroup(jsonMap.opt(GROUP_KEY).getString());
        if (jsonMap.containsKey(END_KEY)) {
            builder.setEnd(DateUtils.parseIso8601((String)jsonMap.opt(END_KEY).optString(), (long)-1L));
        }
        if (jsonMap.containsKey(START_KEY)) {
            builder.setStart(DateUtils.parseIso8601((String)jsonMap.opt(START_KEY).optString(), (long)-1L));
        }
        for (JsonValue triggerJson : jsonMap.opt(TRIGGERS_KEY).optList()) {
            builder.addTrigger(Trigger.fromJson(triggerJson));
        }
        if (jsonMap.containsKey(DELAY_KEY)) {
            builder.setDelay(ScheduleDelay.fromJson(jsonMap.opt(DELAY_KEY)));
        }
        if (jsonMap.containsKey(INTERVAL_KEY)) {
            builder.setInterval(jsonMap.opt(INTERVAL_KEY).getLong(0L), TimeUnit.SECONDS);
        }
        if ((audienceJson = jsonMap.opt(AUDIENCE_KEY).optMap().get(AUDIENCE_KEY)) != null) {
            builder.setAudience(AudienceSelector.Companion.fromJson(audienceJson));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid schedule info", (Throwable)e);
        }
    }
}

