/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.alarms;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.UALog;
import com.urbanairship.automation.alarms.AlarmOperationReceiver;
import com.urbanairship.automation.alarms.OperationScheduler;
import com.urbanairship.util.Clock;
import com.urbanairship.util.PendingIntentCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AlarmOperationScheduler
implements OperationScheduler {
    private final Comparator<PendingOperation> OPERATION_COMPARATOR = new Comparator<PendingOperation>(){

        @Override
        public int compare(PendingOperation lhs, PendingOperation rhs) {
            return Long.valueOf(lhs.scheduledTime).compareTo(rhs.scheduledTime);
        }
    };
    private final List<PendingOperation> pendingOperations = new ArrayList<PendingOperation>();
    private final Clock clock;
    private final AlarmManagerDelegate delegate;
    private final Context context;
    @SuppressLint(value={"StaticFieldLeak"})
    private static AlarmOperationScheduler shared;

    AlarmOperationScheduler(final @NonNull Context context) {
        this(context, Clock.DEFAULT_CLOCK, new AlarmManagerDelegate(){

            @Override
            public void onSchedule(long realTimeMilliseconds, @NonNull PendingIntent pendingIntent) {
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                if (alarmManager == null) {
                    throw new IllegalStateException("AlarmManager unavailable");
                }
                alarmManager.set(3, realTimeMilliseconds, pendingIntent);
            }
        });
    }

    @VisibleForTesting
    AlarmOperationScheduler(@NonNull Context context, @NonNull Clock clock, @NonNull AlarmManagerDelegate delegate) {
        this.context = context;
        this.clock = clock;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static AlarmOperationScheduler shared(@NonNull Context context) {
        Class<AlarmOperationScheduler> clazz = AlarmOperationScheduler.class;
        synchronized (AlarmOperationScheduler.class) {
            if (shared == null) {
                shared = new AlarmOperationScheduler(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return shared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(long delay, @NonNull Runnable operation) {
        long time = this.clock.elapsedRealtime() + delay;
        PendingOperation pendingOperation = new PendingOperation(time, operation);
        UALog.v((String)"Operation scheduled with %d delay", (Object[])new Object[]{delay});
        List<PendingOperation> list = this.pendingOperations;
        synchronized (list) {
            this.pendingOperations.add(pendingOperation);
            Collections.sort(this.pendingOperations, this.OPERATION_COMPARATOR);
            this.scheduleAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAlarmFired() {
        UALog.v((String)"Alarm fired", (Object[])new Object[0]);
        long time = this.clock.elapsedRealtime();
        List<PendingOperation> list = this.pendingOperations;
        synchronized (list) {
            ArrayList<PendingOperation> copy = new ArrayList<PendingOperation>(this.pendingOperations);
            for (PendingOperation pendingOperation : copy) {
                if (pendingOperation.scheduledTime > time) continue;
                pendingOperation.operation.run();
                this.pendingOperations.remove(pendingOperation);
            }
            this.scheduleAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAlarm() {
        long nextScheduleTime;
        List<PendingOperation> list = this.pendingOperations;
        synchronized (list) {
            if (this.pendingOperations.isEmpty()) {
                return;
            }
            nextScheduleTime = this.pendingOperations.get((int)0).scheduledTime;
        }
        Intent intent = new Intent(this.context, AlarmOperationReceiver.class).setAction("com.urbanairship.automation.alarms.ALARM_FIRED");
        PendingIntent pendingIntent = PendingIntentCompat.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
        try {
            this.delegate.onSchedule(nextScheduleTime, pendingIntent);
            UALog.v((String)"Next alarm set %d", (Object[])new Object[]{nextScheduleTime - this.clock.elapsedRealtime()});
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"AlarmOperationScheduler - Failed to schedule alarm.", (Object[])new Object[0]);
        }
    }

    private static class PendingOperation {
        final Runnable operation;
        final long scheduledTime;

        PendingOperation(long scheduledTime, @NonNull Runnable operation) {
            this.operation = operation;
            this.scheduledTime = scheduledTime;
        }
    }

    static interface AlarmManagerDelegate {
        public void onSchedule(long var1, @NonNull PendingIntent var3);
    }
}

