/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.deferred;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Deferred
implements ScheduleData {
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String TYPE_IN_APP_MESSAGE = "in_app_message";
    private static final String URL_KEY = "url";
    private static final String RETRY_ON_TIMEOUT = "retry_on_timeout";
    private static final String TYPE = "type";
    private final Uri url;
    private final boolean retryOnTimeout;
    private final String type;

    public Deferred(@NonNull Uri url, boolean retryOnTimeout) {
        this(url, retryOnTimeout, null);
    }

    public Deferred(@NonNull Uri url, boolean retryOnTimeout, @Nullable String type) {
        this.url = url;
        this.retryOnTimeout = retryOnTimeout;
        this.type = type;
    }

    @NonNull
    public Uri getUrl() {
        return this.url;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public boolean getRetryOnTimeout() {
        return this.retryOnTimeout;
    }

    public boolean isRetriableOnTimeout() {
        return this.retryOnTimeout;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(URL_KEY, this.url.toString()).put(RETRY_ON_TIMEOUT, this.retryOnTimeout).put(TYPE, this.type).build().toJsonValue();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Deferred fromJson(@NonNull JsonValue jsonValue) throws JsonException {
        String urlString = jsonValue.optMap().opt(URL_KEY).getString();
        if (urlString == null) {
            throw new JsonException("Missing URL");
        }
        String type = jsonValue.optMap().opt(TYPE).getString();
        Uri uri = Uri.parse((String)urlString);
        boolean retryOnTimeout = jsonValue.optMap().opt(RETRY_ON_TIMEOUT).getBoolean(true);
        return new Deferred(uri, retryOnTimeout, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deferred deferred = (Deferred)o;
        if (this.retryOnTimeout != deferred.retryOnTimeout) {
            return false;
        }
        if (!this.url.equals((Object)deferred.url)) {
            return false;
        }
        return this.type != null ? this.type.equals(deferred.type) : deferred.type == null;
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + (this.retryOnTimeout ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Type {
    }
}

