/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.limits;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.util.Checks;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FrequencyConstraint {
    private final String id;
    private final long range;
    private final int count;

    private FrequencyConstraint(Builder builder) {
        this.id = builder.id;
        this.range = builder.range;
        this.count = builder.count;
    }

    public long getRange() {
        return this.range;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyConstraint that = (FrequencyConstraint)o;
        if (this.range != that.range) {
            return false;
        }
        if (this.count != that.count) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (int)(this.range ^ this.range >>> 32);
        result = 31 * result + this.count;
        return result;
    }

    public String toString() {
        return "FrequencyConstraint{id='" + this.id + '\'' + ", range=" + this.range + ", count=" + this.count + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private long range;
        private int count;

        private Builder() {
        }

        @NonNull
        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder setRange(@NonNull TimeUnit unit, long duration) {
            this.range = unit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder setCount(int count) {
            this.count = count;
            return this;
        }

        @NonNull
        public FrequencyConstraint build() {
            Checks.checkNotNull((Object)this.id, (String)"missing id");
            Checks.checkArgument((this.range > 0L ? 1 : 0) != 0, (String)"missing range");
            Checks.checkArgument((this.count > 0 ? 1 : 0) != 0, (String)"missing count");
            return new FrequencyConstraint(this);
        }
    }
}

