/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.limits;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.AirshipExecutors;
import com.urbanairship.PendingResult;
import com.urbanairship.UALog;
import com.urbanairship.automation.limits.FrequencyChecker;
import com.urbanairship.automation.limits.FrequencyConstraint;
import com.urbanairship.automation.limits.storage.ConstraintEntity;
import com.urbanairship.automation.limits.storage.FrequencyLimitDao;
import com.urbanairship.automation.limits.storage.FrequencyLimitDatabase;
import com.urbanairship.automation.limits.storage.OccurrenceEntity;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.util.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FrequencyLimitManager {
    private final Map<String, List<OccurrenceEntity>> occurrencesMap = new HashMap<String, List<OccurrenceEntity>>();
    private final Map<String, ConstraintEntity> constraintEntityMap = new HashMap<String, ConstraintEntity>();
    private final List<OccurrenceEntity> pendingOccurrences = new ArrayList<OccurrenceEntity>();
    private final Clock clock;
    private final Object lock = new Object();
    private final FrequencyLimitDao dao;
    private final Executor executor;

    public FrequencyLimitManager(@NonNull Context context, @NonNull AirshipRuntimeConfig config) {
        this(FrequencyLimitDatabase.createDatabase(context, config).getDao(), Clock.DEFAULT_CLOCK, AirshipExecutors.newSerialExecutor());
    }

    @VisibleForTesting
    FrequencyLimitManager(@NonNull FrequencyLimitDao dao, @NonNull Clock clock, @NonNull Executor executor) {
        this.dao = dao;
        this.clock = clock;
        this.executor = executor;
    }

    @NonNull
    public Future<FrequencyChecker> getFrequencyChecker(final @NonNull Collection<String> constraintIds) {
        PendingResult pendingResult = new PendingResult();
        this.executor.execute(() -> {
            for (String constraintId : constraintIds) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.constraintEntityMap.containsKey(constraintId)) {
                        continue;
                    }
                }
                List<OccurrenceEntity> occurrenceEntities = this.dao.getOccurrences(constraintId);
                List<ConstraintEntity> constraintEntities = this.dao.getConstraints(Collections.singletonList(constraintId));
                if (constraintEntities.size() != 1) {
                    pendingResult.setResult(null);
                    return;
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    this.constraintEntityMap.put(constraintId, constraintEntities.get(0));
                    this.occurrencesMap.put(constraintId, occurrenceEntities);
                }
            }
            pendingResult.setResult((Object)new FrequencyChecker(){

                @Override
                public boolean isOverLimit() {
                    return FrequencyLimitManager.this.isOverLimit(constraintIds);
                }

                @Override
                public boolean checkAndIncrement() {
                    return FrequencyLimitManager.this.checkAndIncrement(constraintIds);
                }
            });
        });
        return pendingResult;
    }

    public Future<Boolean> updateConstraints(@NonNull Collection<FrequencyConstraint> constraints) {
        PendingResult pendingResult = new PendingResult();
        this.executor.execute(() -> {
            try {
                List<ConstraintEntity> constraintEntities = this.dao.getConstraints();
                HashMap<String, ConstraintEntity> entityMap = new HashMap<String, ConstraintEntity>();
                for (ConstraintEntity entity : constraintEntities) {
                    entityMap.put(entity.constraintId, entity);
                }
                for (FrequencyConstraint constraint : constraints) {
                    ConstraintEntity entity = new ConstraintEntity();
                    entity.constraintId = constraint.getId();
                    entity.count = constraint.getCount();
                    entity.range = constraint.getRange();
                    ConstraintEntity existing = (ConstraintEntity)entityMap.remove(constraint.getId());
                    if (existing != null) {
                        Object object;
                        if (existing.range != entity.range) {
                            this.dao.delete(existing);
                            this.dao.insert(entity);
                            object = this.lock;
                            synchronized (object) {
                                this.occurrencesMap.put(constraint.getId(), new ArrayList());
                                if (entityMap.containsKey(constraint.getId())) {
                                    this.constraintEntityMap.put(constraint.getId(), entity);
                                }
                                continue;
                            }
                        }
                        this.dao.update(entity);
                        object = this.lock;
                        synchronized (object) {
                            if (entityMap.containsKey(constraint.getId())) {
                                this.constraintEntityMap.put(constraint.getId(), entity);
                            }
                            continue;
                        }
                    }
                    this.dao.insert(entity);
                }
                this.dao.delete(entityMap.keySet());
                pendingResult.setResult((Object)true);
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"Failed to update constraints", (Object[])new Object[0]);
                pendingResult.setResult((Object)false);
            }
        });
        return pendingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndIncrement(@NonNull Collection<String> constraintIds) {
        if (constraintIds.isEmpty()) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isOverLimit(constraintIds)) {
                return false;
            }
            this.recordOccurrence(constraintIds);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOverLimit(@NonNull Collection<String> constraintIds) {
        if (constraintIds.isEmpty()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            for (String constraintId : constraintIds) {
                if (!this.isConstraintOverLimit(constraintId)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordOccurrence(@NonNull Collection<String> constraintIds) {
        if (constraintIds.isEmpty()) {
            return;
        }
        long timeMillis = this.clock.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            for (String id : constraintIds) {
                OccurrenceEntity occurrence = new OccurrenceEntity();
                occurrence.parentConstraintId = id;
                occurrence.timeStamp = timeMillis;
                this.pendingOccurrences.add(occurrence);
                if (this.occurrencesMap.get(id) == null) {
                    this.occurrencesMap.put(id, new ArrayList());
                }
                this.occurrencesMap.get(id).add(occurrence);
            }
        }
        this.executor.execute(this::writePendingOccurrences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingOccurrences() {
        ArrayList<OccurrenceEntity> pending;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            pending = new ArrayList<OccurrenceEntity>(this.pendingOccurrences);
            this.pendingOccurrences.clear();
        }
        for (OccurrenceEntity occurrence : pending) {
            try {
                this.dao.insert(occurrence);
            }
            catch (SQLiteException e) {
                UALog.v((Throwable)e);
                Object object = this.lock;
                synchronized (object) {
                    this.pendingOccurrences.add(occurrence);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConstraintOverLimit(@NonNull String constraintId) {
        Object object = this.lock;
        synchronized (object) {
            List<OccurrenceEntity> occurrences = this.occurrencesMap.get(constraintId);
            ConstraintEntity constraint = this.constraintEntityMap.get(constraintId);
            if (constraint == null || occurrences == null || occurrences.size() < constraint.count) {
                return false;
            }
            Collections.sort(occurrences, new OccurrenceEntity.Comparator());
            long timeSinceOccurrence = this.clock.currentTimeMillis() - occurrences.get((int)(occurrences.size() - constraint.count)).timeStamp;
            return timeSinceOccurrence <= constraint.range;
        }
    }
}

