/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.limits.storage;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.urbanairship.automation.limits.storage.ConstraintEntity;
import com.urbanairship.automation.limits.storage.FrequencyLimitDao;
import com.urbanairship.automation.limits.storage.OccurrenceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FrequencyLimitDao_Impl
implements FrequencyLimitDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ConstraintEntity> __insertionAdapterOfConstraintEntity;
    private final EntityInsertionAdapter<OccurrenceEntity> __insertionAdapterOfOccurrenceEntity;
    private final EntityDeletionOrUpdateAdapter<ConstraintEntity> __deletionAdapterOfConstraintEntity;
    private final EntityDeletionOrUpdateAdapter<ConstraintEntity> __updateAdapterOfConstraintEntity;

    public FrequencyLimitDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfConstraintEntity = new EntityInsertionAdapter<ConstraintEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `constraints` (`id`,`constraintId`,`count`,`range`) VALUES (nullif(?, 0),?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ConstraintEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.constraintId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.constraintId);
                }
                stmt.bindLong(3, (long)value.count);
                stmt.bindLong(4, value.range);
            }
        };
        this.__insertionAdapterOfOccurrenceEntity = new EntityInsertionAdapter<OccurrenceEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `occurrences` (`id`,`parentConstraintId`,`timeStamp`) VALUES (nullif(?, 0),?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OccurrenceEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.parentConstraintId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.parentConstraintId);
                }
                stmt.bindLong(3, value.timeStamp);
            }
        };
        this.__deletionAdapterOfConstraintEntity = new EntityDeletionOrUpdateAdapter<ConstraintEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `constraints` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ConstraintEntity value) {
                stmt.bindLong(1, (long)value.id);
            }
        };
        this.__updateAdapterOfConstraintEntity = new EntityDeletionOrUpdateAdapter<ConstraintEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `constraints` SET `id` = ?,`constraintId` = ?,`count` = ?,`range` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ConstraintEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.constraintId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.constraintId);
                }
                stmt.bindLong(3, (long)value.count);
                stmt.bindLong(4, value.range);
                stmt.bindLong(5, (long)value.id);
            }
        };
    }

    @Override
    public void insert(ConstraintEntity constraint) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfConstraintEntity.insert((Object)constraint);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(OccurrenceEntity occurrence) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfOccurrenceEntity.insert((Object)occurrence);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ConstraintEntity entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfConstraintEntity.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ConstraintEntity constraint) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfConstraintEntity.handle((Object)constraint);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConstraintEntity> getConstraints(Collection<String> constraintIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM constraints WHERE (constraintId IN (");
        int _inputSize = constraintIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : constraintIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfConstraintId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"constraintId");
            int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
            int _cursorIndexOfRange = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"range");
            ArrayList<ConstraintEntity> _result = new ArrayList<ConstraintEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ConstraintEntity _item_1 = new ConstraintEntity();
                _item_1.id = _cursor.getInt(_cursorIndexOfId);
                _item_1.constraintId = _cursor.isNull(_cursorIndexOfConstraintId) ? null : _cursor.getString(_cursorIndexOfConstraintId);
                _item_1.count = _cursor.getInt(_cursorIndexOfCount);
                _item_1.range = _cursor.getLong(_cursorIndexOfRange);
                _result.add(_item_1);
            }
            ArrayList<ConstraintEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConstraintEntity> getConstraints() {
        String _sql = "SELECT * FROM constraints";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM constraints", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfConstraintId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"constraintId");
            int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
            int _cursorIndexOfRange = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"range");
            ArrayList<ConstraintEntity> _result = new ArrayList<ConstraintEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ConstraintEntity _item = new ConstraintEntity();
                _item.id = _cursor.getInt(_cursorIndexOfId);
                _item.constraintId = _cursor.isNull(_cursorIndexOfConstraintId) ? null : _cursor.getString(_cursorIndexOfConstraintId);
                _item.count = _cursor.getInt(_cursorIndexOfCount);
                _item.range = _cursor.getLong(_cursorIndexOfRange);
                _result.add(_item);
            }
            ArrayList<ConstraintEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OccurrenceEntity> getOccurrences(String constraintId) {
        String _sql = "SELECT * FROM occurrences WHERE parentConstraintId = ? ORDER BY timeStamp ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM occurrences WHERE parentConstraintId = ? ORDER BY timeStamp ASC", (int)1);
        int _argIndex = 1;
        if (constraintId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, constraintId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfParentConstraintId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentConstraintId");
            int _cursorIndexOfTimeStamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeStamp");
            ArrayList<OccurrenceEntity> _result = new ArrayList<OccurrenceEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OccurrenceEntity _item = new OccurrenceEntity();
                _item.id = _cursor.getInt(_cursorIndexOfId);
                _item.parentConstraintId = _cursor.isNull(_cursorIndexOfParentConstraintId) ? null : _cursor.getString(_cursorIndexOfParentConstraintId);
                _item.timeStamp = _cursor.getLong(_cursorIndexOfTimeStamp);
                _result.add(_item);
            }
            ArrayList<OccurrenceEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Collection<String> constraintIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM constraints WHERE (constraintId IN (");
        int _inputSize = constraintIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : constraintIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

