/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.limits.storage;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.urbanairship.automation.limits.storage.FrequencyLimitDao;
import com.urbanairship.automation.limits.storage.FrequencyLimitDao_Impl;
import com.urbanairship.automation.limits.storage.FrequencyLimitDatabase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FrequencyLimitDatabase_Impl
extends FrequencyLimitDatabase {
    private volatile FrequencyLimitDao _frequencyLimitDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `constraints` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `constraintId` TEXT, `count` INTEGER NOT NULL, `range` INTEGER NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_constraints_constraintId` ON `constraints` (`constraintId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `occurrences` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `parentConstraintId` TEXT, `timeStamp` INTEGER NOT NULL, FOREIGN KEY(`parentConstraintId`) REFERENCES `constraints`(`constraintId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_occurrences_parentConstraintId` ON `occurrences` (`parentConstraintId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '35dc8997e1e42159a519f7f02410cda8')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `constraints`");
                _db.execSQL("DROP TABLE IF EXISTS `occurrences`");
                if (FrequencyLimitDatabase_Impl.this.mCallbacks != null) {
                    int _size = FrequencyLimitDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)FrequencyLimitDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (FrequencyLimitDatabase_Impl.this.mCallbacks != null) {
                    int _size = FrequencyLimitDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)FrequencyLimitDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                FrequencyLimitDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                FrequencyLimitDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (FrequencyLimitDatabase_Impl.this.mCallbacks != null) {
                    int _size = FrequencyLimitDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)FrequencyLimitDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsConstraints = new HashMap<String, TableInfo.Column>(4);
                _columnsConstraints.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsConstraints.put("constraintId", new TableInfo.Column("constraintId", "TEXT", false, 0, null, 1));
                _columnsConstraints.put("count", new TableInfo.Column("count", "INTEGER", true, 0, null, 1));
                _columnsConstraints.put("range", new TableInfo.Column("range", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysConstraints = new HashSet(0);
                HashSet<TableInfo.Index> _indicesConstraints = new HashSet<TableInfo.Index>(1);
                _indicesConstraints.add(new TableInfo.Index("index_constraints_constraintId", true, Arrays.asList("constraintId"), Arrays.asList("ASC")));
                TableInfo _infoConstraints = new TableInfo("constraints", _columnsConstraints, _foreignKeysConstraints, _indicesConstraints);
                TableInfo _existingConstraints = TableInfo.read((SupportSQLiteDatabase)_db, (String)"constraints");
                if (!_infoConstraints.equals((Object)_existingConstraints)) {
                    return new RoomOpenHelper.ValidationResult(false, "constraints(com.urbanairship.automation.limits.storage.ConstraintEntity).\n Expected:\n" + _infoConstraints + "\n Found:\n" + _existingConstraints);
                }
                HashMap<String, TableInfo.Column> _columnsOccurrences = new HashMap<String, TableInfo.Column>(3);
                _columnsOccurrences.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsOccurrences.put("parentConstraintId", new TableInfo.Column("parentConstraintId", "TEXT", false, 0, null, 1));
                _columnsOccurrences.put("timeStamp", new TableInfo.Column("timeStamp", "INTEGER", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysOccurrences = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOccurrences.add(new TableInfo.ForeignKey("constraints", "CASCADE", "NO ACTION", Arrays.asList("parentConstraintId"), Arrays.asList("constraintId")));
                HashSet<TableInfo.Index> _indicesOccurrences = new HashSet<TableInfo.Index>(1);
                _indicesOccurrences.add(new TableInfo.Index("index_occurrences_parentConstraintId", false, Arrays.asList("parentConstraintId"), Arrays.asList("ASC")));
                TableInfo _infoOccurrences = new TableInfo("occurrences", _columnsOccurrences, _foreignKeysOccurrences, _indicesOccurrences);
                TableInfo _existingOccurrences = TableInfo.read((SupportSQLiteDatabase)_db, (String)"occurrences");
                if (!_infoOccurrences.equals((Object)_existingOccurrences)) {
                    return new RoomOpenHelper.ValidationResult(false, "occurrences(com.urbanairship.automation.limits.storage.OccurrenceEntity).\n Expected:\n" + _infoOccurrences + "\n Found:\n" + _existingOccurrences);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "35dc8997e1e42159a519f7f02410cda8", "400933b7a06a2d0cdaabbefb93b3eecc");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"constraints", "occurrences"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `constraints`");
            _db.execSQL("DELETE FROM `occurrences`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(FrequencyLimitDao.class, FrequencyLimitDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrequencyLimitDao getDao() {
        if (this._frequencyLimitDao != null) {
            return this._frequencyLimitDao;
        }
        FrequencyLimitDatabase_Impl frequencyLimitDatabase_Impl = this;
        synchronized (frequencyLimitDatabase_Impl) {
            if (this._frequencyLimitDao == null) {
                this._frequencyLimitDao = new FrequencyLimitDao_Impl(this);
            }
            return this._frequencyLimitDao;
        }
    }
}

