/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Dao
public abstract class AutomationDao {
    @Transaction
    @Insert(onConflict=1)
    public abstract void insert(@NonNull ScheduleEntity var1, @NonNull List<TriggerEntity> var2);

    @Transaction
    @Update
    public abstract void update(@NonNull ScheduleEntity var1, @NonNull List<TriggerEntity> var2);

    @Transaction
    @Update
    public abstract void updateTriggers(@NonNull List<TriggerEntity> var1);

    @Delete
    public abstract void delete(@NonNull ScheduleEntity var1);

    @Query(value="SELECT COUNT(*) FROM schedules")
    public abstract int getScheduleCount();

    @Transaction
    @Query(value="SELECT * FROM schedules")
    @NonNull
    public abstract List<FullSchedule> getSchedules();

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (scheduleType = :type)")
    @NonNull
    public abstract List<FullSchedule> getSchedulesByType(@NonNull String var1);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (scheduleId == :scheduleId)")
    @Nullable
    public abstract FullSchedule getSchedule(@NonNull String var1);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (scheduleId == :scheduleId) AND (scheduleType = :type)")
    @Nullable
    public abstract FullSchedule getSchedule(@NonNull String var1, @NonNull String var2);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (scheduleId IN (:scheduleIds))")
    @NonNull
    public abstract List<FullSchedule> getSchedules(@NonNull Collection<String> var1);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (scheduleId IN (:scheduleIds)) AND (scheduleType = :type)")
    @NonNull
    public abstract List<FullSchedule> getSchedules(@NonNull Collection<String> var1, @NonNull String var2);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (`group` == :group) AND (scheduleType = :type)")
    @NonNull
    public abstract List<FullSchedule> getSchedulesWithGroup(@NonNull String var1, @NonNull String var2);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (`group` == :group)")
    @NonNull
    public abstract List<FullSchedule> getSchedulesWithGroup(@NonNull String var1);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (executionState IN (:executionStates))")
    @NonNull
    public abstract List<FullSchedule> getSchedulesWithStates(int ... var1);

    @Transaction
    @Query(value="SELECT * FROM schedules WHERE (executionState != 4) AND (scheduleEnd >= 0) AND (scheduleEnd <= strftime('%s', 'now') * 1000)")
    @NonNull
    public abstract List<FullSchedule> getActiveExpiredSchedules();

    @Query(value="SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId WHERE (schedules.scheduleId = :scheduleId)AND (triggers.triggerType = :type) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)")
    @NonNull
    public abstract List<TriggerEntity> getActiveTriggers(int var1, @NonNull String var2);

    @Query(value="SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId AND (triggers.triggerType = :type) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)")
    @NonNull
    public abstract List<TriggerEntity> getActiveTriggers(int var1);

    @Transaction
    public void insert(@NonNull Collection<FullSchedule> entries) {
        for (FullSchedule entry : entries) {
            if (entry == null) continue;
            this.insert(entry);
        }
    }

    public void insert(@NonNull FullSchedule entry) {
        this.insert(entry.schedule, entry.triggers);
    }

    public void updateSchedules(@NonNull Collection<FullSchedule> entries) {
        for (FullSchedule entry : entries) {
            if (entry == null) continue;
            this.update(entry);
        }
    }

    public void update(@NonNull FullSchedule entry) {
        this.update(entry.schedule, entry.triggers);
    }

    public void delete(@NonNull FullSchedule entry) {
        this.delete(entry.schedule);
    }

    public void deleteSchedules(@NonNull Collection<FullSchedule> entries) {
        for (FullSchedule entry : entries) {
            if (entry == null) continue;
            this.delete(entry);
        }
    }
}

