/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.UALog;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AutomationDaoWrapper
extends AutomationDao {
    private final AutomationDao dao;

    public AutomationDaoWrapper(@NonNull AutomationDao dao) {
        this.dao = dao;
    }

    @Override
    public void insert(@NonNull ScheduleEntity entity, @NonNull List<TriggerEntity> entities) {
        try {
            this.dao.insert(entity, entities);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to insert schedule %s triggers %s", (Object[])new Object[]{entity, entities});
        }
    }

    @Override
    public void update(@NonNull ScheduleEntity entity, @NonNull List<TriggerEntity> entities) {
        try {
            this.dao.update(entity, entities);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to update schedule %s triggers %s", (Object[])new Object[]{entity, entities});
        }
    }

    @Override
    public void updateTriggers(@NonNull List<TriggerEntity> entities) {
        try {
            this.dao.updateTriggers(entities);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to update triggers %s", (Object[])new Object[]{entities});
        }
    }

    @Override
    public void delete(@NonNull ScheduleEntity entity) {
        try {
            this.dao.delete(entity);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to delete schedule %s", (Object[])new Object[]{entity});
        }
    }

    @Override
    public int getScheduleCount() {
        try {
            return this.dao.getScheduleCount();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedule count", (Object[])new Object[0]);
            return -1;
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedules() {
        try {
            return this.dao.getSchedules();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedulesByType(@NonNull String type) {
        try {
            return this.dao.getSchedulesByType(type);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules by type %s", (Object[])new Object[]{type});
            return Collections.emptyList();
        }
    }

    @Override
    @Nullable
    public FullSchedule getSchedule(@NonNull String scheduleId) {
        try {
            return this.dao.getSchedule(scheduleId);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedule with id %s", (Object[])new Object[]{scheduleId});
            return null;
        }
    }

    @Override
    @Nullable
    public FullSchedule getSchedule(@NonNull String scheduleId, @NonNull String type) {
        try {
            return this.dao.getSchedule(scheduleId, type);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedule with id %s type %s", (Object[])new Object[]{scheduleId, type});
            return null;
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedules(@NonNull Collection<String> scheduleIds) {
        try {
            return this.dao.getSchedules(scheduleIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules with ids %s", (Object[])new Object[]{scheduleIds});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedules(@NonNull Collection<String> scheduleIds, @NonNull String type) {
        try {
            return this.dao.getSchedules(scheduleIds, type);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules with ids %s type %s", (Object[])new Object[]{scheduleIds, type});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedulesWithGroup(@NonNull String group, @NonNull String type) {
        try {
            return this.dao.getSchedulesWithGroup(group, type);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules with group %s type %s", (Object[])new Object[]{group, type});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedulesWithGroup(@NonNull String group) {
        try {
            return this.dao.getSchedulesWithGroup(group);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules with group %s", (Object[])new Object[]{group});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getSchedulesWithStates(int ... executionStates) {
        try {
            return this.dao.getSchedulesWithStates(executionStates);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get schedules with state %s", (Object[])new Object[]{executionStates});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<FullSchedule> getActiveExpiredSchedules() {
        try {
            return this.dao.getActiveExpiredSchedules();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get active expired schedules", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<TriggerEntity> getActiveTriggers(int type, @NonNull String scheduleId) {
        try {
            return this.dao.getActiveTriggers(type, scheduleId);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get active triggers %s %s", (Object[])new Object[]{type, scheduleId});
            return Collections.emptyList();
        }
    }

    @Override
    @NonNull
    public List<TriggerEntity> getActiveTriggers(int type) {
        try {
            return this.dao.getActiveTriggers(type);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get active triggers %s", (Object[])new Object[]{type});
            return Collections.emptyList();
        }
    }
}

