/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.Converters;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import com.urbanairship.json.JsonTypeConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class AutomationDao_Impl
extends AutomationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ScheduleEntity> __insertionAdapterOfScheduleEntity;
    private final JsonTypeConverters __jsonTypeConverters = new JsonTypeConverters();
    private final Converters __converters = new Converters();
    private final EntityInsertionAdapter<TriggerEntity> __insertionAdapterOfTriggerEntity;
    private final EntityDeletionOrUpdateAdapter<ScheduleEntity> __deletionAdapterOfScheduleEntity;
    private final EntityDeletionOrUpdateAdapter<ScheduleEntity> __updateAdapterOfScheduleEntity;
    private final EntityDeletionOrUpdateAdapter<TriggerEntity> __updateAdapterOfTriggerEntity;

    public AutomationDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfScheduleEntity = new EntityInsertionAdapter<ScheduleEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `schedules` (`id`,`scheduleId`,`group`,`metadata`,`limit`,`priority`,`triggeredTime`,`scheduleStart`,`scheduleEnd`,`editGracePeriod`,`interval`,`scheduleType`,`data`,`count`,`executionState`,`executionStateChangeDate`,`triggerContext`,`appState`,`screens`,`seconds`,`regionId`,`audience`,`campaigns`,`reportingContext`,`frequencyConstraintIds`,`messageType`,`bypassHoldoutGroups`,`newUserEvaluationDate`,`productId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ScheduleEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.scheduleId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.scheduleId);
                }
                if (value.group == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.group);
                }
                String _tmp = AutomationDao_Impl.this.__jsonTypeConverters.jsonMapToString(value.metadata);
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.limit);
                stmt.bindLong(6, (long)value.priority);
                stmt.bindLong(7, value.triggeredTime);
                stmt.bindLong(8, value.scheduleStart);
                stmt.bindLong(9, value.scheduleEnd);
                stmt.bindLong(10, value.editGracePeriod);
                stmt.bindLong(11, value.interval);
                if (value.scheduleType == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.scheduleType);
                }
                String _tmp_1 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.data);
                if (_tmp_1 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_1);
                }
                stmt.bindLong(14, (long)value.count);
                stmt.bindLong(15, (long)value.executionState);
                stmt.bindLong(16, value.executionStateChangeDate);
                String _tmp_2 = AutomationDao_Impl.this.__converters.triggerContextToString(value.triggerContext);
                if (_tmp_2 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_2);
                }
                stmt.bindLong(18, (long)value.appState);
                String _tmp_3 = Converters.fromArrayList(value.screens);
                if (_tmp_3 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_3);
                }
                stmt.bindLong(20, value.seconds);
                if (value.regionId == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.regionId);
                }
                String _tmp_4 = AutomationDao_Impl.this.__converters.audienceToString(value.audience);
                if (_tmp_4 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_4);
                }
                String _tmp_5 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.campaigns);
                if (_tmp_5 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_5);
                }
                String _tmp_6 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.reportingContext);
                if (_tmp_6 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_6);
                }
                String _tmp_7 = Converters.fromArrayList(value.frequencyConstraintIds);
                if (_tmp_7 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_7);
                }
                if (value.messageType == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, value.messageType);
                }
                int _tmp_8 = value.bypassHoldoutGroups ? 1 : 0;
                stmt.bindLong(27, (long)_tmp_8);
                stmt.bindLong(28, value.newUserEvaluationDate);
                if (value.productId == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindString(29, value.productId);
                }
            }
        };
        this.__insertionAdapterOfTriggerEntity = new EntityInsertionAdapter<TriggerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `triggers` (`id`,`triggerType`,`goal`,`jsonPredicate`,`isCancellation`,`progress`,`parentScheduleId`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TriggerEntity value) {
                stmt.bindLong(1, (long)value.id);
                stmt.bindLong(2, (long)value.triggerType);
                stmt.bindDouble(3, value.goal);
                String _tmp = AutomationDao_Impl.this.__jsonTypeConverters.jsonPredicateToString(value.jsonPredicate);
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isCancellation ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                stmt.bindDouble(6, value.progress);
                if (value.parentScheduleId == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.parentScheduleId);
                }
            }
        };
        this.__deletionAdapterOfScheduleEntity = new EntityDeletionOrUpdateAdapter<ScheduleEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `schedules` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ScheduleEntity value) {
                stmt.bindLong(1, (long)value.id);
            }
        };
        this.__updateAdapterOfScheduleEntity = new EntityDeletionOrUpdateAdapter<ScheduleEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `schedules` SET `id` = ?,`scheduleId` = ?,`group` = ?,`metadata` = ?,`limit` = ?,`priority` = ?,`triggeredTime` = ?,`scheduleStart` = ?,`scheduleEnd` = ?,`editGracePeriod` = ?,`interval` = ?,`scheduleType` = ?,`data` = ?,`count` = ?,`executionState` = ?,`executionStateChangeDate` = ?,`triggerContext` = ?,`appState` = ?,`screens` = ?,`seconds` = ?,`regionId` = ?,`audience` = ?,`campaigns` = ?,`reportingContext` = ?,`frequencyConstraintIds` = ?,`messageType` = ?,`bypassHoldoutGroups` = ?,`newUserEvaluationDate` = ?,`productId` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ScheduleEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.scheduleId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.scheduleId);
                }
                if (value.group == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.group);
                }
                String _tmp = AutomationDao_Impl.this.__jsonTypeConverters.jsonMapToString(value.metadata);
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.limit);
                stmt.bindLong(6, (long)value.priority);
                stmt.bindLong(7, value.triggeredTime);
                stmt.bindLong(8, value.scheduleStart);
                stmt.bindLong(9, value.scheduleEnd);
                stmt.bindLong(10, value.editGracePeriod);
                stmt.bindLong(11, value.interval);
                if (value.scheduleType == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.scheduleType);
                }
                String _tmp_1 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.data);
                if (_tmp_1 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_1);
                }
                stmt.bindLong(14, (long)value.count);
                stmt.bindLong(15, (long)value.executionState);
                stmt.bindLong(16, value.executionStateChangeDate);
                String _tmp_2 = AutomationDao_Impl.this.__converters.triggerContextToString(value.triggerContext);
                if (_tmp_2 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_2);
                }
                stmt.bindLong(18, (long)value.appState);
                String _tmp_3 = Converters.fromArrayList(value.screens);
                if (_tmp_3 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_3);
                }
                stmt.bindLong(20, value.seconds);
                if (value.regionId == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.regionId);
                }
                String _tmp_4 = AutomationDao_Impl.this.__converters.audienceToString(value.audience);
                if (_tmp_4 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_4);
                }
                String _tmp_5 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.campaigns);
                if (_tmp_5 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_5);
                }
                String _tmp_6 = AutomationDao_Impl.this.__jsonTypeConverters.jsonValueToString(value.reportingContext);
                if (_tmp_6 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_6);
                }
                String _tmp_7 = Converters.fromArrayList(value.frequencyConstraintIds);
                if (_tmp_7 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_7);
                }
                if (value.messageType == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, value.messageType);
                }
                int _tmp_8 = value.bypassHoldoutGroups ? 1 : 0;
                stmt.bindLong(27, (long)_tmp_8);
                stmt.bindLong(28, value.newUserEvaluationDate);
                if (value.productId == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindString(29, value.productId);
                }
                stmt.bindLong(30, (long)value.id);
            }
        };
        this.__updateAdapterOfTriggerEntity = new EntityDeletionOrUpdateAdapter<TriggerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `triggers` SET `id` = ?,`triggerType` = ?,`goal` = ?,`jsonPredicate` = ?,`isCancellation` = ?,`progress` = ?,`parentScheduleId` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TriggerEntity value) {
                stmt.bindLong(1, (long)value.id);
                stmt.bindLong(2, (long)value.triggerType);
                stmt.bindDouble(3, value.goal);
                String _tmp = AutomationDao_Impl.this.__jsonTypeConverters.jsonPredicateToString(value.jsonPredicate);
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isCancellation ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                stmt.bindDouble(6, value.progress);
                if (value.parentScheduleId == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.parentScheduleId);
                }
                stmt.bindLong(8, (long)value.id);
            }
        };
    }

    @Override
    public void insert(ScheduleEntity entity, List<TriggerEntity> entities) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfScheduleEntity.insert((Object)entity);
            this.__insertionAdapterOfTriggerEntity.insert(entities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ScheduleEntity entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfScheduleEntity.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ScheduleEntity entity, List<TriggerEntity> entities) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfScheduleEntity.handle((Object)entity);
            this.__updateAdapterOfTriggerEntity.handleMultiple(entities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateTriggers(List<TriggerEntity> entities) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfTriggerEntity.handleMultiple(entities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(Collection<FullSchedule> entries) {
        this.__db.beginTransaction();
        try {
            AutomationDao_Impl.super.insert(entries);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduleCount() {
        String _sql = "SELECT COUNT(*) FROM schedules";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM schedules", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedules() {
        String _sql = "SELECT * FROM schedules";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedules(Collection<String> scheduleIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM schedules WHERE (scheduleId IN (");
        int _inputSize = scheduleIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : scheduleIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item_1 = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedules(Collection<String> scheduleIds, String type) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM schedules WHERE (scheduleId IN (");
        int _inputSize = scheduleIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) AND (scheduleType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : scheduleIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item_1 = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedulesByType(String type) {
        String _sql = "SELECT * FROM schedules WHERE (scheduleType = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (scheduleType = ?)", (int)1);
        int _argIndex = 1;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FullSchedule getSchedule(String scheduleId) {
        String _sql = "SELECT * FROM schedules WHERE (scheduleId == ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (scheduleId == ?)", (int)1);
        int _argIndex = 1;
        if (scheduleId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, scheduleId);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            FullSchedule fullSchedule;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                FullSchedule _result;
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                if (_cursor.moveToFirst()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    _result = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                fullSchedule = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return fullSchedule;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FullSchedule getSchedule(String scheduleId, String type) {
        String _sql = "SELECT * FROM schedules WHERE (scheduleId == ?) AND (scheduleType = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (scheduleId == ?) AND (scheduleType = ?)", (int)2);
        int _argIndex = 1;
        if (scheduleId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, scheduleId);
        }
        _argIndex = 2;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            FullSchedule fullSchedule;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                FullSchedule _result;
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                if (_cursor.moveToFirst()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    _result = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                fullSchedule = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return fullSchedule;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedulesWithGroup(String group, String type) {
        String _sql = "SELECT * FROM schedules WHERE (`group` == ?) AND (scheduleType = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (`group` == ?) AND (scheduleType = ?)", (int)2);
        int _argIndex = 1;
        if (group == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, group);
        }
        _argIndex = 2;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedulesWithGroup(String group) {
        String _sql = "SELECT * FROM schedules WHERE (`group` == ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (`group` == ?)", (int)1);
        int _argIndex = 1;
        if (group == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, group);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getSchedulesWithStates(int ... executionStates) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM schedules WHERE (executionState IN (");
        int _inputSize = executionStates.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (int _item : executionStates) {
            _statement.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item_1 = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FullSchedule> getActiveExpiredSchedules() {
        String _sql = "SELECT * FROM schedules WHERE (executionState != 4) AND (scheduleEnd >= 0) AND (scheduleEnd <= strftime('%s', 'now') * 1000)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM schedules WHERE (executionState != 4) AND (scheduleEnd >= 0) AND (scheduleEnd <= strftime('%s', 'now') * 1000)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<FullSchedule> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleId");
                int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                int _cursorIndexOfLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"limit");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                int _cursorIndexOfTriggeredTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggeredTime");
                int _cursorIndexOfScheduleStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleStart");
                int _cursorIndexOfScheduleEnd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEnd");
                int _cursorIndexOfEditGracePeriod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editGracePeriod");
                int _cursorIndexOfInterval = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval");
                int _cursorIndexOfScheduleType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleType");
                int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                int _cursorIndexOfCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"count");
                int _cursorIndexOfExecutionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionState");
                int _cursorIndexOfExecutionStateChangeDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"executionStateChangeDate");
                int _cursorIndexOfTriggerContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerContext");
                int _cursorIndexOfAppState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appState");
                int _cursorIndexOfScreens = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"screens");
                int _cursorIndexOfSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seconds");
                int _cursorIndexOfRegionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"regionId");
                int _cursorIndexOfAudience = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"audience");
                int _cursorIndexOfCampaigns = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"campaigns");
                int _cursorIndexOfReportingContext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportingContext");
                int _cursorIndexOfFrequencyConstraintIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frequencyConstraintIds");
                int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
                int _cursorIndexOfBypassHoldoutGroups = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bypassHoldoutGroups");
                int _cursorIndexOfNewUserEvaluationDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"newUserEvaluationDate");
                int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
                ArrayMap _collectionTriggers = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTriggersCollection;
                    if (_cursor.isNull(_cursorIndexOfScheduleId) || (_tmpTriggersCollection = (ArrayList)_collectionTriggers.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfScheduleId)))) != null) continue;
                    _tmpTriggersCollection = new ArrayList();
                    _collectionTriggers.put((Object)_tmpKey, _tmpTriggersCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_collectionTriggers);
                ArrayList<FullSchedule> _result = new ArrayList<FullSchedule>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ScheduleEntity _tmpSchedule;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfScheduleId) && _cursor.isNull(_cursorIndexOfGroup) && _cursor.isNull(_cursorIndexOfMetadata) && _cursor.isNull(_cursorIndexOfLimit) && _cursor.isNull(_cursorIndexOfPriority) && _cursor.isNull(_cursorIndexOfTriggeredTime) && _cursor.isNull(_cursorIndexOfScheduleStart) && _cursor.isNull(_cursorIndexOfScheduleEnd) && _cursor.isNull(_cursorIndexOfEditGracePeriod) && _cursor.isNull(_cursorIndexOfInterval) && _cursor.isNull(_cursorIndexOfScheduleType) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfCount) && _cursor.isNull(_cursorIndexOfExecutionState) && _cursor.isNull(_cursorIndexOfExecutionStateChangeDate) && _cursor.isNull(_cursorIndexOfTriggerContext) && _cursor.isNull(_cursorIndexOfAppState) && _cursor.isNull(_cursorIndexOfScreens) && _cursor.isNull(_cursorIndexOfSeconds) && _cursor.isNull(_cursorIndexOfRegionId) && _cursor.isNull(_cursorIndexOfAudience) && _cursor.isNull(_cursorIndexOfCampaigns) && _cursor.isNull(_cursorIndexOfReportingContext) && _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) && _cursor.isNull(_cursorIndexOfMessageType) && _cursor.isNull(_cursorIndexOfBypassHoldoutGroups) && _cursor.isNull(_cursorIndexOfNewUserEvaluationDate) && _cursor.isNull(_cursorIndexOfProductId))) {
                        _tmpSchedule = new ScheduleEntity();
                        _tmpSchedule.id = _cursor.getInt(_cursorIndexOfId);
                        _tmpSchedule.scheduleId = _cursor.isNull(_cursorIndexOfScheduleId) ? null : _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpSchedule.group = _cursor.isNull(_cursorIndexOfGroup) ? null : _cursor.getString(_cursorIndexOfGroup);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        _tmpSchedule.metadata = this.__jsonTypeConverters.jsonMapFromString(_tmp);
                        _tmpSchedule.limit = _cursor.getInt(_cursorIndexOfLimit);
                        _tmpSchedule.priority = _cursor.getInt(_cursorIndexOfPriority);
                        _tmpSchedule.triggeredTime = _cursor.getLong(_cursorIndexOfTriggeredTime);
                        _tmpSchedule.scheduleStart = _cursor.getLong(_cursorIndexOfScheduleStart);
                        _tmpSchedule.scheduleEnd = _cursor.getLong(_cursorIndexOfScheduleEnd);
                        _tmpSchedule.editGracePeriod = _cursor.getLong(_cursorIndexOfEditGracePeriod);
                        _tmpSchedule.interval = _cursor.getLong(_cursorIndexOfInterval);
                        _tmpSchedule.scheduleType = _cursor.isNull(_cursorIndexOfScheduleType) ? null : _cursor.getString(_cursorIndexOfScheduleType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        _tmpSchedule.data = this.__jsonTypeConverters.jsonValueFromString(_tmp_1);
                        _tmpSchedule.count = _cursor.getInt(_cursorIndexOfCount);
                        _tmpSchedule.executionState = _cursor.getInt(_cursorIndexOfExecutionState);
                        _tmpSchedule.executionStateChangeDate = _cursor.getLong(_cursorIndexOfExecutionStateChangeDate);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTriggerContext) ? null : _cursor.getString(_cursorIndexOfTriggerContext);
                        _tmpSchedule.triggerContext = this.__converters.triggerContextFromString(_tmp_2);
                        _tmpSchedule.appState = _cursor.getInt(_cursorIndexOfAppState);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScreens) ? null : _cursor.getString(_cursorIndexOfScreens);
                        _tmpSchedule.screens = Converters.stringArrayFromString(_tmp_3);
                        _tmpSchedule.seconds = _cursor.getLong(_cursorIndexOfSeconds);
                        _tmpSchedule.regionId = _cursor.isNull(_cursorIndexOfRegionId) ? null : _cursor.getString(_cursorIndexOfRegionId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAudience) ? null : _cursor.getString(_cursorIndexOfAudience);
                        _tmpSchedule.audience = this.__converters.audienceFromString(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCampaigns) ? null : _cursor.getString(_cursorIndexOfCampaigns);
                        _tmpSchedule.campaigns = this.__jsonTypeConverters.jsonValueFromString(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReportingContext) ? null : _cursor.getString(_cursorIndexOfReportingContext);
                        _tmpSchedule.reportingContext = this.__jsonTypeConverters.jsonValueFromString(_tmp_6);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfFrequencyConstraintIds) ? null : _cursor.getString(_cursorIndexOfFrequencyConstraintIds);
                        _tmpSchedule.frequencyConstraintIds = Converters.stringArrayFromString(_tmp_7);
                        _tmpSchedule.messageType = _cursor.isNull(_cursorIndexOfMessageType) ? null : _cursor.getString(_cursorIndexOfMessageType);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfBypassHoldoutGroups);
                        _tmpSchedule.bypassHoldoutGroups = _tmp_8 != 0;
                        _tmpSchedule.newUserEvaluationDate = _cursor.getLong(_cursorIndexOfNewUserEvaluationDate);
                        _tmpSchedule.productId = _cursor.isNull(_cursorIndexOfProductId) ? null : _cursor.getString(_cursorIndexOfProductId);
                    } else {
                        _tmpSchedule = null;
                    }
                    ArrayList _tmpTriggersCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfScheduleId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfScheduleId);
                        _tmpTriggersCollection_1 = (ArrayList)_collectionTriggers.get((Object)_tmpKey_1);
                    }
                    if (_tmpTriggersCollection_1 == null) {
                        _tmpTriggersCollection_1 = new ArrayList();
                    }
                    FullSchedule _item = new FullSchedule(_tmpSchedule, _tmpTriggersCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerEntity> getActiveTriggers(int type, String scheduleId) {
        String _sql = "SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId WHERE (schedules.scheduleId = ?)AND (triggers.triggerType = ?) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId WHERE (schedules.scheduleId = ?)AND (triggers.triggerType = ?) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)", (int)2);
        int _argIndex = 1;
        if (scheduleId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, scheduleId);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)type);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTriggerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerType");
            int _cursorIndexOfGoal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"goal");
            int _cursorIndexOfJsonPredicate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"jsonPredicate");
            int _cursorIndexOfIsCancellation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isCancellation");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfParentScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentScheduleId");
            ArrayList<TriggerEntity> _result = new ArrayList<TriggerEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                TriggerEntity _item = new TriggerEntity();
                _item.id = _cursor.getInt(_cursorIndexOfId);
                _item.triggerType = _cursor.getInt(_cursorIndexOfTriggerType);
                _item.goal = _cursor.getDouble(_cursorIndexOfGoal);
                String _tmp = _cursor.isNull(_cursorIndexOfJsonPredicate) ? null : _cursor.getString(_cursorIndexOfJsonPredicate);
                _item.jsonPredicate = this.__jsonTypeConverters.jsonPredicateFromString(_tmp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsCancellation);
                _item.isCancellation = _tmp_1 != 0;
                _item.progress = _cursor.getDouble(_cursorIndexOfProgress);
                _item.parentScheduleId = _cursor.isNull(_cursorIndexOfParentScheduleId) ? null : _cursor.getString(_cursorIndexOfParentScheduleId);
                _result.add(_item);
            }
            ArrayList<TriggerEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerEntity> getActiveTriggers(int type) {
        String _sql = "SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId AND (triggers.triggerType = ?) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT triggers.* FROM triggers JOIN schedules ON schedules.scheduleId = triggers.parentScheduleId AND (triggers.triggerType = ?) AND ((triggers.isCancellation = 1 AND + schedules.executionState IN (1,5,6))OR (triggers.isCancellation = 0 AND + schedules.executionState = 0))AND (schedules.scheduleStart < 0 OR schedules.scheduleStart <= strftime('%s', 'now') * 1000)", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)type);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTriggerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"triggerType");
            int _cursorIndexOfGoal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"goal");
            int _cursorIndexOfJsonPredicate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"jsonPredicate");
            int _cursorIndexOfIsCancellation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isCancellation");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfParentScheduleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentScheduleId");
            ArrayList<TriggerEntity> _result = new ArrayList<TriggerEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                TriggerEntity _item = new TriggerEntity();
                _item.id = _cursor.getInt(_cursorIndexOfId);
                _item.triggerType = _cursor.getInt(_cursorIndexOfTriggerType);
                _item.goal = _cursor.getDouble(_cursorIndexOfGoal);
                String _tmp = _cursor.isNull(_cursorIndexOfJsonPredicate) ? null : _cursor.getString(_cursorIndexOfJsonPredicate);
                _item.jsonPredicate = this.__jsonTypeConverters.jsonPredicateFromString(_tmp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsCancellation);
                _item.isCancellation = _tmp_1 != 0;
                _item.progress = _cursor.getDouble(_cursorIndexOfProgress);
                _item.parentScheduleId = _cursor.isNull(_cursorIndexOfParentScheduleId) ? null : _cursor.getString(_cursorIndexOfParentScheduleId);
                _result.add(_item);
            }
            ArrayList<TriggerEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity(ArrayMap<String, ArrayList<TriggerEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshiptriggersAscomUrbanairshipAutomationStorageTriggerEntity((ArrayMap<String, ArrayList<TriggerEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `id`,`triggerType`,`goal`,`jsonPredicate`,`isCancellation`,`progress`,`parentScheduleId` FROM `triggers` WHERE `parentScheduleId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"parentScheduleId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfId = false;
            boolean _cursorIndexOfTriggerType = true;
            int _cursorIndexOfGoal = 2;
            int _cursorIndexOfJsonPredicate = 3;
            int _cursorIndexOfIsCancellation = 4;
            int _cursorIndexOfProgress = 5;
            int _cursorIndexOfParentScheduleId = 6;
            while (_cursor.moveToNext()) {
                String _tmpKey;
                ArrayList _tmpRelation;
                if (_cursor.isNull(_itemKeyIndex) || (_tmpRelation = (ArrayList)_map.get((Object)(_tmpKey = _cursor.getString(_itemKeyIndex)))) == null) continue;
                TriggerEntity _item_1 = new TriggerEntity();
                _item_1.id = _cursor.getInt(0);
                _item_1.triggerType = _cursor.getInt(1);
                _item_1.goal = _cursor.getDouble(2);
                String _tmp = _cursor.isNull(3) ? null : _cursor.getString(3);
                _item_1.jsonPredicate = this.__jsonTypeConverters.jsonPredicateFromString(_tmp);
                int _tmp_1 = _cursor.getInt(4);
                _item_1.isCancellation = _tmp_1 != 0;
                _item_1.progress = _cursor.getDouble(5);
                _item_1.parentScheduleId = _cursor.isNull(6) ? null : _cursor.getString(6);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

