/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.Converters;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.json.JsonTypeConverters;
import java.io.File;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Database(entities={ScheduleEntity.class, TriggerEntity.class}, version=7)
@TypeConverters(value={Converters.class, JsonTypeConverters.class})
public abstract class AutomationDatabase
extends RoomDatabase {
    private static final Migration MIGRATION_1_2 = new Migration(1, 2){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN campaigns TEXT");
        }
    };
    private static final Migration MIGRATION_2_3 = new Migration(2, 3){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN frequencyConstraintIds TEXT");
        }
    };
    private static final Migration MIGRATION_3_4 = new Migration(3, 4){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN reportingContext TEXT");
        }
    };
    private static final Migration MIGRATION_4_5 = new Migration(4, 5){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN messageType TEXT");
            database.execSQL("ALTER TABLE schedules  ADD COLUMN bypassHoldoutGroups INTEGER NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE schedules  ADD COLUMN newUserEvaluationDate INTEGER NOT NULL DEFAULT 0");
        }
    };
    private static final Migration MIGRATION_5_6 = new Migration(5, 6){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN triggeredTime INTEGER NOT NULL DEFAULT -1");
        }
    };
    private static final Migration MIGRATION_6_7 = new Migration(6, 7){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE schedules  ADD COLUMN productId TEXT");
        }
    };

    public abstract AutomationDao getScheduleDao();

    public static AutomationDatabase createDatabase(@NonNull Context context, @NonNull AirshipRuntimeConfig config) {
        String name = config.getConfigOptions().appKey + "_in-app-automation";
        String path = new File(ContextCompat.getNoBackupFilesDir((Context)context), name).getAbsolutePath();
        return (AutomationDatabase)Room.databaseBuilder((Context)context, AutomationDatabase.class, (String)path).addMigrations(new Migration[]{MIGRATION_1_2, MIGRATION_2_3, MIGRATION_3_4, MIGRATION_4_5, MIGRATION_5_6, MIGRATION_6_7}).fallbackToDestructiveMigrationOnDowngrade().build();
    }
}

