/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.AutomationDao_Impl;
import com.urbanairship.automation.storage.AutomationDatabase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AutomationDatabase_Impl
extends AutomationDatabase {
    private volatile AutomationDao _automationDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(7){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `schedules` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `scheduleId` TEXT, `group` TEXT, `metadata` TEXT, `limit` INTEGER NOT NULL, `priority` INTEGER NOT NULL, `triggeredTime` INTEGER NOT NULL, `scheduleStart` INTEGER NOT NULL, `scheduleEnd` INTEGER NOT NULL, `editGracePeriod` INTEGER NOT NULL, `interval` INTEGER NOT NULL, `scheduleType` TEXT, `data` TEXT, `count` INTEGER NOT NULL, `executionState` INTEGER NOT NULL, `executionStateChangeDate` INTEGER NOT NULL, `triggerContext` TEXT, `appState` INTEGER NOT NULL, `screens` TEXT, `seconds` INTEGER NOT NULL, `regionId` TEXT, `audience` TEXT, `campaigns` TEXT, `reportingContext` TEXT, `frequencyConstraintIds` TEXT, `messageType` TEXT, `bypassHoldoutGroups` INTEGER NOT NULL, `newUserEvaluationDate` INTEGER NOT NULL, `productId` TEXT)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_schedules_scheduleId` ON `schedules` (`scheduleId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `triggers` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `triggerType` INTEGER NOT NULL, `goal` REAL NOT NULL, `jsonPredicate` TEXT, `isCancellation` INTEGER NOT NULL, `progress` REAL NOT NULL, `parentScheduleId` TEXT, FOREIGN KEY(`parentScheduleId`) REFERENCES `schedules`(`scheduleId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_triggers_parentScheduleId` ON `triggers` (`parentScheduleId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'f23110813aae29e5e5a4a4e90483e487')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `schedules`");
                _db.execSQL("DROP TABLE IF EXISTS `triggers`");
                if (AutomationDatabase_Impl.this.mCallbacks != null) {
                    int _size = AutomationDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AutomationDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (AutomationDatabase_Impl.this.mCallbacks != null) {
                    int _size = AutomationDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AutomationDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AutomationDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                AutomationDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (AutomationDatabase_Impl.this.mCallbacks != null) {
                    int _size = AutomationDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AutomationDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsSchedules = new HashMap<String, TableInfo.Column>(29);
                _columnsSchedules.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsSchedules.put("scheduleId", new TableInfo.Column("scheduleId", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("group", new TableInfo.Column("group", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("limit", new TableInfo.Column("limit", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("priority", new TableInfo.Column("priority", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("triggeredTime", new TableInfo.Column("triggeredTime", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("scheduleStart", new TableInfo.Column("scheduleStart", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("scheduleEnd", new TableInfo.Column("scheduleEnd", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("editGracePeriod", new TableInfo.Column("editGracePeriod", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("interval", new TableInfo.Column("interval", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("scheduleType", new TableInfo.Column("scheduleType", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("data", new TableInfo.Column("data", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("count", new TableInfo.Column("count", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("executionState", new TableInfo.Column("executionState", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("executionStateChangeDate", new TableInfo.Column("executionStateChangeDate", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("triggerContext", new TableInfo.Column("triggerContext", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("appState", new TableInfo.Column("appState", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("screens", new TableInfo.Column("screens", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("seconds", new TableInfo.Column("seconds", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("regionId", new TableInfo.Column("regionId", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("audience", new TableInfo.Column("audience", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("campaigns", new TableInfo.Column("campaigns", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("reportingContext", new TableInfo.Column("reportingContext", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("frequencyConstraintIds", new TableInfo.Column("frequencyConstraintIds", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("messageType", new TableInfo.Column("messageType", "TEXT", false, 0, null, 1));
                _columnsSchedules.put("bypassHoldoutGroups", new TableInfo.Column("bypassHoldoutGroups", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("newUserEvaluationDate", new TableInfo.Column("newUserEvaluationDate", "INTEGER", true, 0, null, 1));
                _columnsSchedules.put("productId", new TableInfo.Column("productId", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysSchedules = new HashSet(0);
                HashSet<TableInfo.Index> _indicesSchedules = new HashSet<TableInfo.Index>(1);
                _indicesSchedules.add(new TableInfo.Index("index_schedules_scheduleId", true, Arrays.asList("scheduleId"), Arrays.asList("ASC")));
                TableInfo _infoSchedules = new TableInfo("schedules", _columnsSchedules, _foreignKeysSchedules, _indicesSchedules);
                TableInfo _existingSchedules = TableInfo.read((SupportSQLiteDatabase)_db, (String)"schedules");
                if (!_infoSchedules.equals((Object)_existingSchedules)) {
                    return new RoomOpenHelper.ValidationResult(false, "schedules(com.urbanairship.automation.storage.ScheduleEntity).\n Expected:\n" + _infoSchedules + "\n Found:\n" + _existingSchedules);
                }
                HashMap<String, TableInfo.Column> _columnsTriggers = new HashMap<String, TableInfo.Column>(7);
                _columnsTriggers.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsTriggers.put("triggerType", new TableInfo.Column("triggerType", "INTEGER", true, 0, null, 1));
                _columnsTriggers.put("goal", new TableInfo.Column("goal", "REAL", true, 0, null, 1));
                _columnsTriggers.put("jsonPredicate", new TableInfo.Column("jsonPredicate", "TEXT", false, 0, null, 1));
                _columnsTriggers.put("isCancellation", new TableInfo.Column("isCancellation", "INTEGER", true, 0, null, 1));
                _columnsTriggers.put("progress", new TableInfo.Column("progress", "REAL", true, 0, null, 1));
                _columnsTriggers.put("parentScheduleId", new TableInfo.Column("parentScheduleId", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysTriggers = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysTriggers.add(new TableInfo.ForeignKey("schedules", "CASCADE", "NO ACTION", Arrays.asList("parentScheduleId"), Arrays.asList("scheduleId")));
                HashSet<TableInfo.Index> _indicesTriggers = new HashSet<TableInfo.Index>(1);
                _indicesTriggers.add(new TableInfo.Index("index_triggers_parentScheduleId", false, Arrays.asList("parentScheduleId"), Arrays.asList("ASC")));
                TableInfo _infoTriggers = new TableInfo("triggers", _columnsTriggers, _foreignKeysTriggers, _indicesTriggers);
                TableInfo _existingTriggers = TableInfo.read((SupportSQLiteDatabase)_db, (String)"triggers");
                if (!_infoTriggers.equals((Object)_existingTriggers)) {
                    return new RoomOpenHelper.ValidationResult(false, "triggers(com.urbanairship.automation.storage.TriggerEntity).\n Expected:\n" + _infoTriggers + "\n Found:\n" + _existingTriggers);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "f23110813aae29e5e5a4a4e90483e487", "08b50f94d776593fa3d227772cfcefa3");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"schedules", "triggers"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `schedules`");
            _db.execSQL("DELETE FROM `triggers`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(AutomationDao.class, AutomationDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutomationDao getScheduleDao() {
        if (this._automationDao != null) {
            return this._automationDao;
        }
        AutomationDatabase_Impl automationDatabase_Impl = this;
        synchronized (automationDatabase_Impl) {
            if (this._automationDao == null) {
                this._automationDao = new AutomationDao_Impl(this);
            }
            return this._automationDao;
        }
    }
}

