/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import androidx.annotation.RestrictTo;
import androidx.room.TypeConverter;
import com.urbanairship.UALog;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.TriggerContext;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Converters {
    @TypeConverter
    public String triggerContextToString(TriggerContext context) {
        return context == null ? null : context.toJsonValue().toString();
    }

    @TypeConverter
    public TriggerContext triggerContextFromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            return TriggerContext.fromJson(JsonValue.parseString((String)value));
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)("Unable to parse trigger context: " + value), (Object[])new Object[0]);
            return null;
        }
    }

    @TypeConverter
    public String audienceToString(AudienceSelector audience) {
        return audience == null ? null : audience.toJsonValue().toString();
    }

    @TypeConverter
    public AudienceSelector audienceFromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            return AudienceSelector.Companion.fromJson(JsonValue.parseString((String)value));
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)("Unable to parse audience: " + value), (Object[])new Object[0]);
            return null;
        }
    }

    @TypeConverter
    public static List<String> stringArrayFromString(String value) {
        try {
            ArrayList<String> array = new ArrayList<String>();
            for (JsonValue entry : JsonValue.parseString((String)value).optList()) {
                if (entry.getString() == null) continue;
                array.add(entry.optString());
            }
            return array;
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)("Unable to parse string array from string: " + value), (Object[])new Object[0]);
            return null;
        }
    }

    @TypeConverter
    public static String fromArrayList(List<String> list) {
        return JsonValue.wrapOpt(list).toString();
    }
}

