/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.UALog;
import com.urbanairship.util.DataManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LegacyDataManager
extends DataManager {
    private static final int DATABASE_VERSION = 6;
    private static final String GET_SCHEDULES_QUERY = "SELECT * FROM action_schedules a LEFT OUTER JOIN triggers b ON a.s_id=b.t_s_id";

    public LegacyDataManager(@NonNull Context context, @NonNull String appKey, @NonNull String dbName) {
        super(context, appKey, dbName, 6);
    }

    protected void onCreate(@NonNull SQLiteDatabase db) {
        UALog.d((String)"Creating automation database", (Object[])new Object[0]);
        db.execSQL("CREATE TABLE IF NOT EXISTS action_schedules (s_row_id INTEGER PRIMARY KEY AUTOINCREMENT,s_id TEXT UNIQUE,s_metadata TEXT,s_data TEXT,s_start INTEGER,s_end INTEGER,s_edit_grace_period INTEGER,s_execution_state_change_date INTEGER,s_count INTEGER,s_limit INTEGER,s_priority INTEGER,s_group TEXT,s_execution_state INTEGER,s_pending_execution_date DOUBLE,d_app_state INTEGER,d_region_id TEXT,d_screen TEXT,d_seconds DOUBLE,s_interval INTEGER,s_trigger_context TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS triggers (t_row_id INTEGER PRIMARY KEY AUTOINCREMENT,t_type INTEGER,t_cancellation INTEGER,t_s_id TEXT,t_predicate TEXT,t_progress DOUBLE,t_goal DOUBLE,FOREIGN KEY(t_s_id) REFERENCES action_schedules(s_id) ON DELETE CASCADE);");
        UALog.d((String)"Automation database created", (Object[])new Object[0]);
    }

    protected void onUpgrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
        String tempScheduleTableName = "temp_schedule_entry_table";
        String tempTriggersTableName = "temp_triggers_entry_table";
        String oldIdColumn = "_id";
        String oldActionsColumn = "s_actions";
        String oldPendingExecutionColumn = "s_is_pending_execution";
        switch (oldVersion) {
            case 1: {
                db.execSQL("BEGIN TRANSACTION;");
                db.execSQL("ALTER TABLE action_schedules RENAME TO " + tempScheduleTableName + ";");
                db.execSQL("ALTER TABLE triggers RENAME TO " + tempTriggersTableName + ";");
                db.execSQL("CREATE TABLE action_schedules (s_row_id INTEGER PRIMARY KEY AUTOINCREMENT,s_id TEXT UNIQUE," + oldActionsColumn + " TEXT," + "s_start" + " INTEGER," + "s_end" + " INTEGER," + "s_count" + " INTEGER," + "s_limit" + " INTEGER," + "s_group" + " TEXT," + oldPendingExecutionColumn + " INTEGER," + "s_pending_execution_date" + " DOUBLE," + "d_app_state" + " INTEGER," + "d_region_id" + " TEXT," + "d_screen" + " TEXT," + "d_seconds" + " DOUBLE);");
                db.execSQL("CREATE TABLE triggers(t_row_id INTEGER PRIMARY KEY AUTOINCREMENT,t_type INTEGER,t_cancellation INTEGER,t_s_id TEXT,t_predicate TEXT,t_progress DOUBLE,t_goal DOUBLE,FOREIGN KEY(t_s_id) REFERENCES action_schedules(s_id) ON DELETE CASCADE);");
                db.execSQL("INSERT INTO action_schedules(s_row_id, s_id, " + oldActionsColumn + ", " + "s_start" + ", " + "s_end" + ", " + "s_count" + ", " + "s_limit" + ", " + "s_priority" + ", " + "s_group" + ", " + oldPendingExecutionColumn + ", " + "s_pending_execution_date" + ", " + "d_app_state" + ", " + "d_region_id" + ", " + "d_screen" + ", " + "d_seconds" + ") SELECT " + oldIdColumn + ", " + "s_id" + ", " + oldActionsColumn + ", " + "s_start" + ", " + "s_end" + ", " + "s_count" + ", " + "s_limit" + ", " + "s_group" + ", 0, 0.0, 1, NULL, NULL, 0 FROM " + tempScheduleTableName + ";");
                db.execSQL("INSERT INTO triggers(t_row_id, t_type, t_cancellation, t_s_id, t_predicate, t_progress, t_goal) SELECT " + oldIdColumn + ", " + "t_type" + ", 0, " + "t_s_id" + ", " + "t_predicate" + ", " + "t_progress" + ", " + "t_goal" + " FROM " + tempTriggersTableName + ";");
                db.execSQL("DROP TABLE " + tempScheduleTableName + ";");
                db.execSQL("DROP TABLE " + tempTriggersTableName + ";");
                db.execSQL("COMMIT;");
            }
            case 2: {
                db.execSQL("BEGIN TRANSACTION;");
                db.execSQL("ALTER TABLE action_schedules RENAME TO " + tempScheduleTableName + ";");
                db.execSQL("ALTER TABLE triggers RENAME TO " + tempTriggersTableName + ";");
                db.execSQL("CREATE TABLE action_schedules (s_row_id INTEGER PRIMARY KEY AUTOINCREMENT,s_id TEXT UNIQUE,s_data TEXT,s_start INTEGER,s_end INTEGER,s_count INTEGER,s_limit INTEGER,s_priority INTEGER,s_group TEXT,s_execution_state INTEGER,s_pending_execution_date DOUBLE,d_app_state INTEGER,d_region_id TEXT,d_screen TEXT,d_seconds DOUBLE);");
                db.execSQL("CREATE TABLE IF NOT EXISTS triggers (t_row_id INTEGER PRIMARY KEY AUTOINCREMENT,t_type INTEGER,t_cancellation INTEGER,t_s_id TEXT,t_predicate TEXT,t_progress DOUBLE,t_goal DOUBLE,FOREIGN KEY(t_s_id) REFERENCES action_schedules(s_id) ON DELETE CASCADE);");
                db.execSQL("INSERT INTO action_schedules(s_row_id, s_id, s_data, s_start, s_end, s_count, s_limit, s_priority, s_group, s_execution_state, s_pending_execution_date, d_app_state, d_region_id, d_screen, d_seconds) SELECT s_row_id, s_id, " + oldActionsColumn + ", " + "s_start" + ", " + "s_end" + ", " + "s_count" + ", " + "s_limit" + ", 0, " + "s_group" + ", " + oldPendingExecutionColumn + ", " + "s_pending_execution_date" + ", " + "d_app_state" + ", " + "d_region_id" + ", " + "d_screen" + ", " + "d_seconds" + " FROM " + tempScheduleTableName + ";");
                db.execSQL("INSERT INTO triggers(t_row_id, t_type, t_cancellation, t_s_id, t_predicate, t_progress, t_goal) SELECT t_row_id, t_type, t_cancellation, t_s_id, t_predicate, t_progress, t_goal FROM " + tempTriggersTableName + ";");
                db.execSQL("DROP TABLE " + tempScheduleTableName + ";");
                db.execSQL("DROP TABLE " + tempTriggersTableName + ";");
                db.execSQL("COMMIT;");
            }
            case 3: {
                db.execSQL("BEGIN TRANSACTION;");
                db.execSQL("ALTER TABLE action_schedules ADD COLUMN s_execution_state_change_date INTEGER;");
                db.execSQL("ALTER TABLE action_schedules ADD COLUMN s_edit_grace_period INTEGER;");
                db.execSQL("ALTER TABLE action_schedules ADD COLUMN s_interval INTEGER;");
                db.execSQL("COMMIT;");
            }
            case 4: {
                db.execSQL("BEGIN TRANSACTION;");
                db.execSQL("ALTER TABLE action_schedules ADD COLUMN s_metadata TEXT;");
                db.execSQL("COMMIT;");
                break;
            }
            case 5: {
                db.execSQL("BEGIN TRANSACTION;");
                db.execSQL("ALTER TABLE action_schedules ADD COLUMN s_trigger_context TEXT;");
                db.execSQL("COMMIT;");
                break;
            }
            default: {
                db.execSQL("DROP TABLE IF EXISTS action_schedules");
                db.execSQL("DROP TABLE IF EXISTS triggers");
                this.onCreate(db);
            }
        }
    }

    protected void onDowngrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
        UALog.d((String)"Dropping automation database. Downgrading from version %s to %s", (Object[])new Object[]{oldVersion, newVersion});
        db.execSQL("DROP TABLE IF EXISTS triggers");
        db.execSQL("DROP TABLE IF EXISTS action_schedules");
        this.onCreate(db);
    }

    @TargetApi(value=16)
    protected void onConfigure(@NonNull SQLiteDatabase db) {
        super.onConfigure(db);
        db.setForeignKeyConstraintsEnabled(true);
    }

    public void deleteAllSchedules() {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.execSQL("DROP TABLE IF EXISTS triggers");
            db.execSQL("DROP TABLE IF EXISTS action_schedules");
            db.close();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to delete schedules.", (Object[])new Object[0]);
        }
    }

    public Cursor querySchedules() {
        try {
            return this.rawQuery(GET_SCHEDULES_QUERY, null);
        }
        catch (SQLException e) {
            UALog.e((Throwable)e, (String)"LegacyAutomationDataManager - Unable to get schedules.", (Object[])new Object[0]);
            return null;
        }
    }

    public static interface ScheduleTable {
        public static final String TABLE_NAME = "action_schedules";
        public static final String COLUMN_NAME_SCHEDULE_ID = "s_id";
        public static final String COLUMN_NAME_METADATA = "s_metadata";
        public static final String COLUMN_NAME_DATA = "s_data";
        public static final String COLUMN_NAME_LIMIT = "s_limit";
        public static final String COLUMN_NAME_PRIORITY = "s_priority";
        public static final String COLUMN_NAME_GROUP = "s_group";
        public static final String COLUMN_NAME_START = "s_start";
        public static final String COLUMN_NAME_END = "s_end";
        public static final String COLUMN_EDIT_GRACE_PERIOD = "s_edit_grace_period";
        public static final String COLUMN_NAME_INTERVAL = "s_interval";
        public static final String COLUMN_NAME_SECONDS = "d_seconds";
        public static final String COLUMN_NAME_SCREEN = "d_screen";
        public static final String COLUMN_NAME_APP_STATE = "d_app_state";
        public static final String COLUMN_NAME_REGION_ID = "d_region_id";
        public static final String COLUMN_NAME_EXECUTION_STATE = "s_execution_state";
        public static final String COLUMN_NAME_EXECUTION_STATE_CHANGE_DATE = "s_execution_state_change_date";
        public static final String COLUMN_NAME_DELAY_FINISH_DATE = "s_pending_execution_date";
        public static final String COLUMN_NAME_COUNT = "s_count";
        public static final String COLUMN_NAME_ID = "s_row_id";
        public static final String COLUMN_NAME_TRIGGER_CONTEXT = "s_trigger_context";
    }

    public static interface TriggerTable {
        public static final String COLUMN_NAME_ID = "t_row_id";
        public static final String TABLE_NAME = "triggers";
        public static final String COLUMN_NAME_TYPE = "t_type";
        public static final String COLUMN_NAME_SCHEDULE_ID = "t_s_id";
        public static final String COLUMN_NAME_PREDICATE = "t_predicate";
        public static final String COLUMN_NAME_PROGRESS = "t_progress";
        public static final String COLUMN_NAME_GOAL = "t_goal";
        public static final String COLUMN_NAME_IS_CANCELLATION = "t_cancellation";
    }
}

